/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.util.TaskRepositoryKeyringMigrator;
import org.eclipse.mylyn.internal.tasks.core.util.TaskRepositorySecureStoreMigrator;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryQuery;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.eclipse.mylyn.tasks.tests.util.TestUtils;

public class TaskRepositoryManagerTest
extends TestCase {
    private static final String DEFAULT_KIND = "mock";
    private static final String DEFAULT_URL = "http://eclipse.org";
    private static final String ANOTHER_URL = "http://codehaus.org";
    private final String USERNAME = ".username";
    private final String PASSWORD = ".password";
    private final String AUTH_REPOSITORY = "org.eclipse.mylyn.tasklist.repositories";
    private final String AUTH_PASSWORD = "org.eclipse.mylyn.tasklist.repositories.password";
    private final String AUTH_USERNAME = "org.eclipse.mylyn.tasklist.repositories.username";
    private static final String SECURE_CREDENTIALS_STORE_NODE_ID = "org.eclipse.mylyn.commons.repository";
    private final String AUTH_HTTP = "org.eclipse.mylyn.tasklist.repositories.httpauth";
    private final String AUTH_HTTP_PASSWORD = "org.eclipse.mylyn.tasklist.repositories.httpauth.password";
    private final String AUTH_HTTP_USERNAME = "org.eclipse.mylyn.tasklist.repositories.httpauth.username";
    private static final String AUTH_PROXY = "org.eclipse.mylyn.tasklist.repositories.proxy";
    private final String AUTH_PROXY_PASSWORD = "org.eclipse.mylyn.tasklist.repositories.proxy.password";
    private final String AUTH_PROXY_USERNAME = "org.eclipse.mylyn.tasklist.repositories.proxy.username";
    private final String AUTH_SCHEME = "Basic";
    private final String AUTH_REALM = "";
    private TaskRepositoryManager manager;

    protected void setUp() throws Exception {
        super.setUp();
        this.manager = TasksUiPlugin.getRepositoryManager();
        TaskRepositoryManagerTest.assertNotNull((Object)this.manager);
        this.manager.clearRepositories();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.manager != null) {
            this.manager.clearRepositories();
        }
    }

    public void testsUseSecureStorage() throws Exception {
        TaskRepository repository = new TaskRepository("bugzilla", "http://repository2/");
        this.flushAuthenticationCredentials(repository);
        repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("testUserName", "testPassword"), true);
        repository.setCredentials(AuthenticationType.HTTP, new AuthenticationCredentials("httpUserName", "httpPassword"), true);
        ISecurePreferences securePreferences = this.getSecurePreferences(repository);
        TaskRepositoryManagerTest.assertEquals((String)"testPassword", (String)securePreferences.get("org.eclipse.mylyn.tasklist.repositories.password", null));
        TaskRepositoryManagerTest.assertNull((Object)securePreferences.get("org.eclipse.mylyn.tasklist.repositories.username", null));
        TaskRepositoryManagerTest.assertEquals((String)"httpUserName", (String)securePreferences.get("org.eclipse.mylyn.tasklist.repositories.httpauth.username", null));
        TaskRepositoryManagerTest.assertEquals((String)"httpPassword", (String)securePreferences.get("org.eclipse.mylyn.tasklist.repositories.httpauth.password", null));
    }

    public void testsSaveCredentials() throws Exception {
        TaskRepository repository = new TaskRepository("bugzilla", "http://repository3/");
        repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("testUserName", "testPassword"), true);
        repository.setCredentials(AuthenticationType.HTTP, new AuthenticationCredentials("httpUserName", "httpPassword"), true);
        TaskRepositoryManagerTest.assertEquals((String)"testUserName", (String)repository.getCredentials(AuthenticationType.REPOSITORY).getUserName());
        TaskRepositoryManagerTest.assertEquals((String)"testPassword", (String)repository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
        TaskRepositoryManagerTest.assertEquals((String)"httpUserName", (String)repository.getCredentials(AuthenticationType.HTTP).getUserName());
        TaskRepositoryManagerTest.assertEquals((String)"httpPassword", (String)repository.getCredentials(AuthenticationType.HTTP).getPassword());
    }

    public void testMigrationFromKeyring() throws Exception {
        if (!TestUtils.isCompatibilityAuthInstalled()) {
            System.err.println("Skipping TaskRepositoryManagerTest.testMigrationFromKeyring()");
            return;
        }
        Map<String, String> authInfo = this.createAuthInfo();
        TaskRepository repository = new TaskRepository("bugzilla", "http://example.com/");
        this.flushAuthenticationCredentials(repository);
        Platform.addAuthorizationInfo((URL)new URL(repository.getUrl()), (String)"", (String)"Basic", authInfo);
        new TaskRepositoryKeyringMigrator("", "Basic").migrateCredentials(Collections.singleton(repository));
        this.assertCredentialsMigrated(repository);
        repository = new TaskRepository("bugzilla", "I am not a url.");
        this.flushAuthenticationCredentials(repository);
        Platform.addAuthorizationInfo((URL)new URL("http://eclipse.org/mylyn"), (String)repository.getUrl(), (String)"Basic", authInfo);
        new TaskRepositoryKeyringMigrator("", "Basic").migrateCredentials(Collections.singleton(repository));
        this.assertCredentialsMigrated(repository);
    }

    public void testMigrationFromKeyringAfterGetUserNameCalled() throws Exception {
        if (!TestUtils.isCompatibilityAuthInstalled()) {
            System.err.println("Skipping TaskRepositoryManagerTest.testMigrationFromKeyringAfterGetUserNameCalled()");
            return;
        }
        Map<String, String> authInfo = this.createAuthInfo();
        TaskRepository repository = new TaskRepository("bugzilla", "http://example.com/");
        this.flushAuthenticationCredentials(repository);
        Platform.addAuthorizationInfo((URL)new URL(repository.getUrl()), (String)"", (String)"Basic", authInfo);
        TaskRepositoryManagerTest.assertNull((Object)repository.getUserName());
        new TaskRepositoryKeyringMigrator("", "Basic").migrateCredentials(Collections.singleton(repository));
        TaskRepositoryManagerTest.assertNotNull((Object)repository.getUserName());
        TaskRepositoryManagerTest.assertTrue((boolean)repository.getUserName().equals("testuser"));
        this.assertCredentialsMigrated(repository);
    }

    private Map<String, String> createAuthInfo() {
        HashMap<String, String> authInfo = new HashMap<String, String>();
        authInfo.put("org.eclipse.mylyn.tasklist.repositories.username", "testuser");
        authInfo.put("org.eclipse.mylyn.tasklist.repositories.password", "testpassword");
        authInfo.put("org.eclipse.mylyn.tasklist.repositories.httpauth.username", "testhttpuser");
        authInfo.put("org.eclipse.mylyn.tasklist.repositories.httpauth.password", "testhttppassword");
        authInfo.put("org.eclipse.mylyn.tasklist.repositories.proxy.username", "testproxyuser");
        authInfo.put("org.eclipse.mylyn.tasklist.repositories.proxy.password", "testproxypassword");
        return authInfo;
    }

    public void testMigrationFromOldSecureStoreNode() throws Exception {
        TaskRepository repository = new TaskRepository("bugzilla", "http://example.com/");
        this.flushAuthenticationCredentials(repository);
        repository.setProperty("org.eclipse.mylyn.tasklist.repositories.username", "testuser");
        ISecurePreferences oldNode = SecurePreferencesFactory.getDefault().node("org.eclipse.mylyn.tasks.core");
        oldNode = oldNode.node(EncodingUtils.encodeSlashes((String)repository.getUrl()));
        oldNode.put("org.eclipse.mylyn.tasklist.repositories.password", "testpassword", true);
        oldNode.put("org.eclipse.mylyn.tasklist.repositories.httpauth.username", "testhttpuser", false);
        oldNode.put("org.eclipse.mylyn.tasklist.repositories.httpauth.password", "testhttppassword", true);
        oldNode.put("org.eclipse.mylyn.tasklist.repositories.proxy.username", "testproxyuser", false);
        oldNode.put("org.eclipse.mylyn.tasklist.repositories.proxy.password", "testproxypassword", true);
        new TaskRepositorySecureStoreMigrator().migrateCredentials(Collections.singleton(repository));
        this.assertCredentialsMigrated(repository);
    }

    private void assertCredentialsMigrated(TaskRepository repository) throws CoreException, MalformedURLException, StorageException {
        TaskRepositoryManagerTest.assertEquals((String)"testuser", (String)repository.getProperty("org.eclipse.mylyn.tasklist.repositories.username"));
        ISecurePreferences securePreferences = this.getSecurePreferences(repository);
        TaskRepositoryManagerTest.assertEquals((String)"testpassword", (String)securePreferences.get("org.eclipse.mylyn.tasklist.repositories.password", null));
        TaskRepositoryManagerTest.assertEquals((String)"testhttpuser", (String)securePreferences.get("org.eclipse.mylyn.tasklist.repositories.httpauth.username", null));
        TaskRepositoryManagerTest.assertEquals((String)"testhttppassword", (String)securePreferences.get("org.eclipse.mylyn.tasklist.repositories.httpauth.password", null));
        TaskRepositoryManagerTest.assertEquals((String)"testproxyuser", (String)securePreferences.get("org.eclipse.mylyn.tasklist.repositories.proxy.username", null));
        TaskRepositoryManagerTest.assertEquals((String)"testproxypassword", (String)securePreferences.get("org.eclipse.mylyn.tasklist.repositories.proxy.password", null));
        String[] stringArray = securePreferences.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            TaskRepositoryManagerTest.assertEquals((boolean)key.endsWith(".password"), (boolean)securePreferences.isEncrypted(key));
            ++n2;
        }
        TaskRepositoryManagerTest.assertEquals((String)"testpassword", (String)repository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
        TaskRepositoryManagerTest.assertEquals((String)"testhttpuser", (String)repository.getCredentials(AuthenticationType.HTTP).getUserName());
        TaskRepositoryManagerTest.assertEquals((String)"testhttppassword", (String)repository.getCredentials(AuthenticationType.HTTP).getPassword());
        TaskRepositoryManagerTest.assertEquals((String)"testproxyuser", (String)repository.getCredentials(AuthenticationType.PROXY).getUserName());
        TaskRepositoryManagerTest.assertEquals((String)"testproxypassword", (String)repository.getCredentials(AuthenticationType.PROXY).getPassword());
    }

    private ISecurePreferences getSecurePreferences(TaskRepository repository) {
        ISecurePreferences rootNode = SecurePreferencesFactory.getDefault().node(SECURE_CREDENTIALS_STORE_NODE_ID);
        return rootNode.node(EncodingUtils.encodeSlashes((String)repository.getUrl()));
    }

    private void flushAuthenticationCredentials(TaskRepository repository) {
        repository.flushAuthenticationCredentials();
        TaskRepositoryManagerTest.assertTrue((this.getSecurePreferences(repository).keys().length == 0 ? 1 : 0) != 0);
        repository.setProperty("org.eclipse.mylyn.tasklist.repositories.enabled", Boolean.toString(true));
        repository.setProperty("org.eclipse.mylyn.tasklist.repositories.httpauth.enabled", Boolean.toString(true));
        repository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.enabled", Boolean.toString(true));
    }

    public void testRepositoryWithSlash() throws MalformedURLException {
        TaskRepository repository1 = new TaskRepository("bugzilla", "http://repository1/");
        this.manager.addRepository(repository1);
        TaskRepositoryManagerTest.assertNotNull((Object)this.manager.getRepository("http://repository1"));
        TaskRepositoryManagerTest.assertNotNull((Object)this.manager.getRepository("http://repository1/"));
        TaskRepositoryManagerTest.assertNotNull((Object)this.manager.getRepository("bugzilla", "http://repository1"));
        TaskRepositoryManagerTest.assertNotNull((Object)this.manager.getRepository("bugzilla", "http://repository1/"));
    }

    public void testQueryDeletion() {
        TaskRepository repository = new TaskRepository(DEFAULT_KIND, "http://mockrepository.test");
        this.manager.addRepository(repository);
        MockTask task = new MockTask("1");
        MockRepositoryQuery query = new MockRepositoryQuery("Test");
        TasksUiPlugin.getTaskList().addQuery((RepositoryQuery)query);
        TasksUiPlugin.getTaskList().addTask((ITask)task, (AbstractTaskContainer)query);
        TaskRepositoryManagerTest.assertNotNull((Object)TasksUiPlugin.getTaskList().getTask(task.getHandleIdentifier()));
        TasksUiPlugin.getTaskList().deleteQuery((RepositoryQuery)query);
        AbstractTask task2 = TasksUiPlugin.getTaskList().getTask(task.getHandleIdentifier());
        TaskRepositoryManagerTest.assertNotNull((Object)task2);
        TaskRepositoryManagerTest.assertEquals((int)1, (int)task2.getParentContainers().size());
    }

    public void testHandles() {
        String url = "http://foo.bar";
        String id = "123";
        String handle = RepositoryTaskHandleUtil.getHandle((String)url, (String)id);
        TaskRepositoryManagerTest.assertEquals((String)url, (String)RepositoryTaskHandleUtil.getRepositoryUrl((String)handle));
        TaskRepositoryManagerTest.assertEquals((String)id, (String)RepositoryTaskHandleUtil.getTaskId((String)handle));
    }

    public void testMultipleNotAdded() throws MalformedURLException {
        TaskRepository repository = new TaskRepository(DEFAULT_KIND, DEFAULT_URL);
        this.manager.addRepository(repository);
        TaskRepository repository2 = new TaskRepository(DEFAULT_KIND, DEFAULT_URL);
        this.manager.addRepository(repository2);
        TaskRepositoryManagerTest.assertEquals((int)1, (int)this.manager.getAllRepositories().size());
    }

    public void testGet() throws MalformedURLException {
        TaskRepositoryManagerTest.assertEquals((String)"", (String)TasksUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.tasklist.repositories."));
        TaskRepository repository = new TaskRepository(DEFAULT_KIND, DEFAULT_URL);
        this.manager.addRepository(repository);
        TaskRepositoryManagerTest.assertEquals((Object)repository, (Object)this.manager.getRepository(DEFAULT_KIND, DEFAULT_URL));
        TaskRepositoryManagerTest.assertNull((Object)this.manager.getRepository(DEFAULT_KIND, "foo"));
        TaskRepositoryManagerTest.assertNull((Object)this.manager.getRepository("foo", DEFAULT_URL));
    }

    public void testConnectorAddition() {
        MockRepositoryConnector connector = new MockRepositoryConnector();
        this.manager.addRepositoryConnector((AbstractRepositoryConnector)connector);
        TaskRepositoryManagerTest.assertNotNull((Object)this.manager.getRepositoryConnector(connector.getConnectorKind()));
    }

    public void testRepositoryPersistance() throws Exception {
        TaskRepository repository1 = new TaskRepository("bugzilla", "http://bugzilla");
        TaskRepository repository2 = new TaskRepository("jira", "http://jira");
        TaskRepository repository3 = new TaskRepository("local", "http://local");
        this.manager.addRepository(repository3);
        this.manager.addRepository(repository1);
        this.manager.addRepository(repository2);
        TaskTestUtil.saveNow();
        TasksUiPlugin.getExternalizationManager().load();
        if (this.manager.getRepositoryConnector("bugzilla") != null) {
            TaskRepositoryManagerTest.assertTrue((boolean)this.manager.getAllRepositories().contains(repository1));
        }
        if (this.manager.getRepositoryConnector("jira") != null) {
            TaskRepositoryManagerTest.assertTrue((boolean)this.manager.getAllRepositories().contains(repository2));
        }
        TaskRepositoryManagerTest.assertTrue((boolean)this.manager.getAllRepositories().contains(repository3));
    }

    public void testRepositoryAttributePersistance() throws Exception {
        TaskRepositoryManagerTest.assertEquals((String)"", (String)TasksUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.tasklist.repositories."));
        String version = "123";
        String encoding = "UTF-16";
        String fakeTimeZone = "nowhere";
        Date now = new Date();
        String dateString = now.toString();
        TaskRepository repository1 = new TaskRepository("local", "http://bugzilla");
        repository1.setVersion(version);
        repository1.setCharacterEncoding(encoding);
        repository1.setTimeZoneId(fakeTimeZone);
        repository1.setSynchronizationTimeStamp(dateString);
        this.manager.addRepository(repository1);
        TaskTestUtil.saveNow();
        TasksUiPlugin.getExternalizationManager().load();
        TaskRepository temp = this.manager.getRepository(repository1.getConnectorKind(), repository1.getRepositoryUrl());
        TaskRepositoryManagerTest.assertNotNull((Object)temp);
        TaskRepositoryManagerTest.assertEquals((String)version, (String)temp.getVersion());
        TaskRepositoryManagerTest.assertEquals((String)encoding, (String)temp.getCharacterEncoding());
        TaskRepositoryManagerTest.assertEquals((String)fakeTimeZone, (String)temp.getTimeZoneId());
        TaskRepositoryManagerTest.assertEquals((String)dateString, (String)temp.getSynchronizationTimeStamp());
    }

    public void testRepositoryPersistanceAfterDelete() throws MalformedURLException {
        TaskRepository repository = new TaskRepository(DEFAULT_KIND, DEFAULT_URL);
        this.manager.addRepository(repository);
        TaskRepositoryManagerTest.assertNotNull((Object)this.manager.getRepository(repository.getConnectorKind(), repository.getRepositoryUrl()));
        TaskRepository repository2 = new TaskRepository(DEFAULT_KIND, ANOTHER_URL);
        this.manager.addRepository(repository2);
        TaskRepositoryManagerTest.assertNotNull((Object)this.manager.getRepository(repository2.getConnectorKind(), repository2.getRepositoryUrl()));
        this.manager.removeRepository(repository2);
        TaskRepositoryManagerTest.assertNull((Object)this.manager.getRepository(repository2.getConnectorKind(), repository2.getRepositoryUrl()));
    }

    public void testRepositoryWithUnknownUrlHandler() {
        TaskRepository repository = new TaskRepository("eclipse.technology.mylar", "abc://news.eclipse.org/eclipse.technology.mylar");
        repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("testUser", "testPassword"), true);
        AuthenticationCredentials credentials = repository.getCredentials(AuthenticationType.REPOSITORY);
        TaskRepositoryManagerTest.assertNotNull((Object)credentials);
        TaskRepositoryManagerTest.assertEquals((String)"testUser", (String)credentials.getUserName());
        TaskRepositoryManagerTest.assertEquals((String)"testPassword", (String)credentials.getPassword());
    }

    public void testRepositoryWithCustomAttributes() throws Exception {
        MockRepositoryConnector connector = new MockRepositoryConnector();
        this.manager.addRepositoryConnector((AbstractRepositoryConnector)connector);
        TaskRepository repository = new TaskRepository(DEFAULT_KIND, "http://mylyn.eclipse.org/");
        repository.setProperty("owner", "euxx");
        this.manager.addRepository(repository);
        TaskTestUtil.saveNow();
        TasksUiPlugin.getExternalizationManager().load();
        TaskRepository temp = this.manager.getRepository(repository.getConnectorKind(), repository.getRepositoryUrl());
        TaskRepositoryManagerTest.assertNotNull((Object)temp);
        TaskRepositoryManagerTest.assertEquals((String)"euxx", (String)temp.getProperty("owner"));
    }

    public void testRepositoryPersistanceSameUrl() throws Exception {
        TaskRepository repository1 = new TaskRepository("local", "http://repository");
        TaskRepository repository2 = new TaskRepository(DEFAULT_KIND, "http://repository");
        this.manager.addRepository(repository1);
        this.manager.addRepository(repository2);
        TaskRepositoryManagerTest.assertEquals((int)2, (int)this.manager.getAllRepositories().size());
        ArrayList<TaskRepository> repositoryList = new ArrayList<TaskRepository>();
        repositoryList.add(repository2);
        repositoryList.add(repository1);
        TaskTestUtil.saveNow();
        TasksUiPlugin.getExternalizationManager().load();
        TaskRepositoryManagerTest.assertEquals((String)("got: " + this.manager.getAllRepositories()), (int)2, (int)this.manager.getAllRepositories().size());
    }

    public void testDeletion() {
        TaskRepository repository = new TaskRepository(DEFAULT_KIND, "http://mockrepository.test");
        this.manager.addRepository(repository);
        repository.setRepositoryUrl("http://newurl");
        this.manager.removeRepository(repository);
        TaskRepositoryManagerTest.assertNull((Object)this.manager.getRepository("http://newurl"));
        TaskRepositoryManagerTest.assertNull((Object)this.manager.getRepository(DEFAULT_KIND));
        TaskRepositoryManagerTest.assertEquals(Collections.emptySet(), (Object)this.manager.getRepositories(DEFAULT_KIND));
    }
}

