/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.docs.epub.core;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mylyn.docs.epub.core.Publication;
import org.eclipse.mylyn.docs.epub.opf.Item;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EclipseTocImporter {
    private static void importTocs(Publication oebps, File rootFile, Node root) throws ParserConfigurationException, SAXException, IOException, DOMException, URISyntaxException {
        NodeList childNodes = root.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node href;
            Node node = childNodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            if ("link".equals(node.getNodeName()) && attributes != null) {
                Node toc = attributes.getNamedItem("toc");
                File tocFile = new File(rootFile.getParentFile(), toc.getNodeValue());
                EclipseTocImporter.importFile(oebps, rootFile, tocFile);
            }
            if ("topic".equals(node.getNodeName()) && attributes != null && (href = attributes.getNamedItem("href")) != null) {
                String nodeValue = href.getNodeValue();
                if (nodeValue.contains("#")) {
                    nodeValue = nodeValue.substring(0, nodeValue.lastIndexOf("#"));
                }
                File hrefFile = new File(rootFile.getParentFile(), nodeValue);
                EList<Item> items = oebps.getPackage().getManifest().getItems();
                boolean found = false;
                for (Item item : items) {
                    File t;
                    if (item.getFile() == null || !(t = new File(item.getFile())).getName().equals(hrefFile.getName())) continue;
                    found = true;
                }
                if (!found) {
                    oebps.addItem(hrefFile);
                }
            }
            EclipseTocImporter.importTocs(oebps, rootFile, childNodes.item(i));
            ++i;
        }
    }

    private static void importFile(Publication oebps, File rootFile, File file) throws ParserConfigurationException, SAXException, IOException, DOMException, URISyntaxException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(file);
        doc.getDocumentElement().normalize();
        EclipseTocImporter.importTocs(oebps, rootFile, doc);
    }

    public static void importFile(Publication oebps, File file) throws ParserConfigurationException, SAXException, IOException, DOMException, URISyntaxException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(file);
        doc.getDocumentElement().normalize();
        EclipseTocImporter.importTocs(oebps, file, doc);
    }
}

