/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.gerrit.common.data.AccountDashboardInfo;
import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.ChangeInfo;
import com.google.gerrit.common.data.ReviewerResult;
import com.google.gerrit.common.data.SingleListChangeInfo;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwtjsonrpc.client.VoidResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.data.GerritQueryResult;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.osgi.framework.Version;

public class GerritClient24
extends GerritClient {
    private boolean restQueryAPIEnabled;

    protected GerritClient24(TaskRepository repository, Version version) {
        super(repository, version);
    }

    @Override
    public ChangeDetailX getChangeDetail(int reviewId, IProgressMonitor monitor) throws GerritException {
        ChangeDetailX changeDetail = super.getChangeDetail(reviewId, monitor);
        changeDetail.convertSubmitRecordsToApprovalTypes(this.getGerritConfig().getApprovalTypes());
        return changeDetail;
    }

    @Override
    public ChangeDetail abandon(String reviewId, int patchSetId, final String message, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        return this.execute(monitor, new GerritClient.Operation<ChangeDetail>((GerritClient)this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient24.this.getChangeManageService(monitor).abandonChange(id, message, this);
            }
        });
    }

    @Override
    public void publishComments(String reviewId, int patchSetId, final String message, final Set<ApprovalCategoryValue.Id> approvals, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        this.execute(monitor, new GerritClient.Operation<VoidResult>((GerritClient)this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient24.this.getPatchDetailService(monitor).publishComments(id, message, approvals, this);
            }
        });
    }

    @Override
    public ReviewerResult addReviewers(String reviewId, final List<String> reviewers, IProgressMonitor monitor) throws GerritException {
        Assert.isLegal((reviewers != null ? 1 : 0) != 0, (String)"reviewers cannot be null");
        final Change.Id id = new Change.Id(this.id(reviewId));
        try {
            return this.execute(monitor, new GerritClient.Operation<ReviewerResult>((GerritClient)this){

                @Override
                public void execute(IProgressMonitor monitor) throws GerritException {
                    GerritClient24.this.getPatchDetailService(monitor).addReviewers(id, reviewers, this);
                }
            });
        }
        catch (GerritException e) {
            String message = e.getMessage();
            if (message != null && message.contains("Error parsing request")) {
                return this.execute(monitor, new GerritClient.Operation<ReviewerResult>((GerritClient)this){

                    @Override
                    public void execute(IProgressMonitor monitor) throws GerritException {
                        GerritClient24.this.getPatchDetailService(monitor).addReviewers(id, reviewers, false, this);
                    }
                });
            }
            throw e;
        }
    }

    private List<GerritQueryResult> convert(List<ChangeInfo> changes) {
        ArrayList<GerritQueryResult> results = new ArrayList<GerritQueryResult>(changes.size());
        for (ChangeInfo changeInfo : changes) {
            GerritQueryResult result = new GerritQueryResult(changeInfo);
            results.add(result);
        }
        return results;
    }

    @Override
    public List<GerritQueryResult> queryMyReviews(IProgressMonitor monitor) throws GerritException {
        if (!this.restQueryAPIEnabled) {
            try {
                final Account account = this.getAccount(monitor);
                AccountDashboardInfo ad = this.execute(monitor, new GerritClient.Operation<AccountDashboardInfo>((GerritClient)this){

                    @Override
                    public void execute(IProgressMonitor monitor) throws GerritException {
                        GerritClient24.this.getChangeListService(monitor).forAccount(account.getId(), (AsyncCallback)this);
                    }
                });
                List allMyChanges = ad.getByOwner();
                allMyChanges.addAll(ad.getForReview());
                allMyChanges.addAll(ad.getClosed());
                return this.convert(allMyChanges);
            }
            catch (GerritException e) {
                if (this.isNoSuchServiceError(e)) {
                    this.restQueryAPIEnabled = true;
                }
                throw e;
            }
        }
        return super.queryMyReviews(monitor);
    }

    @Override
    public List<GerritQueryResult> executeQuery(IProgressMonitor monitor, final String queryString, String optionString) throws GerritException {
        if (!this.restQueryAPIEnabled) {
            try {
                SingleListChangeInfo sl = this.execute(monitor, new GerritClient.Operation<SingleListChangeInfo>((GerritClient)this){

                    @Override
                    public void execute(IProgressMonitor monitor) throws GerritException {
                        GerritClient24.this.getChangeListService(monitor).allQueryNext(queryString, "z", -1, (AsyncCallback)this);
                    }
                });
                return this.convert(sl.getChanges());
            }
            catch (GerritException e) {
                if (this.isNoSuchServiceError(e)) {
                    this.restQueryAPIEnabled = true;
                }
                throw e;
            }
        }
        return super.executeQuery(monitor, queryString);
    }

    @Override
    public ChangeDetail restore(String reviewId, int patchSetId, final String message, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        return this.execute(monitor, new GerritClient.Operation<ChangeDetail>((GerritClient)this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient24.this.getChangeManageService(monitor).restoreChange(id, message, this);
            }
        });
    }

    @Override
    public ChangeDetail submit(String reviewId, int patchSetId, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        return this.execute(monitor, new GerritClient.Operation<ChangeDetail>((GerritClient)this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient24.this.getChangeManageService(monitor).submit(id, this);
            }
        });
    }
}

