/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.gerrit.reviewdb.PatchSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchSetPublishDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ChangeInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewerInfo;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.osgi.framework.Version;

public class GerritClient26
extends GerritClient {
    protected GerritClient26(TaskRepository repository, Version version) {
        super(repository, version);
    }

    @Override
    public ChangeDetailX getChangeDetail(int reviewId, IProgressMonitor monitor) throws GerritException {
        ChangeDetailX changeDetail = super.getChangeDetail(reviewId, monitor);
        if (changeDetail.getApprovals() == null) {
            ChangeInfo changeInfo = this.getChangeInfo(reviewId, monitor);
            changeDetail.setApprovals(changeInfo.convertToApprovalDetails());
            changeDetail.setApprovalTypes(changeInfo.convertToApprovalTypes());
        }
        List<ReviewerInfo> reviewers = this.listReviewers(reviewId, monitor);
        if (!this.hasAllReviewers(changeDetail.getAccounts(), reviewers)) {
            this.merge(changeDetail.getAccounts(), reviewers);
        }
        return changeDetail;
    }

    @Override
    public PatchSetPublishDetailX getPatchSetPublishDetail(PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        PatchSetPublishDetailX publishDetail = super.getPatchSetPublishDetail(id, monitor);
        if (publishDetail.getLabels() == null) {
            ChangeInfo changeInfo = this.getChangeInfo(id.getParentKey().get(), monitor);
            publishDetail.setLabels(changeInfo.convertToPermissionLabels());
            if (publishDetail.getGiven() == null) {
                publishDetail.setGiven(changeInfo.convertToPatchSetApprovals(id, this.getAccount(monitor)));
            }
        }
        return publishDetail;
    }
}

