/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.gerrit.common.data.AccountInfoCache;
import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.Branch;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.ChangeMessage;
import com.google.gerrit.reviewdb.Patch;
import com.google.gerrit.reviewdb.PatchLineComment;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.PatchSetInfo;
import com.google.gerrit.reviewdb.Project;
import com.google.gerrit.reviewdb.UserIdentity;
import com.google.gwtjsonrpc.client.VoidResult;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient28;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpClient;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.GerritSystemAccount;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchSetPublishDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.SubmitRecord;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.AccountInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ActionInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ChangeInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ChangeInfo28;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ChangeMessageInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.CommentInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.RelatedChangeAndCommitInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.RelatedChangesInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewerInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.RevisionInfo;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class GerritClient29
extends GerritClient28 {
    private final String OK = "OK";
    private final String NEED = "NEED";
    private final String REJECT = "REJECT";
    final String MAY = "MAY";

    protected GerritClient29(TaskRepository repository, Version version) {
        super(repository, version);
    }

    @Override
    protected Account executeAccount(IProgressMonitor monitor) throws GerritException {
        if (this.isAnonymous()) {
            throw new GerritException("Not Signed In", -32603);
        }
        String query = "/accounts/self";
        AccountInfo accountInfo = (AccountInfo)this.executeGetRestRequest(query, (Type)((Object)AccountInfo.class), monitor);
        Account account = new Account(new Account.Id(accountInfo.getId()));
        account.setFullName(accountInfo.getName());
        account.setUserName(accountInfo.getUsername());
        account.setPreferredEmail(accountInfo.getEmail());
        return account;
    }

    @Override
    public ChangeDetail rebase(String reviewId, int patchSetId, IProgressMonitor monitor) throws GerritException {
        PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        String uri = "/a/changes/" + id.getParentKey().get() + "/revisions/" + id.get() + "/rebase";
        this.executePostRestRequest(uri, new ChangeInfo28(), (Type)((Object)ChangeInfo28.class), new GerritHttpClient.ErrorHandler(){

            @Override
            public void handleError(HttpMethodBase method) throws GerritException {
                String errorMsg = this.getResponseBodyAsString(method);
                if (this.isConflict(method)) {
                    throw new GerritException(errorMsg);
                }
            }

            private String getResponseBodyAsString(HttpMethodBase method) {
                try {
                    return method.getResponseBodyAsString();
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            private boolean isConflict(HttpMethodBase method) {
                return method.getStatusCode() == 409;
            }
        }, monitor);
        return this.getChangeDetail(id.getParentKey().get(), monitor);
    }

    private ChangeMessage convertChangeMessage(int reviewId, ChangeInfo changeInfo, ChangeMessageInfo changeMessageInfo) {
        Change.Id changeId = new Change.Id(reviewId);
        ChangeMessage.Key changeMessageKey = new ChangeMessage.Key(changeId, changeInfo.getId());
        AccountInfo author = changeMessageInfo.getAuthor();
        if (author == null) {
            author = GerritSystemAccount.GERRIT_SYSTEM;
        }
        Account.Id accountId = new Account.Id(author.getId());
        ChangeMessage changeMessage = new ChangeMessage(changeMessageKey, accountId, changeMessageInfo.getDate());
        changeMessage.setMessage(changeMessageInfo.getMesssage());
        return changeMessage;
    }

    private Branch.NameKey getBranchKey(ChangeInfo changeInfo) {
        Project.NameKey projectKey = new Project.NameKey(changeInfo.getProject());
        Branch.NameKey branchKey = new Branch.NameKey(projectKey, changeInfo.getBranch());
        return branchKey;
    }

    private Change createChange(String keyString, int changeIdValue, com.google.gerrit.common.data.AccountInfo accountInfo, Branch.NameKey branchKey) {
        Change.Key key = new Change.Key(keyString);
        Change.Id changeId = new Change.Id(changeIdValue);
        Change change = new Change(key, changeId, accountInfo.getId(), branchKey);
        return change;
    }

    private PatchSetInfo getPatchSetInfo(PatchSet.Id patchsetId, String subject) {
        PatchSetInfo patchSetInfo = new PatchSetInfo(patchsetId);
        patchSetInfo.setSubject(subject);
        return patchSetInfo;
    }

    private com.google.gerrit.common.data.ChangeInfo convertToGoogleChangeInfo(RelatedChangeAndCommitInfo info, com.google.gerrit.common.data.AccountInfo accountInfo, Branch.NameKey branchKey) {
        Change change = this.createChange(info.getChangeId(), info.getChangeNumber(), accountInfo, branchKey);
        PatchSet.Id patchsetId = new PatchSet.Id(change.getId(), info.getCurrentRevisionNumbe());
        PatchSetInfo patchSetInfo = this.getPatchSetInfo(patchsetId, info.getCommitInfo().getSubject());
        change.setCurrentPatchSet(patchSetInfo);
        com.google.gerrit.common.data.ChangeInfo googleChangeInfo = new com.google.gerrit.common.data.ChangeInfo(change);
        return googleChangeInfo;
    }

    private com.google.gerrit.common.data.AccountInfo convertAuthorFrom29ToAccountInfo(ChangeInfo changeInfo) {
        Account account = new Account(new Account.Id(changeInfo.getOwner().getId()));
        account.setFullName(changeInfo.getOwner().getName());
        account.setUserName(changeInfo.getOwner().getUsername());
        account.setPreferredEmail(changeInfo.getOwner().getEmail());
        com.google.gerrit.common.data.AccountInfo accountInfo = new com.google.gerrit.common.data.AccountInfo(account);
        return accountInfo;
    }

    @Override
    public PatchSetPublishDetailX getPatchSetPublishDetail(PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        PatchSetPublishDetailX publishDetail = null;
        publishDetail = new PatchSetPublishDetailX();
        ChangeInfo changeInfo = this.getChangeInfo(id.getParentKey().get(), monitor);
        ArrayList<com.google.gerrit.common.data.AccountInfo> listAccountInfo = new ArrayList<com.google.gerrit.common.data.AccountInfo>();
        com.google.gerrit.common.data.AccountInfo accountInfo = this.convertAuthorFrom29ToAccountInfo(changeInfo);
        listAccountInfo.add(accountInfo);
        AccountInfoCache accountInfoCache = new AccountInfoCache(listAccountInfo);
        publishDetail.setAccounts(accountInfoCache);
        Branch.NameKey branchKey = this.getBranchKey(changeInfo);
        Change currentChange = this.createChange(changeInfo.getChangeId(), id.getParentKey().get(), accountInfo, branchKey);
        currentChange.setStatus(changeInfo.getStatus());
        publishDetail.setChange(currentChange);
        PatchSetInfo patchSetInfo = this.getPatchSetInfo(changeInfo.getCurrentPatchSetId(), changeInfo.getSubject());
        publishDetail.setPatchSetInfo(patchSetInfo);
        publishDetail.setLabels(changeInfo.convertToPermissionLabels());
        if (publishDetail.getGiven() == null) {
            publishDetail.setGiven(changeInfo.convertToPatchSetApprovals(id, this.getAccount(monitor)));
        }
        return publishDetail;
    }

    private List<PatchSet> getPatchSets(String changeInfoId, int reviewId, IProgressMonitor monitor) throws GerritException {
        ChangeInfo28[] changeInfo;
        ArrayList<PatchSet> patchSets = new ArrayList<PatchSet>();
        String query = "/changes/?q=" + changeInfoId + "+change:" + reviewId + "&o=ALL_REVISIONS";
        ChangeInfo28[] changeInfo28Array = changeInfo = (ChangeInfo28[])this.executeGetRestRequest(query, (Type)((Object)ChangeInfo28[].class), monitor);
        int n = changeInfo.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeInfo28 element = changeInfo28Array[n2];
            for (Map.Entry<String, RevisionInfo> revisionInfo : element.getRevisions().entrySet()) {
                PatchSet.Id patchSetId = new PatchSet.Id(new Change.Id(reviewId), revisionInfo.getValue().getNumber());
                patchSets.add(new PatchSet(patchSetId));
            }
            ++n2;
        }
        Collections.sort(patchSets, new Comparator<PatchSet>(){

            @Override
            public int compare(PatchSet p1, PatchSet p2) {
                return p1.getPatchSetId() - p2.getPatchSetId();
            }
        });
        return patchSets;
    }

    private List<SubmitRecord> currentSubmitRecord(String uri, IProgressMonitor monitor) throws GerritException {
        SubmitRecord[] submitRecordArray;
        ArrayList<SubmitRecord> submitRecordList = new ArrayList<SubmitRecord>();
        SubmitRecord[] submitRecordArray2 = submitRecordArray = (SubmitRecord[])this.executePostRestRequest(uri, new SubmitRecord(), (Type)((Object)SubmitRecord[].class), new GerritHttpClient.ErrorHandler(){

            @Override
            public void handleError(HttpMethodBase method) throws GerritException {
                String errorMsg = this.getResponseBodyAsString(method);
                if (this.isNotPermitted(method, errorMsg) || this.isConflict(method)) {
                    throw new GerritException(NLS.bind((String)"Cannot get submit change: {0}", (Object)errorMsg));
                }
            }

            private String getResponseBodyAsString(HttpMethodBase method) {
                try {
                    return method.getResponseBodyAsString();
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            private boolean isNotPermitted(HttpMethodBase method, String msg) {
                return method.getStatusCode() == 403 && "submit not permitted\n".equals(msg);
            }

            private boolean isConflict(HttpMethodBase method) {
                return method.getStatusCode() == 409;
            }
        }, monitor);
        int n = submitRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            SubmitRecord element = submitRecordArray2[n2];
            List<SubmitRecord.Label> list = null;
            if (element.getStatus().equalsIgnoreCase("OK")) {
                list = element.createLabel(element, element.getOkMap(), "OK");
            } else if (element.getStatus().equalsIgnoreCase("NOT_READY")) {
                list = element.createLabel(element, element.getNeedMap(), "NEED");
            } else if (element.getStatus().equalsIgnoreCase("REJECT")) {
                list = element.createLabel(element, element.getRejectMap(), "REJECT");
            } else if (element.getStatus().equalsIgnoreCase("MAY")) {
                list = element.createLabel(element, element.getMayMap(), "MAY");
            }
            element.setLabels(list);
            submitRecordList.add(element);
            ++n2;
        }
        return submitRecordList;
    }

    @Override
    public ChangeDetailX getChangeDetail(int reviewId, IProgressMonitor monitor) throws GerritException {
        ChangeDetailX changeDetail = null;
        String query = "/changes/" + Integer.toString(reviewId) + "/detail/?o=ALL_REVISIONS&o=MESSAGES";
        ChangeInfo28 changeInfo = (ChangeInfo28)this.executeGetRestRequest(query, (Type)((Object)ChangeInfo28.class), monitor);
        List<PatchSet> patchSets = this.getPatchSets(changeInfo.getChangeId(), reviewId, monitor);
        ArrayList<ChangeMessage> listChangeMessage = new ArrayList<ChangeMessage>();
        List<ChangeMessageInfo> listChangeMessageInfo = changeInfo.getMessages();
        boolean containsMessageFromGerritSystem = false;
        for (ChangeMessageInfo changeMessageInfo : listChangeMessageInfo) {
            if (changeMessageInfo.getAuthor() == null) {
                containsMessageFromGerritSystem = true;
            }
            ChangeMessage changeMessage = this.convertChangeMessage(reviewId, changeInfo, changeMessageInfo);
            listChangeMessage.add(changeMessage);
        }
        ArrayList<com.google.gerrit.common.data.AccountInfo> listAccountInfo = new ArrayList<com.google.gerrit.common.data.AccountInfo>();
        com.google.gerrit.common.data.AccountInfo accountInfo = this.convertAuthorFrom29ToAccountInfo(changeInfo);
        listAccountInfo.add(accountInfo);
        if (containsMessageFromGerritSystem) {
            listAccountInfo.add(GerritSystemAccount.GERRIT_SYSTEM.getGerritSystemAccountInfo());
        }
        AccountInfoCache accountInfoCache = new AccountInfoCache(listAccountInfo);
        changeDetail = new ChangeDetailX();
        changeDetail.setDateCreated(changeInfo.getCreated());
        changeDetail.setLastModified(changeInfo.getUpdated());
        changeDetail.setStarred(changeInfo.getStarred() != null);
        changeDetail.setAccounts(accountInfoCache);
        changeDetail.setMessages(listChangeMessage);
        Branch.NameKey branchKey = this.getBranchKey(changeInfo);
        this.setChangeDetailDependency(reviewId, changeInfo, changeDetail, accountInfo, monitor);
        PatchSetInfo patchSetInfo = this.getPatchSetInfo(changeInfo.getCurrentPatchSetId(), changeInfo.getSubject());
        changeDetail.setApprovals(changeInfo.convertToApprovalDetails());
        changeDetail.setApprovalTypes(changeInfo.convertToApprovalTypes());
        String querysubmit = "/changes/" + Integer.toString(reviewId) + "/revisions/current/test.submit_rule?filters=SKIP";
        List<SubmitRecord> submitRecord = this.currentSubmitRecord(querysubmit, monitor);
        changeDetail.setSubmitRecords(submitRecord);
        if (changeDetail.getApprovalTypes() == null && this.getGerritConfig() != null) {
            changeDetail.convertSubmitRecordsToApprovalTypes(this.getGerritConfig().getApprovalTypes());
        }
        changeDetail.setPatchSets(patchSets);
        List<ReviewerInfo> reviewers = this.listReviewers(reviewId, monitor);
        if (!this.hasAllReviewers(changeDetail.getAccounts(), reviewers)) {
            this.merge(changeDetail.getAccounts(), reviewers);
        }
        Change initialChange = this.createChange(changeInfo.getChangeId(), reviewId, accountInfo, branchKey);
        initialChange.setCurrentPatchSet(patchSetInfo);
        initialChange.setStatus(changeInfo.getStatus());
        changeDetail.setChange(initialChange);
        this.getAdditionalChangeInfo(reviewId, changeDetail, monitor);
        return changeDetail;
    }

    private RelatedChangesInfo getRelatedChanges(int reviewId, String revisionId, IProgressMonitor monitor) throws GerritException {
        String query = "/changes/" + Integer.toString(reviewId) + "/revisions/" + revisionId + "/related";
        RelatedChangesInfo relatedChangesInfo = (RelatedChangesInfo)this.executeGetRestRequest(query, (Type)((Object)RelatedChangesInfo.class), monitor);
        return relatedChangesInfo;
    }

    private void setChangeDetailDependency(int reviewId, ChangeInfo28 changeInfo28, ChangeDetailX changeDetail, com.google.gerrit.common.data.AccountInfo accountInfo, IProgressMonitor monitor) throws GerritException {
        ArrayList<com.google.gerrit.common.data.ChangeInfo> dependsOn = new ArrayList<com.google.gerrit.common.data.ChangeInfo>();
        ArrayList<com.google.gerrit.common.data.ChangeInfo> neededBy = new ArrayList<com.google.gerrit.common.data.ChangeInfo>();
        Branch.NameKey branchKey = this.getBranchKey(changeInfo28);
        RelatedChangesInfo relatedChangesInfo = this.getRelatedChanges(reviewId, changeInfo28.getCurrentRevision(), monitor);
        List<RelatedChangeAndCommitInfo> listCommitInfo = relatedChangesInfo.getCommitInfo();
        boolean needed = true;
        for (RelatedChangeAndCommitInfo relatedChangeAndCommitInfo : listCommitInfo) {
            if (relatedChangeAndCommitInfo.getCommitInfo().getCommit().equalsIgnoreCase(changeInfo28.getCurrentRevision())) {
                needed = false;
                continue;
            }
            if (relatedChangeAndCommitInfo.getChangeNumber() <= 0) continue;
            com.google.gerrit.common.data.ChangeInfo googleChangeInfo = this.convertToGoogleChangeInfo(relatedChangeAndCommitInfo, accountInfo, branchKey);
            if (needed) {
                neededBy.add(googleChangeInfo);
                continue;
            }
            dependsOn.add(googleChangeInfo);
        }
        changeDetail.setNeededBy(neededBy);
        changeDetail.setDependsOn(dependsOn);
    }

    @Override
    public PatchLineComment saveDraft(Patch.Key patchKey, String message, int line, short side, String parentUuid, String uuid, IProgressMonitor monitor) throws GerritException {
        PatchLineComment comment = this.createDraftComment(patchKey, message, line, side, parentUuid, uuid, monitor);
        if (uuid == null) {
            uuid = "";
        }
        CommentInput commentInput = new CommentInput();
        commentInput.setLine(line);
        commentInput.setMessage(message);
        commentInput.setPath(patchKey.getFileName());
        if (side == 0) {
            commentInput.setSide("PARENT");
        } else {
            commentInput.setSide("REVISION");
        }
        String uri = "/changes/" + Integer.toString(patchKey.getParentKey().getParentKey().get()) + "/revisions/" + patchKey.getParentKey().get() + "/drafts";
        if (!uuid.isEmpty()) {
            uri = uri.concat("/" + uuid);
        }
        this.executePutRestRequest(uri, commentInput, (Type)((Object)CommentInput.class), null, monitor);
        return comment;
    }

    private void getAdditionalChangeInfo(int reviewId, ChangeDetailX changeDetail, IProgressMonitor monitor) {
        ChangeInfo28 changeInfo = this.getAdditionalChangeInfo(reviewId, monitor);
        if (changeInfo != null) {
            this.setRevisionActions(changeInfo, changeDetail);
            this.setGlobalActions(changeInfo, changeDetail);
            this.setRevisionParentCommit(changeInfo, changeDetail);
        }
    }

    private void setRevisionActions(ChangeInfo28 changeInfo, ChangeDetailX changeDetail) {
        if (changeInfo.getRevisions() != null) {
            for (Map.Entry<String, RevisionInfo> revisions : changeInfo.getRevisions().entrySet()) {
                if (revisions.getValue().getActions() == null) continue;
                for (Map.Entry<String, ActionInfo> actions : revisions.getValue().getActions().entrySet()) {
                    if (actions.getKey().equalsIgnoreCase("submit")) {
                        changeDetail.setCanSubmit(actions.getValue().getEnabled());
                        continue;
                    }
                    if (actions.getKey().equalsIgnoreCase("rebase")) {
                        changeDetail.setCanRebase(actions.getValue().getEnabled());
                        continue;
                    }
                    if (!actions.getKey().equalsIgnoreCase("cherrypick")) continue;
                    changeDetail.setCanCherryPick(actions.getValue().getEnabled());
                }
            }
        }
    }

    private void setGlobalActions(ChangeInfo28 changeInfo, ChangeDetailX changeDetail) {
        if (changeInfo.getActions() != null) {
            for (Map.Entry<String, ActionInfo> actions : changeInfo.getActions().entrySet()) {
                if (actions.getKey().equalsIgnoreCase("abandon")) {
                    changeDetail.setCanAbandon(actions.getValue().getEnabled());
                    changeDetail.setCanRestore(!actions.getValue().getEnabled());
                    continue;
                }
                if (!actions.getKey().equalsIgnoreCase("restore")) continue;
                changeDetail.setCanAbandon(!actions.getValue().getEnabled());
                changeDetail.setCanRestore(actions.getValue().getEnabled());
            }
        }
    }

    @Override
    public VoidResult deleteDraft(Patch.Key patchkey, String uuid, IProgressMonitor monitor) throws GerritException {
        CommentInput commentInput = new CommentInput();
        String uri = "/changes/" + Integer.toString(patchkey.getParentKey().getParentKey().get()) + "/revisions/" + patchkey.getParentKey().get() + "/drafts/" + uuid;
        this.executeDeleteRestRequest(uri, commentInput, (Type)((Object)CommentInput.class), null, monitor);
        return null;
    }

    private PatchSetInfo setAccountPatchSetInfo(PatchSetInfo patchSetInfo, IProgressMonitor monitor) {
        if (patchSetInfo.getAuthor().getAccount() == null) {
            patchSetInfo.setAuthor(this.setUserIdentity(patchSetInfo.getAuthor().getName(), patchSetInfo.getAuthor(), "Author", monitor));
        }
        if (patchSetInfo.getCommitter().getAccount() == null) {
            patchSetInfo.setCommitter(this.setUserIdentity(patchSetInfo.getCommitter().getName(), patchSetInfo.getCommitter(), "Committer", monitor));
        }
        return patchSetInfo;
    }

    private AccountInfo getAccountInfo(String account, IProgressMonitor monitor) throws GerritException, URIException {
        if ("Gerrit Code Review".equals(account)) {
            return GerritSystemAccount.GERRIT_SYSTEM;
        }
        String st = URIUtil.encodeQuery((String)account);
        String uri = "/accounts/" + st;
        AccountInfo accountInfo = (AccountInfo)this.executeGetRestRequest(uri, (Type)((Object)AccountInfo.class), monitor);
        return accountInfo;
    }

    private UserIdentity setUserIdentity(String name, UserIdentity userIdentity, String user, IProgressMonitor monitor) {
        AccountInfo accountInfo = null;
        try {
            accountInfo = this.getAccountInfo(name, monitor);
            Account.Id accountId = new Account.Id(accountInfo.getId());
            userIdentity.setAccount(accountId);
        }
        catch (GerritException gerritException) {
            if (gerritException.getMessage().indexOf(404) != 0) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.gerrit.core", NLS.bind((String)"GerritException {0} not found", (Object)user), (Throwable)gerritException));
            }
        }
        catch (URIException uriException) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", NLS.bind((String)"{0} URIException: ", (Object)user), (Throwable)uriException));
        }
        return userIdentity;
    }

    @Override
    protected void applyPatchSetInfo(PatchSetDetail patchSetDetail, PatchSetPublishDetailX patchSetPublishDetail, IProgressMonitor monitor) throws GerritException {
        patchSetPublishDetail.setPatchSetInfo(this.setAccountPatchSetInfo(patchSetDetail.getInfo(), monitor));
    }
}

