/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.core.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;

public abstract class AbstractConfigurationCache<C extends Serializable> {
    private final File cacheFile;
    private Map<String, C> configurationByUrl;

    public AbstractConfigurationCache(File cacheFile) {
        this.cacheFile = cacheFile;
    }

    public AbstractConfigurationCache() {
        this(null);
    }

    protected abstract C createConfiguration();

    public void flush() {
        if (this.cacheFile == null || this.configurationByUrl == null) {
            return;
        }
    }

    public C getConfiguration(String url) {
        this.initialize();
        Serializable configuration = (Serializable)this.configurationByUrl.get(url);
        if (configuration == null) {
            configuration = this.createConfiguration();
            this.configurationByUrl.put(url, configuration);
        }
        return (C)configuration;
    }

    protected void initialize() {
        if (this.configurationByUrl == null) {
            this.configurationByUrl = new HashMap<String, C>();
            this.readCache();
        }
    }

    protected void readCache() {
        block17: {
            if (this.cacheFile == null || !this.cacheFile.exists()) {
                return;
            }
            ObjectInputStream in = null;
            try {
                try {
                    in = new ObjectInputStream(new FileInputStream(this.cacheFile));
                    int size = in.readInt();
                    int i = 0;
                    while (i < size) {
                        String url = (String)in.readObject();
                        C data = this.readConfiguration(in);
                        if (url != null && data != null) {
                            this.configurationByUrl.put(url, data);
                        }
                        ++i;
                    }
                }
                catch (Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.builds.core", "The configuration cache could not be read", e));
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected abstract C readConfiguration(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    public void setConfiguration(String url, C configuration) {
        this.initialize();
        this.configurationByUrl.put(url, configuration);
        this.writeCache();
    }

    protected void writeCache() {
        block16: {
            if (this.cacheFile == null) {
                return;
            }
            ObjectOutputStream out = null;
            try {
                try {
                    out = new ObjectOutputStream(new FileOutputStream(this.cacheFile));
                    out.writeInt(this.configurationByUrl.size());
                    for (String url : this.configurationByUrl.keySet()) {
                        out.writeObject(url);
                        out.writeObject(this.configurationByUrl.get(url));
                    }
                }
                catch (IOException e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.builds.core", "The respository configuration cache could not be written", (Throwable)e));
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

