/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.epub.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.mylyn.docs.epub.core.ILogger;
import org.eclipse.mylyn.docs.epub.core.Messages;
import org.eclipse.mylyn.docs.epub.core.Publication;
import org.eclipse.mylyn.docs.epub.core.ValidationException;
import org.eclipse.mylyn.docs.epub.ocf.Container;
import org.eclipse.mylyn.docs.epub.ocf.OCFFactory;
import org.eclipse.mylyn.docs.epub.ocf.RootFile;
import org.eclipse.mylyn.docs.epub.ocf.RootFiles;
import org.eclipse.mylyn.docs.epub.ocf.util.OCFResourceImpl;
import org.eclipse.mylyn.internal.docs.epub.core.EPUBFileUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class EPUB {
    public static final String MIMETYPE_EPUB = "application/epub+zip";
    private static final String MIMETYPE_OEBPS = "application/oebps-package+xml";
    private static final String OCF_FILE_ENCODING = "UTF-8";
    private static final String OCF_FILE_SUFFIX = "xml";
    private static final String OCF_VERSION = "1.0";
    private ILogger logger;
    private Container ocfContainer = OCFFactory.eINSTANCE.createContainer();
    private static final int BUFFERSIZE = 2048;

    public EPUB() {
        RootFiles rootFiles = OCFFactory.eINSTANCE.createRootFiles();
        this.ocfContainer.setRootfiles(rootFiles);
        this.ocfContainer.setVersion(OCF_VERSION);
        this.registerOCFResourceFactory();
    }

    public EPUB(ILogger logger) {
        this();
        this.logger = logger;
    }

    public void add(File file, String type) {
        String name = type.substring(type.lastIndexOf(47) + 1, type.length()).toUpperCase();
        RootFiles rootFiles = this.ocfContainer.getRootfiles();
        int count = rootFiles.getRootfiles().size();
        if (count >= 1) {
            this.log("Multiple root files is unsupported by most reading systems!", ILogger.Severity.WARNING);
        }
        String rootFileName = count > 0 ? String.valueOf(name) + "_" + count : name;
        rootFileName = String.valueOf(rootFileName) + File.separator + file.getName();
        RootFile rootFile = OCFFactory.eINSTANCE.createRootFile();
        rootFile.setFullPath(rootFileName);
        rootFile.setMediaType(type);
        rootFile.setPublication(file);
        rootFiles.getRootfiles().add((Object)rootFile);
        this.log(MessageFormat.format(Messages.getString("EPUB.1"), rootFile.getFullPath(), rootFile.getMediaType()), ILogger.Severity.VERBOSE);
    }

    public void add(Publication oebps) {
        RootFiles rootFiles = this.ocfContainer.getRootfiles();
        int count = rootFiles.getRootfiles().size();
        if (count >= 1) {
            this.log("Multiple root files is unsupported by most reading systems!", ILogger.Severity.WARNING);
        }
        String rootFileName = count > 0 ? "OEBPS_" + count : "OEBPS";
        rootFileName = String.valueOf(rootFileName) + "/content.opf";
        RootFile rootFile = OCFFactory.eINSTANCE.createRootFile();
        rootFile.setFullPath(rootFileName);
        rootFile.setMediaType(MIMETYPE_OEBPS);
        rootFile.setPublication(oebps);
        rootFiles.getRootfiles().add((Object)rootFile);
        this.log(MessageFormat.format(Messages.getString("EPUB.0"), rootFile.getFullPath(), rootFile.getMediaType()), ILogger.Severity.VERBOSE);
    }

    private void deleteFolder(File folder) {
        if (folder.isDirectory()) {
            String[] children;
            String[] stringArray = children = folder.list();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                this.deleteFolder(new File(folder, element));
                ++n2;
            }
        }
        folder.delete();
    }

    public Container getContainer() {
        return this.ocfContainer;
    }

    public List<Publication> getOPSPublications() {
        ArrayList<Publication> publications = new ArrayList<Publication>();
        EList<RootFile> rootFiles = this.ocfContainer.getRootfiles().getRootfiles();
        for (RootFile rootFile : rootFiles) {
            if (!rootFile.getMediaType().equals(MIMETYPE_OEBPS) || rootFile.getPublication() == null) continue;
            publications.add((Publication)rootFile.getPublication());
        }
        return publications;
    }

    public boolean isEPUB(File epubFile) throws IOException {
        String mimeType = EPUBFileUtil.getMimeType(epubFile);
        if (mimeType.equals(MIMETYPE_EPUB)) {
            return EPUB.isEPUB(new FileInputStream(epubFile));
        }
        return false;
    }

    public static boolean isEPUB(InputStream inputStream) throws IOException {
        try (ZipInputStream in = new ZipInputStream(inputStream);){
            String entryName;
            byte[] buf = new byte[2048];
            ZipEntry entry = null;
            entry = in.getNextEntry();
            if (entry != null && (entryName = entry.getName()).equals("mimetype")) {
                String type = new String();
                while (in.read(buf, 0, 2048) > 0) {
                    type = String.valueOf(type) + new String(buf);
                }
                if (type.trim().equals(MIMETYPE_EPUB)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isSupportedOEBPS(File rootFile) {
        VersionDetector vd;
        block5: {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            vd = new VersionDetector();
            SAXParser parser = factory.newSAXParser();
            parser.parse(rootFile, (DefaultHandler)vd);
            if (vd.versionString != null) break block5;
            return false;
        }
        try {
            String[] segments = vd.versionString.split("\\.");
            return segments[0].equals("2") && segments[1].equals("0");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return false;
        }
        catch (SAXException sAXException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void log(String message, ILogger.Severity severity) {
        if (this.logger != null) {
            this.logger.log(message, severity);
        }
    }

    public File pack(File epubFile) throws Exception {
        File workingFolder = File.createTempFile("epub_", null);
        if (workingFolder.delete() && workingFolder.mkdirs()) {
            this.pack(epubFile, workingFolder);
        }
        this.deleteFolder(workingFolder);
        return workingFolder;
    }

    public void pack(File epubFile, File rootFolder) throws Exception {
        EList<RootFile> publications;
        if (this.ocfContainer.getRootfiles().getRootfiles().isEmpty()) {
            throw new ValidationException("EPUB does not contain any publications");
        }
        rootFolder.mkdirs();
        if (rootFolder.isDirectory() || rootFolder.mkdirs()) {
            this.writeOCF(rootFolder);
            publications = this.ocfContainer.getRootfiles().getRootfiles();
            this.log(MessageFormat.format(Messages.getString("EPUB.2"), epubFile.getAbsolutePath()), ILogger.Severity.INFO);
            for (RootFile rootFile : publications) {
                Object publication = rootFile.getPublication();
                File root = new File(String.valueOf(rootFolder.getAbsolutePath()) + File.separator + rootFile.getFullPath());
                if (publication instanceof Publication) {
                    ((Publication)publication).pack(root);
                    continue;
                }
                if (rootFile.getPublication() instanceof File) {
                    EPUBFileUtil.copy((File)rootFile.getPublication(), root);
                    continue;
                }
                throw new IllegalArgumentException("Unknown publication type in root file");
            }
        } else {
            throw new IOException("Could not create working folder in " + rootFolder.getAbsolutePath());
        }
        EPUBFileUtil.zip(epubFile, rootFolder);
        this.log(MessageFormat.format(Messages.getString("EPUB.3"), publications.size()), ILogger.Severity.INFO);
    }

    protected void readOCF(File rootFolder) throws IOException {
        File metaFolder = new File(String.valueOf(rootFolder.getAbsolutePath()) + File.separator + "META-INF");
        File containerFile = new File(String.valueOf(metaFolder.getAbsolutePath()) + File.separator + "container.xml");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createFileURI((String)containerFile.getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        resource.load(null);
        this.ocfContainer = (Container)resource.getContents().get(0);
    }

    private void registerOCFResourceFactory() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(OCF_FILE_SUFFIX, new XMLResourceFactoryImpl(){

            public Resource createResource(URI uri) {
                OCFResourceImpl xmiResource = new OCFResourceImpl(uri);
                Map loadOptions = xmiResource.getDefaultLoadOptions();
                Map saveOptions = xmiResource.getDefaultSaveOptions();
                saveOptions.put("EXTENDED_META_DATA", Boolean.TRUE);
                loadOptions.put("EXTENDED_META_DATA", Boolean.TRUE);
                loadOptions.put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
                loadOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                saveOptions.put("ENCODING", EPUB.OCF_FILE_ENCODING);
                HashMap<String, Boolean> parserFeatures = new HashMap<String, Boolean>();
                parserFeatures.put("http://xml.org/sax/features/validation", Boolean.FALSE);
                parserFeatures.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
                loadOptions.put("PARSER_FEATURES", parserFeatures);
                return xmiResource;
            }
        });
    }

    public File unpack(File epubFile) throws Exception {
        File workingFolder = File.createTempFile("epub_", null);
        workingFolder.deleteOnExit();
        if (workingFolder.delete() && workingFolder.mkdirs()) {
            this.unpack(epubFile, workingFolder);
        }
        return workingFolder;
    }

    public void unpack(File epubFile, File rootFolder) throws Exception {
        if (!this.isEPUB(epubFile)) {
            throw new IllegalArgumentException(MessageFormat.format("{0} is not an EPUB file", epubFile));
        }
        if (!rootFolder.exists() || rootFolder.list().length == 0) {
            EPUBFileUtil.unzip(epubFile, rootFolder);
        }
        this.readOCF(rootFolder);
        EList<RootFile> rootFiles = this.ocfContainer.getRootfiles().getRootfiles();
        for (RootFile rootFile : rootFiles) {
            if (!rootFile.getMediaType().equals(MIMETYPE_OEBPS)) continue;
            File root = new File(String.valueOf(rootFolder.getAbsolutePath()) + File.separator + rootFile.getFullPath());
            if (this.isSupportedOEBPS(root)) {
                Publication ops = Publication.getVersion2Instance();
                ops.unpack(root);
                rootFile.setPublication(ops);
                continue;
            }
            this.log(MessageFormat.format("Unsupported OEBPS version in root file {0}", rootFile.getFullPath()), ILogger.Severity.WARNING);
        }
    }

    private void writeOCF(File rootFolder) throws IOException {
        File metaFolder = new File(String.valueOf(rootFolder.getAbsolutePath()) + File.separator + "META-INF");
        if (metaFolder.mkdir()) {
            File containerFile = new File(String.valueOf(metaFolder.getAbsolutePath()) + File.separator + "container.xml");
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI fileURI = URI.createFileURI((String)containerFile.getAbsolutePath());
            Resource resource = resourceSet.createResource(fileURI);
            resource.getContents().add((Object)this.ocfContainer);
            resource.save(null);
        }
    }

    private class VersionDetector
    extends DefaultHandler2 {
        private String versionString;

        private VersionDetector() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("opf:package") || qName.equals("package")) {
                this.versionString = attributes.getValue("version");
            }
        }
    }
}

