/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.epub.opf.util;

import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.mylyn.docs.epub.opf.Guide;
import org.eclipse.mylyn.docs.epub.opf.Item;
import org.eclipse.mylyn.docs.epub.opf.Itemref;
import org.eclipse.mylyn.docs.epub.opf.Manifest;
import org.eclipse.mylyn.docs.epub.opf.Meta;
import org.eclipse.mylyn.docs.epub.opf.Metadata;
import org.eclipse.mylyn.docs.epub.opf.OPFPackage;
import org.eclipse.mylyn.docs.epub.opf.Package;
import org.eclipse.mylyn.docs.epub.opf.Reference;
import org.eclipse.mylyn.docs.epub.opf.Role;
import org.eclipse.mylyn.docs.epub.opf.Spine;
import org.eclipse.mylyn.docs.epub.opf.Tours;
import org.eclipse.mylyn.docs.epub.opf.Type;

public class OPFValidator
extends EObjectValidator {
    public static final OPFValidator INSTANCE = new OPFValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.mylyn.docs.epub.opf";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return OPFPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validatePackage((Package)value, diagnostics, context);
            }
            case 1: {
                return this.validateMetadata((Metadata)value, diagnostics, context);
            }
            case 2: {
                return this.validateManifest((Manifest)value, diagnostics, context);
            }
            case 3: {
                return this.validateItem((Item)value, diagnostics, context);
            }
            case 4: {
                return this.validateSpine((Spine)value, diagnostics, context);
            }
            case 5: {
                return this.validateGuide((Guide)value, diagnostics, context);
            }
            case 6: {
                return this.validateReference((Reference)value, diagnostics, context);
            }
            case 7: {
                return this.validateItemref((Itemref)value, diagnostics, context);
            }
            case 8: {
                return this.validateTours((Tours)value, diagnostics, context);
            }
            case 9: {
                return this.validateMeta((Meta)value, diagnostics, context);
            }
            case 10: {
                return this.validateRole((Role)((Object)value), diagnostics, context);
            }
            case 11: {
                return this.validateType((Type)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validatePackage(Package package_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(package_, diagnostics, context);
    }

    public boolean validateMetadata(Metadata metadata, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(metadata, diagnostics, context);
    }

    public boolean validateManifest(Manifest manifest, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(manifest, diagnostics, context);
    }

    public boolean validateItem(Item item, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(item, diagnostics, context);
    }

    public boolean validateSpine(Spine spine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(spine, diagnostics, context);
    }

    public boolean validateGuide(Guide guide, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(guide, diagnostics, context);
    }

    public boolean validateReference(Reference reference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(reference, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(reference, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(reference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(reference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(reference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(reference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(reference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(reference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(reference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateReference_validType(reference, diagnostics, context);
        }
        return result;
    }

    public boolean validateReference_validType(Reference reference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (reference.getType().startsWith("other.")) {
            return true;
        }
        if (Type.get(reference.getType()) == null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"validType", OPFValidator.getObjectLabel((EObject)reference, context)}, new Object[]{reference}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateItemref(Itemref itemref, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(itemref, diagnostics, context);
    }

    public boolean validateTours(Tours tours, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(tours, diagnostics, context);
    }

    public boolean validateMeta(Meta meta, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(meta, diagnostics, context);
    }

    public boolean validateRole(Role role, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateType(Type type, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

