/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.docs.epub.core;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class EPUBFileUtil {
    static final int BUFFERSIZE = 2048;
    private static TikaConfig tika;

    public static void copy(File source, File destination) throws IOException {
        destination.getParentFile().mkdirs();
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(source);
            to = new FileOutputStream(destination);
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        catch (Throwable throwable) {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException iOException) {}
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (from != null) {
            try {
                from.close();
            }
            catch (IOException iOException) {}
        }
        if (to != null) {
            try {
                to.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String getMimeType(File file) {
        try {
            if (tika == null) {
                tika = new TikaConfig();
            }
            Metadata metadata = new Metadata();
            metadata.set("resourceName", file.getName());
            MediaType detect = tika.getDetector().detect((InputStream)TikaInputStream.get((File)file), metadata);
            return detect.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TikaException e) {
            throw new RuntimeException(e);
        }
    }

    private static void getPathSegments(File root, File file, ArrayList<String> segments) {
        if (root.equals(file) || file == null) {
            return;
        }
        segments.add(0, file.getName());
        EPUBFileUtil.getPathSegments(root, file.getParentFile(), segments);
    }

    public static String getRelativePath(File root, File file) {
        ArrayList<String> segments = new ArrayList<String>();
        if (root.isFile()) {
            root = root.getParentFile();
        }
        EPUBFileUtil.getPathSegments(root, file, segments);
        StringBuilder path = new StringBuilder();
        int p = 0;
        while (p < segments.size()) {
            if (p > 0) {
                path.append('/');
            }
            path.append(segments.get(p));
            ++p;
        }
        if (file.isDirectory()) {
            path.append('/');
        }
        return path.toString();
    }

    public static void unzip(File epubfile, File destination) throws IOException {
        if (!destination.exists() && !destination.mkdirs()) {
            throw new IOException("Could not create directory for EPUB contents");
        }
        ZipInputStream in = new ZipInputStream(new FileInputStream(epubfile));
        byte[] buf = new byte[2048];
        ZipEntry entry = null;
        while ((entry = in.getNextEntry()) != null) {
            int n;
            String entryName = entry.getName();
            File newFile = new File(String.valueOf(destination.getAbsolutePath()) + File.separator + entryName);
            if (entry.isDirectory()) {
                newFile.mkdirs();
                if (entry.getTime() <= 0L) continue;
                newFile.setLastModified(entry.getTime());
                continue;
            }
            newFile.getParentFile().mkdirs();
            FileOutputStream fileoutputstream = new FileOutputStream(newFile);
            while ((n = in.read(buf, 0, 2048)) > -1) {
                fileoutputstream.write(buf, 0, n);
            }
            fileoutputstream.close();
            in.closeEntry();
            if (entry.getTime() <= 0L) continue;
            newFile.setLastModified(entry.getTime());
        }
        in.close();
        destination.setLastModified(epubfile.lastModified());
    }

    public static void writeEPUBHeader(ZipOutputStream zos) throws IOException {
        byte[] bytes = "application/epub+zip".getBytes("ASCII");
        ZipEntry mimetype = new ZipEntry("mimetype");
        mimetype.setMethod(0);
        mimetype.setSize(bytes.length);
        mimetype.setCompressedSize(bytes.length);
        CRC32 crc = new CRC32();
        crc.update(bytes);
        mimetype.setCrc(crc.getValue());
        zos.putNextEntry(mimetype);
        zos.write(bytes);
        zos.closeEntry();
    }

    public static void zip(File destination, File folder) throws ZipException, IOException {
        if (destination.exists()) {
            throw new IOException("A file already exists at " + destination.getAbsolutePath());
        }
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(destination));
        EPUBFileUtil.writeEPUBHeader(out);
        EPUBFileUtil.zip(folder, folder, out);
        out.close();
    }

    private static void zip(File root, File folder, ZipOutputStream out) throws IOException {
        File[] dirs;
        File[] files = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isDirectory();
            }
        });
        byte[] tmpBuf = new byte[2048];
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            int len;
            File file = fileArray[n2];
            FileInputStream in = new FileInputStream(file.getAbsolutePath());
            ZipEntry zipEntry = new ZipEntry(EPUBFileUtil.getRelativePath(root, file));
            out.putNextEntry(zipEntry);
            while ((len = in.read(tmpBuf)) > 0) {
                out.write(tmpBuf, 0, len);
            }
            out.closeEntry();
            in.close();
            ++n2;
        }
        File[] fileArray2 = dirs = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        int n3 = dirs.length;
        n = 0;
        while (n < n3) {
            File dir = fileArray2[n];
            out.putNextEntry(new ZipEntry(EPUBFileUtil.getRelativePath(root, dir)));
            EPUBFileUtil.zip(root, dir, out);
            ++n;
        }
    }
}

