/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.tracwiki.core.token;

import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;
import org.eclipse.mylyn.wikitext.tracwiki.core.TracWikiLanguage;

public class RevisionLogReplacementToken
extends PatternBasedElement {
    protected String getPattern(int groupOffset) {
        return "(r(\\d+):(\\d+))|(\\[(\\d+):(\\d+)(?:/(\\w+))?\\])|(log:(?:(\\w+))?@(\\d+):(\\d+))";
    }

    protected int getPatternGroupCount() {
        return 11;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new RevisionLogReplacementTokenProcessor();
    }

    private static class RevisionLogReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private RevisionLogReplacementTokenProcessor() {
        }

        public void emit() {
            String text = this.group(1);
            String revision1 = this.group(2);
            String revision2 = this.group(3);
            String restriction = null;
            if (revision1 == null) {
                text = this.group(4);
                revision1 = this.group(5);
                revision2 = this.group(6);
                restriction = this.group(7);
                if (revision1 == null) {
                    text = this.group(8);
                    revision1 = this.group(10);
                    revision2 = this.group(11);
                    restriction = this.group(9);
                }
            }
            String href = ((TracWikiLanguage)this.markupLanguage).toRevisionLogHref(revision1, revision2, restriction);
            this.builder.link(href, text);
        }
    }
}

