/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.editor;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.ui.BugzillaImages;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BugzillaSeeAlsoAttributeEditor
extends AbstractAttributeEditor {
    private Table seeAlsoTable;
    private TaskAttribute attrRemoveSeeAlso;
    private final String[] seeAlsoColumns = new String[]{"", Messages.BugzillaSeeAlsoAttributeEditor_Remove, Messages.BugzillaSeeAlsoAttributeEditor_URL};
    private final int[] seeAlsoColumnWidths = new int[]{25, 60, 100};
    private TableViewer seeAlsoViewer;
    final Action copyURLToClipAction = new Action(Messages.BugzillaSeeAlsoAttributeEditor_CopyURL){

        public void run() {
            Object firstElement;
            StructuredSelection selection = (StructuredSelection)BugzillaSeeAlsoAttributeEditor.this.seeAlsoViewer.getSelection();
            if (selection != null && (firstElement = selection.getFirstElement()) != null) {
                Clipboard clip = new Clipboard(PlatformUI.getWorkbench().getDisplay());
                clip.setContents(new Object[]{(String)firstElement}, new Transfer[]{TextTransfer.getInstance()});
                clip.dispose();
            }
        }
    };
    final Action openAction = new Action(Messages.BugzillaSeeAlsoAttributeEditor_Open){

        public void run() {
            StructuredSelection selection = (StructuredSelection)BugzillaSeeAlsoAttributeEditor.this.seeAlsoViewer.getSelection();
            if (selection != null) {
                for (String url : selection.toList()) {
                    BrowserUtil.openUrl((String)url);
                }
            }
        }
    };
    final Action toggelRemoveStateAction = new Action(Messages.BugzillaSeeAlsoAttributeEditor_ToggelRemoveState){

        public void run() {
            StructuredSelection selection = (StructuredSelection)BugzillaSeeAlsoAttributeEditor.this.seeAlsoViewer.getSelection();
            boolean changed = false;
            if (selection != null) {
                for (String url : selection.toList()) {
                    if (BugzillaSeeAlsoAttributeEditor.this.attrRemoveSeeAlso.getValues().contains(url)) {
                        BugzillaSeeAlsoAttributeEditor.this.attrRemoveSeeAlso.removeValue(url);
                    } else {
                        BugzillaSeeAlsoAttributeEditor.this.attrRemoveSeeAlso.addValue(url);
                    }
                    changed = true;
                }
                if (changed) {
                    BugzillaSeeAlsoAttributeEditor.this.getModel().attributeChanged(BugzillaSeeAlsoAttributeEditor.this.attrRemoveSeeAlso);
                    BugzillaSeeAlsoAttributeEditor.this.seeAlsoViewer.refresh();
                }
            }
        }
    };

    public BugzillaSeeAlsoAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.MULTIPLE, LayoutHint.ColumnSpan.MULTIPLE));
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.attrRemoveSeeAlso = this.getModel().getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.REMOVE_SEE_ALSO.getKey());
        if (this.attrRemoveSeeAlso == null) {
            this.attrRemoveSeeAlso = BugzillaTaskDataHandler.createAttribute((TaskData)this.getModel().getTaskData(), (BugzillaAttribute)BugzillaAttribute.REMOVE_SEE_ALSO);
        }
        this.createSeeAlsoTable(toolkit, parent);
        this.setControl((Control)this.seeAlsoTable);
    }

    private void createSeeAlsoTable(FormToolkit toolkit, Composite seeAlsoComposite) {
        this.seeAlsoTable = toolkit.createTable(seeAlsoComposite, 65538);
        this.seeAlsoTable.setLinesVisible(true);
        this.seeAlsoTable.setHeaderVisible(true);
        this.seeAlsoTable.setLayout((Layout)new GridLayout());
        this.seeAlsoTable.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        int i = 0;
        while (i < this.seeAlsoColumns.length) {
            TableColumn column = new TableColumn(this.seeAlsoTable, 16384, i);
            column.setText(this.seeAlsoColumns[i]);
            column.setWidth(this.seeAlsoColumnWidths[i]);
            column.setMoveable(true);
            ++i;
        }
        this.seeAlsoViewer = new TableViewer(this.seeAlsoTable);
        this.seeAlsoViewer.setUseHashlookup(true);
        this.seeAlsoViewer.setColumnProperties(this.seeAlsoColumns);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.seeAlsoViewer, (int)2);
        this.seeAlsoViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.seeAlsoViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                this.openseeAlso(event);
            }

            private void openseeAlso(OpenEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                for (String item : selection.toList()) {
                    BrowserUtil.openUrl((String)item);
                }
            }
        });
        this.seeAlsoViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                String value = (String)element;
                if (columnIndex == 0) {
                    if (value.contains("/r/#/c/")) {
                        return CommonImages.getImage((ImageDescriptor)BugzillaImages.GERRIT);
                    }
                    if (value.contains("/commit/?id=")) {
                        return CommonImages.getImage((ImageDescriptor)BugzillaImages.GIT);
                    }
                    return CommonImages.getImage((ImageDescriptor)BugzillaImages.BUG);
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                String value = (String)element;
                switch (columnIndex) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return BugzillaSeeAlsoAttributeEditor.this.attrRemoveSeeAlso.getValues().contains(value) ? Messages.BugzillaSeeAlsoAttributeEditor_Yes : Messages.BugzillaSeeAlsoAttributeEditor_No;
                    }
                }
                return value;
            }

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                cell.setText(this.getColumnText(element, cell.getColumnIndex()));
                Image image = this.getColumnImage(element, cell.getColumnIndex());
                cell.setImage(image);
                cell.setBackground(this.getBackground(element));
                cell.setForeground(this.getForeground(element));
                cell.setFont(this.getFont(element));
            }
        });
        this.seeAlsoViewer.setInput((Object)this.getTaskAttribute().getValues().toArray());
        GC gc = new GC((Drawable)seeAlsoComposite);
        int maxSize = 0;
        for (String string : this.getTaskAttribute().getValues()) {
            Point size = gc.textExtent(string);
            if (size.x <= maxSize) continue;
            maxSize = size.x;
        }
        if (maxSize == 0) {
            maxSize = 100;
        }
        this.seeAlsoTable.getColumn(2).setWidth(maxSize);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)BugzillaSeeAlsoAttributeEditor.this.openAction);
                manager.add((IAction)BugzillaSeeAlsoAttributeEditor.this.copyURLToClipAction);
                manager.add((IAction)BugzillaSeeAlsoAttributeEditor.this.toggelRemoveStateAction);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.seeAlsoTable);
        this.seeAlsoTable.setMenu(menu);
    }
}

