/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.data.AccountInfo;
import com.google.gerrit.common.data.AccountInfoCache;
import com.google.gerrit.common.data.ApprovalDetail;
import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.common.data.ReviewerResult;
import com.google.gerrit.common.data.ToggleStarRequest;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.AccountDiffPreference;
import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.ContributorAgreement;
import com.google.gerrit.reviewdb.Patch;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.Project;
import com.google.gson.reflect.TypeToken;
import com.google.gwtjsonrpc.client.RemoteJsonService;
import com.google.gwtjsonrpc.client.VoidResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritAuthenticationState;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient29;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClientStateListener;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHtmlProcessor;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritRestClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritService;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritSystemInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritVersion;
import org.eclipse.mylyn.internal.gerrit.core.client.PatchSetContent;
import org.eclipse.mylyn.internal.gerrit.core.client.ProjectByNameComparator;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailService;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.GerritConfigX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchDetailService;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchScriptX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchSetPublishDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ProjectAdminService;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ProjectDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.data.GerritQueryResult;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.AbandonInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.AddReviewerResult;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.BranchInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.BranchInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ChangeInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ChangeInfo28;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.CherryPickInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.CommentInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.CommitInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ProjectInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.RestoreInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewerInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewerInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.RevisionInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.SubmitInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.SubmitInput;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritRemoteFactoryProvider;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.spi.ReviewsClient;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.AbstractRemoteEmfFactoryProvider;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public abstract class GerritClient
extends ReviewsClient {
    private final Cache<Project.NameKey, Set<String>> projectBranchMap = CacheBuilder.newBuilder().build();
    final String NOT_SIGNED_IN = "Not Signed In";
    private static final Pattern GERRIT_VERSION_PATTERN = Pattern.compile("Powered by Gerrit Code Review (.+)</p>");
    private GerritHttpClient client;
    private GerritRestClient restClient;
    private volatile GerritConfiguration config;
    private Account myAccount;
    private final Version version;
    private Map<Class<? extends RemoteJsonService>, RemoteJsonService> serviceByClass;
    private GerritClientStateListener stateListener;
    private volatile boolean configRefreshed;

    public abstract ChangeDetail rebase(String var1, int var2, IProgressMonitor var3) throws GerritException;

    protected abstract Account executeAccount(IProgressMonitor var1) throws GerritException;

    public abstract ChangeDetailX getChangeDetail(int var1, IProgressMonitor var2) throws GerritException;

    public abstract PatchSetPublishDetailX getPatchSetPublishDetail(PatchSet.Id var1, IProgressMonitor var2) throws GerritException;

    public abstract CommentInput saveDraft(Patch.Key var1, String var2, int var3, short var4, String var5, String var6, IProgressMonitor var7) throws GerritException;

    public abstract VoidResult deleteDraft(Patch.Key var1, String var2, IProgressMonitor var3) throws GerritException;

    protected abstract void applyPatchSetInfo(PatchSetDetail var1, PatchSetPublishDetailX var2, IProgressMonitor var3) throws GerritException;

    public static GerritClient create(TaskRepository repository, AbstractWebLocation location) {
        return GerritClient.create(repository, location, null, null, null, null);
    }

    public static GerritClient create(TaskRepository repository, AbstractWebLocation location, GerritConfiguration config, GerritAuthenticationState authState, String xsrfKey, GerritClientStateListener stateListener) {
        Version version = Version.emptyVersion;
        GerritClient29 versionDiscoveryClient = new GerritClient29(repository, version);
        versionDiscoveryClient.initialize(location, config, authState, xsrfKey, stateListener);
        try {
            version = versionDiscoveryClient.getVersion((IProgressMonitor)new NullProgressMonitor());
        }
        catch (GerritException gerritException) {}
        GerritClient29 client = new GerritClient29(repository, version);
        client.initialize(location, config, authState, xsrfKey, stateListener);
        return client;
    }

    protected GerritClient(TaskRepository repository, Version version) {
        super(repository);
        Assert.isNotNull((Object)version);
        this.version = version;
    }

    protected void initialize(AbstractWebLocation location, GerritConfiguration config, GerritAuthenticationState authState, String xsrfKey, final GerritClientStateListener stateListener) {
        this.stateListener = stateListener;
        this.client = new GerritHttpClient(location){

            @Override
            protected void sessionChanged(Cookie cookie) {
                GerritAuthenticationState authState = new GerritAuthenticationState();
                authState.setCookie(cookie);
                if (stateListener != null) {
                    stateListener.authStateChanged(authState);
                }
            }
        };
        if (authState != null) {
            this.client.setXsrfCookie(authState.getCookie());
        }
        if (xsrfKey != null) {
            this.client.setXsrfKey(xsrfKey);
        }
        this.serviceByClass = new HashMap<Class<? extends RemoteJsonService>, RemoteJsonService>();
        this.config = config;
        this.restClient = new GerritRestClient(this.client);
    }

    public GerritSystemInfo getInfo(IProgressMonitor monitor) throws GerritException {
        List<ContributorAgreement> contributorAgreements = null;
        Account account = null;
        if (!this.isAnonymous()) {
            account = this.getAccount(monitor);
        } else {
            this.restClient.executeQuery(monitor, "status:open");
        }
        this.refreshConfigOnce(monitor);
        return new GerritSystemInfo(this.getVersion(), contributorAgreements, account);
    }

    public GerritConfiguration refreshConfigOnce(IProgressMonitor monitor) throws GerritException {
        return this.refreshConfigOnce(null, monitor);
    }

    public GerritConfiguration refreshConfigOnce(Project.NameKey project, IProgressMonitor monitor) throws GerritException {
        if (!this.configRefreshed && this.config == null) {
            try {
                this.refreshConfig(monitor);
            }
            catch (GerritException gerritException) {}
        }
        GerritConfiguration config = this.getConfiguration();
        if (project != null && this.getCachedBranches(project) == null) {
            this.cacheBranches(project, monitor);
        }
        return config;
    }

    public GerritConfiguration getConfiguration() {
        return this.config;
    }

    public GerritConfigX getGerritConfig() {
        return this.config == null ? null : this.config.getGerritConfig();
    }

    private GerritConfigX refreshGerritConfig(final IProgressMonitor monitor) throws GerritException {
        try {
            GerritConfigX gerritConfig = this.client.execute(new GerritHttpClient.Request<GerritConfigX>(){

                @Override
                public HttpMethodBase createMethod() throws IOException {
                    return new GetMethod(String.valueOf(GerritClient.this.client.getUrl()) + "/");
                }

                @Override
                public GerritConfigX process(HttpMethodBase method) throws IOException {
                    try (InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, (IProgressMonitor)monitor);){
                        GerritHtmlProcessor processor = new GerritHtmlProcessor();
                        processor.parse(in, method.getResponseCharSet());
                        GerritConfigX gerritConfigX = processor.getConfig();
                        return gerritConfigX;
                    }
                }
            }, monitor);
            if (gerritConfig == null) {
                throw new GerritException("Failed to obtain Gerrit configuration");
            }
            return gerritConfig;
        }
        catch (UnknownHostException cause) {
            GerritException e = new GerritException("Unknown host: " + cause.getMessage());
            e.initCause(cause);
            throw e;
        }
        catch (IOException cause) {
            GerritException e = new GerritException(cause.getMessage());
            e.initCause(cause);
            throw e;
        }
    }

    public GerritConfiguration refreshConfig(IProgressMonitor monitor) throws GerritException {
        Account account;
        List<Project> projects;
        GerritConfigX gerritConfig;
        block3: {
            this.refreshAllCachedProjectBranches(monitor);
            this.configRefreshed = true;
            gerritConfig = this.refreshGerritConfig(monitor);
            projects = this.getVisibleProjects(monitor, gerritConfig);
            account = null;
            try {
                account = this.getAccount(monitor);
            }
            catch (GerritException e) {
                if (this.isNotSignedInException(e)) break block3;
                throw e;
            }
        }
        this.config = new GerritConfiguration(gerritConfig, projects, account);
        if (this.stateListener != null) {
            this.stateListener.configurationChanged(this.config);
        }
        return this.config;
    }

    public boolean isNotSignedInException(Throwable exception) {
        if (exception instanceof GerritException) {
            return ((GerritException)exception).getCode() == -32603 && "Not Signed In".equalsIgnoreCase(((GerritException)exception).getMessage());
        }
        return false;
    }

    private List<Project> getVisibleProjects(IProgressMonitor monitor, GerritConfig gerritConfig) throws GerritException {
        ArrayList<Project> result = new ArrayList<Project>();
        try {
            List<ProjectDetailX> projectDetails = this.restClient.execute(monitor, new GerritRestClient.Operation<List<ProjectDetailX>>(this.client){

                @Override
                public void execute(IProgressMonitor monitor) throws GerritException {
                    GerritClient.this.getProjectAdminService(monitor).visibleProjectDetails(this);
                }
            });
            for (ProjectDetailX projectDetail : projectDetails) {
                if (GerritUtil.isPermissionOnlyProject(projectDetail, gerritConfig)) continue;
                result.add(projectDetail.project);
            }
        }
        catch (GerritException e) {
            if (this.isNoSuchServiceError(e)) {
                this.addProjectsWhenNoSuchService(monitor, gerritConfig, result);
            }
            throw e;
        }
        Collections.sort(result, new ProjectByNameComparator());
        return result;
    }

    private boolean isNoSuchServiceError(GerritException e) {
        String message = e.getMessage();
        return message != null && message.contains("No such service method");
    }

    public GerritChange getChange(String reviewId, IProgressMonitor monitor) throws GerritException {
        int id;
        GerritChange gerritChange = new GerritChange();
        try {
            id = this.id(reviewId);
        }
        catch (GerritException e) {
            List<GerritQueryResult> result = this.restClient.executeQuery(monitor, reviewId);
            if (result.size() == 1) {
                id = result.get(0).getNumber();
            }
            throw e;
        }
        ChangeDetailX changeDetail = this.getChangeDetail(id, monitor);
        ArrayList<PatchSetDetail> patchSets = new ArrayList<PatchSetDetail>(changeDetail.getPatchSets().size());
        HashMap<PatchSet.Id, PatchSetPublishDetailX> patchSetPublishDetailByPatchSetId = new HashMap<PatchSet.Id, PatchSetPublishDetailX>();
        for (PatchSet patchSet : changeDetail.getPatchSets()) {
            try {
                PatchSetDetail patchSetDetail = this.getPatchSetDetail(null, patchSet.getId(), monitor);
                patchSets.add(patchSetDetail);
                if (this.isAnonymous()) continue;
                PatchSetPublishDetailX patchSetPublishDetail = this.getPatchSetPublishDetail(patchSet.getId(), monitor);
                this.applyPatchSetInfo(patchSetDetail, patchSetPublishDetail, monitor);
                patchSetPublishDetailByPatchSetId.put(patchSet.getId(), patchSetPublishDetail);
                changeDetail.setCurrentPatchSetDetail(patchSetDetail);
            }
            catch (GerritException e) {
                this.handleMissingPatchSet(NLS.bind((String)"Patch Set {0} items for Review {1}", (Object)patchSet.getPatchSetId(), (Object)reviewId), e);
            }
        }
        gerritChange.setChangeDetail(changeDetail);
        gerritChange.setPatchSets(patchSets);
        gerritChange.setPatchSetPublishDetailByPatchSetId(patchSetPublishDetailByPatchSetId);
        return gerritChange;
    }

    public void loadPatchSetContent(PatchSetContent patchSetContent, IProgressMonitor monitor) throws GerritException {
        PatchSet.Id baseId = patchSetContent.getBase() != null ? patchSetContent.getBase().getId() : null;
        PatchSet.Id targetId = patchSetContent.getTarget().getId();
        if (patchSetContent.getTargetDetail() == null) {
            PatchSetDetail targetDetail = this.getPatchSetDetail(baseId, targetId, monitor);
            patchSetContent.setTargetDetail(targetDetail);
        }
        for (Patch patch : patchSetContent.getTargetDetail().getPatches()) {
            PatchScriptX patchScript = this.getPatchScript(patch.getKey(), baseId, targetId, monitor);
            if (patchScript == null) continue;
            patchSetContent.putPatchScriptByPatchKey(patch.getKey(), patchScript);
        }
    }

    private PatchSetDetail getPatchSetDetail(final PatchSet.Id idBase, final PatchSet.Id idTarget, IProgressMonitor monitor) throws GerritException {
        PatchSetDetail patchSetDetail = null;
        patchSetDetail = this.restClient.execute(monitor, new GerritRestClient.Operation<PatchSetDetail>(this.client){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getChangeDetailService(monitor).patchSetDetail2(idBase, idTarget, GerritClient.this.createAccountDiffPreference(), this);
            }
        });
        return patchSetDetail;
    }

    private PatchScriptX getPatchScript(final Patch.Key key, final PatchSet.Id leftId, final PatchSet.Id rightId, IProgressMonitor monitor) throws GerritException {
        final AccountDiffPreference diffPrefs = this.createAccountDiffPreference();
        PatchScriptX patchScript = this.restClient.execute(monitor, new GerritRestClient.Operation<PatchScriptX>(this.client){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getPatchDetailService(monitor).patchScriptX(key, leftId, rightId, diffPrefs, this);
            }
        });
        if (patchScript.isBinary()) {
            this.fetchLeftBinaryContent(patchScript, key, leftId, monitor);
            this.fetchRightBinaryContent(patchScript, key, rightId, monitor);
        }
        return patchScript;
    }

    protected void fetchLeftBinaryContent(PatchScriptX patchScript, Patch.Key key, PatchSet.Id leftId, IProgressMonitor monitor) throws GerritException {
        if (patchScript.getChangeType() != Patch.ChangeType.ADDED) {
            byte[] binaryContent = this.fetchBinaryContent(this.getUrlForPatchSetOrBase(key, leftId), monitor);
            patchScript.setBinaryA(binaryContent);
        }
    }

    protected void fetchRightBinaryContent(PatchScriptX patchScript, Patch.Key key, PatchSet.Id rightId, IProgressMonitor monitor) throws GerritException {
        if (patchScript.getChangeType() != Patch.ChangeType.DELETED) {
            byte[] binaryContent = this.fetchBinaryContent(this.getUrlForPatchSet(key, rightId), monitor);
            patchScript.setBinaryB(binaryContent);
        }
    }

    protected String getUrlForPatchSetOrBase(Patch.Key key, PatchSet.Id id) throws GerritException {
        if (id == null) {
            return this.getUrlForBase(key);
        }
        return this.getUrlForPatchSet(key, id);
    }

    private String getUrlForBase(Patch.Key key) throws GerritException {
        return GerritClient.encode(String.valueOf(key.toString()) + "^1");
    }

    protected String getUrlForPatchSet(Patch.Key key, PatchSet.Id id) throws GerritException {
        return GerritClient.encode(id + "," + key.getFileName() + "^0");
    }

    protected byte[] fetchBinaryContent(String url, IProgressMonitor monitor) throws GerritException {
        TypeToken<Byte[]> byteArrayType = new TypeToken<Byte[]>(){};
        byte[] bin = (byte[])this.restClient.executeGetRestRequest("/cat/" + url, byteArrayType.getType(), monitor);
        if (GerritClient.isZippedContent(bin)) {
            return GerritClient.unzip(bin);
        }
        return bin;
    }

    public static boolean isZippedContent(byte[] bin) {
        return bin != null && bin.length > 4 && bin[0] == 80 && bin[1] == 75 && bin[2] == 3 && bin[3] == 4;
    }

    public static byte[] unzip(byte[] zip) throws GerritException {
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zip));
        try {
            zis.getNextEntry();
            byte[] byArray = IOUtils.toByteArray((InputStream)zis);
            return byArray;
        }
        catch (IOException e) {
            throw new GerritException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)zis);
        }
    }

    private AccountDiffPreference createAccountDiffPreference() {
        AccountDiffPreference diffPrefs = new AccountDiffPreference(null);
        diffPrefs.setLineLength(Integer.MAX_VALUE);
        diffPrefs.setTabSize(4);
        diffPrefs.setContext((short)-1);
        diffPrefs.setIgnoreWhitespace(AccountDiffPreference.Whitespace.IGNORE_NONE);
        diffPrefs.setIntralineDifference(false);
        return diffPrefs;
    }

    private ChangeDetailService getChangeDetailService(IProgressMonitor monitor) {
        return this.getService(ChangeDetailService.class, monitor);
    }

    private PatchDetailService getPatchDetailService(IProgressMonitor monitor) {
        return this.getService(PatchDetailService.class, monitor);
    }

    private ProjectAdminService getProjectAdminService(IProgressMonitor monitor) {
        return this.getService(ProjectAdminService.class, monitor);
    }

    private synchronized <T extends RemoteJsonService> T getService(Class<T> clazz, IProgressMonitor monitor) {
        Object service = this.serviceByClass.get(clazz);
        if (service == null) {
            service = GerritService.create(clazz, this.client, this.getVersion());
            this.serviceByClass.put((Class<? extends RemoteJsonService>)clazz, (RemoteJsonService)service);
        }
        return (T)((RemoteJsonService)clazz.cast(service));
    }

    protected List<ReviewerInfo> listReviewers(int reviewId, IProgressMonitor monitor) throws GerritException {
        String uri = "/changes/" + reviewId + "/reviewers/";
        TypeToken<List<ReviewerInfo>> reviewersListType = new TypeToken<List<ReviewerInfo>>(){};
        return (List)this.restClient.executeGetRestRequest(uri, reviewersListType.getType(), monitor);
    }

    protected boolean hasAllReviewers(AccountInfoCache accounts, List<ReviewerInfo> reviewers) {
        for (ReviewerInfo reviewer : reviewers) {
            AccountInfo cachedAccount = accounts.get(new Account.Id(reviewer.getId()));
            if (cachedAccount != null && !this.isAnonymous(cachedAccount)) continue;
            return false;
        }
        return true;
    }

    public ReviewerResult addReviewers(String reviewId, List<String> reviewers, IProgressMonitor monitor) throws GerritException {
        Assert.isLegal((reviewers != null ? 1 : 0) != 0, (String)"reviewers cannot be null");
        Change.Id id = new Change.Id(this.id(reviewId));
        String uri = "/a/changes/" + id.get() + "/reviewers";
        HashSet<ReviewerInfo> reviewerInfos = new HashSet<ReviewerInfo>(reviewers.size());
        ReviewerResult reviewerResult = new ReviewerResult();
        for (String reviewerId : reviewers) {
            try {
                AddReviewerResult addReviewerResult = (AddReviewerResult)this.restClient.executePostRestRequest(uri, new ReviewerInput(reviewerId), (Type)((Object)AddReviewerResult.class), null, monitor);
                reviewerInfos.addAll(addReviewerResult.getReviewers());
            }
            catch (GerritHttpException e) {
                if (e.getResponseCode() != 422) continue;
                reviewerResult.addError(new ReviewerResult.Error(null, reviewerId));
            }
        }
        ChangeDetailX changeDetail = this.getChangeDetail(id.get(), monitor);
        ArrayList<ApprovalDetail> approvalDetails = new ArrayList<ApprovalDetail>(reviewerInfos.size());
        for (ReviewerInfo reviewerInfo : reviewerInfos) {
            approvalDetails.add(reviewerInfo.toApprovalDetail(changeDetail.getCurrentPatchSet()));
        }
        changeDetail.setApprovals(approvalDetails);
        reviewerResult.setChange((ChangeDetail)changeDetail);
        return reviewerResult;
    }

    protected void merge(AccountInfoCache accounts, List<ReviewerInfo> reviewers) {
        HashSet<AccountInfo> accountInfos = new HashSet<AccountInfo>(reviewers.size());
        for (ReviewerInfo reviewer : reviewers) {
            accountInfos.add(reviewer.toAccountInfo());
        }
        AccountInfoCache accountInfoCache = new AccountInfoCache(accountInfos);
        accounts.merge(accountInfoCache);
    }

    public ChangeDetail cherryPick(String reviewId, int patchSetId, String message, String destBranch, IProgressMonitor monitor) throws GerritException {
        PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        String url = "/changes/" + id.getParentKey() + "/revisions/" + id.get() + "/cherrypick";
        CherryPickInput input = new CherryPickInput(message, destBranch);
        GerritHttpClient.ErrorHandler handler = new GerritHttpClient.ErrorHandler(){

            @Override
            public void handleError(HttpMethodBase method) throws GerritException {
                String errorMsg = this.getResponseBodyAsString(method);
                if (this.isNotPermitted(method, errorMsg)) {
                    errorMsg = NLS.bind((String)"Cannot cherry pick: {0}", (Object)errorMsg);
                } else if (this.isConflict(method)) {
                    errorMsg = NLS.bind((String)"Request Conflict: {0}", (Object)errorMsg);
                } else if (this.isBadRequest(method)) {
                    errorMsg = NLS.bind((String)"Bad Request: {0}", (Object)errorMsg);
                }
                throw new GerritException(errorMsg);
            }

            private String getResponseBodyAsString(HttpMethodBase method) {
                try {
                    return method.getResponseBodyAsString();
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            private boolean isNotPermitted(HttpMethodBase method, String msg) {
                return method.getStatusCode() == 403 && msg.toLowerCase().startsWith("cherry pick not permitted");
            }

            private boolean isConflict(HttpMethodBase method) {
                return method.getStatusCode() == 409;
            }

            private boolean isBadRequest(HttpMethodBase method) {
                return method.getStatusCode() == 400;
            }
        };
        ChangeInfo result = (ChangeInfo)this.restClient.executePostRestRequest(url, input, (Type)((Object)ChangeInfo.class), handler, monitor);
        return this.getChangeDetail(result.getNumber(), monitor);
    }

    private Map<String, ProjectInfo> listProjects(IProgressMonitor monitor) throws GerritException {
        TypeToken<Map<String, ProjectInfo>> resultType = new TypeToken<Map<String, ProjectInfo>>(){};
        return (Map)this.restClient.executeGetRestRequest("/projects/", resultType.getType(), monitor);
    }

    private void addProjectsWhenNoSuchService(IProgressMonitor monitor, GerritConfig gerritConfig, List<Project> result) throws GerritException {
        Map<String, ProjectInfo> projects = this.listProjects(monitor);
        for (String projectName : projects.keySet()) {
            result.add(new Project(new Project.NameKey(projectName)));
        }
    }

    public VoidResult setStarred(String reviewId, final boolean starred, IProgressMonitor monitor) throws GerritException {
        Change.Id id = new Change.Id(this.id(reviewId));
        final ToggleStarRequest req = new ToggleStarRequest();
        req.toggle(id, starred);
        final String uri = "/a/accounts/self/starred.changes/" + id.get();
        return this.restClient.execute(monitor, new GerritRestClient.Operation<VoidResult>(this.client){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                if (starred) {
                    GerritClient.this.restClient.executePutRestRequest(uri, req, (Type)((Object)ToggleStarRequest.class), GerritClient.this.createErrorHandler(), monitor);
                } else {
                    GerritClient.this.restClient.executeDeleteRestRequest(uri, req, (Type)((Object)ToggleStarRequest.class), GerritClient.this.createErrorHandler(), monitor);
                }
            }
        });
    }

    protected void setRevisionParentCommit(ChangeInfo changeInfo, ChangeDetailX changeDetail) {
        if (changeInfo.getRevisions() != null) {
            for (Map.Entry<String, RevisionInfo> revisions : changeInfo.getRevisions().entrySet()) {
                CommitInfo commit;
                RevisionInfo revision = revisions.getValue();
                if (revision.getCommit() == null || (commit = revision.getCommit()).getParents().length < 1) continue;
                if (changeDetail.getParents() == null) {
                    changeDetail.setParents(new HashMap<Integer, CommitInfo[]>());
                }
                changeDetail.getParents().put(revision.getNumber(), commit.getParents());
            }
        }
    }

    protected ChangeInfo28 getAdditionalChangeInfo(int reviewId, IProgressMonitor monitor) {
        ChangeInfo28 changeInfo28 = null;
        try {
            changeInfo28 = (ChangeInfo28)this.restClient.executeGetRestRequest("/changes/" + Integer.toString(reviewId) + "/?o=ALL_REVISIONS&o=CURRENT_ACTIONS&o=ALL_COMMITS", (Type)((Object)ChangeInfo28.class), monitor);
        }
        catch (GerritException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", e.getMessage(), (Throwable)e));
        }
        return changeInfo28;
    }

    private void refreshAllCachedProjectBranches(IProgressMonitor monitor) throws GerritException {
        Set projects = this.projectBranchMap.asMap().keySet();
        for (Project.NameKey project : projects) {
            this.cacheBranches(project, monitor);
        }
    }

    private void cacheBranches(Project.NameKey project, IProgressMonitor monitor) throws GerritException {
        ImmutableSet<String> branchNames = this.getBranchNames(project, monitor);
        this.projectBranchMap.put((Object)project, branchNames);
    }

    private ImmutableSet<String> getBranchNames(Project.NameKey project, IProgressMonitor monitor) throws GerritException {
        return FluentIterable.from(Arrays.asList(this.getRemoteProjectBranches(project.get(), monitor))).transform((Function)new Function<BranchInfo, String>(){

            public String apply(BranchInfo input) {
                return input.getRef();
            }
        }).toSet();
    }

    public BranchInfo[] getRemoteProjectBranches(String projectName, IProgressMonitor monitor) throws GerritException {
        String url = this.getProjectBranchesUrl(projectName);
        return (BranchInfo[])this.restClient.executeGetRestRequest(url, (Type)((Object)BranchInfo[].class), monitor);
    }

    public void createRemoteBranch(String projectName, String branchName, String revision, IProgressMonitor monitor) throws GerritException {
        String url = String.valueOf(this.getProjectBranchesUrl(projectName)) + branchName;
        BranchInput input = new BranchInput(branchName, revision);
        this.restClient.executePutRestRequest(url, input, (Type)((Object)BranchInput.class), this.createErrorHandler(), monitor);
    }

    public void deleteRemoteBranch(String projectName, String branchName, String revision, IProgressMonitor monitor) throws GerritException {
        String url = String.valueOf(this.getProjectBranchesUrl(projectName)) + branchName;
        BranchInput input = new BranchInput(branchName, revision);
        this.restClient.executeDeleteRestRequest(url, input, (Type)((Object)BranchInput.class), this.createErrorHandler(), monitor);
    }

    public Set<String> getCachedBranches(Project.NameKey project) {
        return (Set)this.projectBranchMap.getIfPresent((Object)project);
    }

    private String getProjectBranchesUrl(String projectName) throws GerritException {
        try {
            String encodedProjectName = URLEncoder.encode(projectName, "UTF-8");
            return "/projects/" + encodedProjectName + "/branches/";
        }
        catch (UnsupportedEncodingException e) {
            throw new GerritException(e);
        }
    }

    public void clearCachedBranches(Project.NameKey project) {
        this.projectBranchMap.invalidate((Object)project);
    }

    public ChangeDetail restore(String reviewId, int patchSetId, String message, IProgressMonitor monitor) throws GerritException {
        PatchSet.Id id;
        block2: {
            id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
            String uri = "/a/changes/" + id.getParentKey().get() + "/restore";
            try {
                this.restClient.executePostRestRequest(uri, new RestoreInput(message), (Type)((Object)ChangeInfo.class), null, monitor);
            }
            catch (GerritHttpException e) {
                if (e.getResponseCode() != 409) break block2;
                throw new GerritException("Not Found", e);
            }
        }
        return this.getChangeDetail(id.getParentKey().get(), monitor);
    }

    public int id(String id) throws GerritException {
        if (id == null) {
            throw new GerritException("Invalid ID (null)");
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException numberFormatException) {
            throw new GerritException(NLS.bind((String)"Invalid ID (''{0}'')", (Object)id));
        }
    }

    public void publishComments(String reviewId, int patchSetId, String message, Set<ApprovalCategoryValue.Id> approvals, IProgressMonitor monitor) throws GerritException {
        PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        ReviewInput reviewInput = new ReviewInput(message);
        Map<String, CommentInput[]> drafts = this.listDrafts(id, monitor);
        if (!drafts.isEmpty()) {
            reviewInput.setComments(drafts);
        }
        reviewInput.setApprovals(approvals);
        String uri = "/a/changes/" + id.getParentKey().get() + "/revisions/" + id.get() + "/review";
        this.restClient.executePostRestRequest(uri, reviewInput, (Type)((Object)ReviewInfo.class), new GerritHttpClient.ErrorHandler(){

            @Override
            public void handleError(HttpMethodBase method) throws GerritException {
                String msg;
                if (method.getStatusCode() == 403 && (msg = this.getResponseBodyAsString(method)).startsWith("Applying label") && msg.endsWith("is restricted")) {
                    throw new GerritException(msg);
                }
            }

            private String getResponseBodyAsString(HttpMethodBase method) {
                try {
                    String msg = method.getResponseBodyAsString();
                    return msg.trim();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }, monitor);
    }

    private void handleMissingPatchSet(String desc, GerritException e) {
        GerritCorePlugin.logWarning(NLS.bind((String)"Couldn't load {0}. (Perhaps the Patch Set has been removed from repository?)", (Object)desc), e);
    }

    public ChangeInfo getChangeInfo(int reviewId, IProgressMonitor monitor) throws GerritException {
        String uri = "/changes/" + reviewId + "/revisions/current/review";
        return (ChangeInfo)this.restClient.executeGetRestRequest(uri, (Type)((Object)ChangeInfo.class), monitor);
    }

    public ChangeDetail abandon(String reviewId, int patchSetId, String message, IProgressMonitor monitor) throws GerritException {
        PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        String uri = "/a/changes/" + id.getParentKey().get() + "/abandon";
        this.restClient.executePostRestRequest(uri, new AbandonInput(message), (Type)((Object)ChangeInfo.class), null, monitor);
        return this.getChangeDetail(id.getParentKey().get(), monitor);
    }

    private boolean isAnonymous(AccountInfo accountInfo) {
        return accountInfo.getFullName() == null && accountInfo.getPreferredEmail() == null;
    }

    public String toReviewId(String id, IProgressMonitor monitor) throws GerritException {
        try {
            Integer.parseInt(id);
            return id;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                List<GerritQueryResult> results = this.restClient.executeQuery(monitor, id);
                if (results.size() != 1) {
                    throw new GerritException(NLS.bind((String)"{0} is not a valid review ID", (Object)id));
                }
                return Integer.toString(results.get(0).getNumber());
            }
            catch (GerritException e2) {
                throw new GerritException(NLS.bind((String)"{0} is not a valid review ID", (Object)id), e2);
            }
        }
    }

    protected static String encode(String string) throws GerritException {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GerritException(e);
        }
    }

    private GerritHttpClient.ErrorHandler createErrorHandler() {
        return new GerritHttpClient.ErrorHandler(){

            @Override
            public void handleError(HttpMethodBase method) throws GerritException {
                throw new GerritException(method.getStatusLine().getReasonPhrase());
            }
        };
    }

    public boolean isAnonymous() {
        return this.client.isAnonymous();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account getAccount(IProgressMonitor monitor) throws GerritException {
        GerritClient gerritClient = this;
        synchronized (gerritClient) {
            if (this.myAccount != null) {
                return this.myAccount;
            }
        }
        Account account = this.executeAccount(monitor);
        GerritClient gerritClient2 = this;
        synchronized (gerritClient2) {
            this.myAccount = account;
        }
        return this.myAccount;
    }

    public ChangeDetail submit(String reviewId, int patchSetId, IProgressMonitor monitor) throws GerritException {
        PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        return this.submitRest(id, monitor);
    }

    private ChangeDetail submitRest(PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        String uri = "/a/changes/" + id.getParentKey().get() + "/revisions/" + id.get() + "/submit";
        this.restClient.executePostRestRequest(uri, new SubmitInput(true), (Type)((Object)SubmitInfo.class), new GerritHttpClient.ErrorHandler(){

            @Override
            public void handleError(HttpMethodBase method) throws GerritException {
                String errorMsg = this.getResponseBodyAsString(method);
                if (this.isNotPermitted(method, errorMsg) || this.isConflict(method)) {
                    throw new GerritException(NLS.bind((String)"Cannot submit change: {0}", (Object)errorMsg));
                }
            }

            private String getResponseBodyAsString(HttpMethodBase method) {
                try {
                    return method.getResponseBodyAsString();
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            private boolean isNotPermitted(HttpMethodBase method, String msg) {
                return method.getStatusCode() == 403 && "submit not permitted\n".equals(msg);
            }

            private boolean isConflict(HttpMethodBase method) {
                return method.getStatusCode() == 409;
            }
        }, monitor);
        return this.getChangeDetail(id.getParentKey().get(), monitor);
    }

    private Map<String, CommentInput[]> listDrafts(PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        String uri = "/changes/" + id.getParentKey().get() + "/revisions/" + id.get() + "/drafts/";
        TypeToken<Map<String, CommentInput[]>> resultType = new TypeToken<Map<String, CommentInput[]>>(){};
        return (Map)this.restClient.executeGetRestRequest(uri, resultType.getType(), monitor);
    }

    public Version getVersion() {
        return this.version;
    }

    public Version getVersion(IProgressMonitor monitor) throws GerritException {
        return this.restClient.execute(monitor, new GerritRestClient.Operation<Version>(this.client){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                try {
                    GerritHttpClient.Request<String> request = new GerritHttpClient.Request<String>(){

                        @Override
                        public HttpMethodBase createMethod() throws IOException {
                            return new GetMethod(String.valueOf(GerritClient.this.client.getUrl()) + "/tools/hooks/");
                        }

                        @Override
                        public String process(HttpMethodBase method) throws IOException {
                            String content = method.getResponseBodyAsString();
                            Matcher matcher = GERRIT_VERSION_PATTERN.matcher(content);
                            if (matcher.find()) {
                                return matcher.group(1);
                            }
                            return null;
                        }
                    };
                    String result = GerritClient.this.client.execute(request, false, monitor);
                    Version version = GerritVersion.parseGerritVersion(result);
                    this.onSuccess(version);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }
        });
    }

    public AbstractRemoteEmfFactoryProvider<IRepository, IReview> createFactoryProvider() {
        return new GerritRemoteFactoryProvider(this);
    }

    public GerritRestClient getRestClient() {
        return this.restClient;
    }
}

