/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core.util;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcHttpClientConfig;
import org.apache.xmlrpc.client.XmlRpcHttpTransport;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.client.XmlRpcTransport;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.util.HttpUtil;
import org.apache.xmlrpc.util.XmlRpcIOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.SslCertificateException;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.trac.core.util.HttpMethodInterceptor;
import org.eclipse.mylyn.internal.trac.core.util.TracXmlRpcClientRequest;
import org.xml.sax.SAXException;

public class TracHttpClientTransportFactory
implements XmlRpcTransportFactory {
    private final XmlRpcClient xmlRpcClient;
    private AbstractWebLocation location;
    private final HttpClient httpClient;
    private HttpMethodInterceptor interceptor;

    public TracHttpClientTransportFactory(XmlRpcClient xmlRpcClient, HttpClient httpClient) {
        this.xmlRpcClient = xmlRpcClient;
        this.httpClient = httpClient;
    }

    public AbstractWebLocation getLocation() {
        return this.location;
    }

    public XmlRpcTransport getTransport() {
        return new TracHttpClientTransport(this.xmlRpcClient, this.httpClient, this.location, this.interceptor);
    }

    public void setLocation(AbstractWebLocation location) {
        this.location = location;
    }

    public HttpMethodInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(HttpMethodInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public static class TracHttpClientTransport
    extends XmlRpcHttpTransport {
        private final HttpClient httpClient;
        private final AbstractWebLocation location;
        private PostMethod method;
        private int contentLength = -1;
        private XmlRpcHttpClientConfig config;
        private IProgressMonitor monitor;
        private HostConfiguration hostConfiguration;
        private final HttpMethodInterceptor interceptor;

        public TracHttpClientTransport(XmlRpcClient client, HttpClient httpClient, AbstractWebLocation location, HttpMethodInterceptor interceptor) {
            super(client, "");
            this.httpClient = httpClient;
            this.location = location;
            this.interceptor = interceptor;
        }

        protected void close() throws XmlRpcClientException {
            this.method.releaseConnection();
        }

        public int getContentLength() {
            return this.contentLength;
        }

        protected InputStream getInputStream() throws XmlRpcException {
            int responseCode = this.method.getStatusCode();
            if (responseCode != 200) {
                TracHttpException e = new TracHttpException(responseCode);
                if (responseCode == 401) {
                    e.setAuthScheme(this.method.getHostAuthState().getAuthScheme());
                }
                throw e;
            }
            try {
                return this.method.getResponseBodyAsStream();
            }
            catch (HttpException e) {
                throw new XmlRpcClientException("Error in HTTP transport: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new XmlRpcClientException("I/O error in server communication: " + e.getMessage(), (Throwable)e);
            }
        }

        protected String getUserAgent() {
            return WebUtil.getUserAgent((String)"");
        }

        protected void initHttpHeaders(XmlRpcRequest request) throws XmlRpcClientException {
            this.config = (XmlRpcHttpClientConfig)request.getConfig();
            if (request instanceof TracXmlRpcClientRequest) {
                TracXmlRpcClientRequest tracRequest = (TracXmlRpcClientRequest)request;
                this.monitor = tracRequest.getProgressMonitor();
            } else {
                this.monitor = null;
            }
            String url = this.config.getServerURL().toString();
            this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)this.monitor);
            this.method = new PostMethod(WebUtil.getRequestPath((String)url));
            super.initHttpHeaders(request);
            if (this.config.getConnectionTimeout() != 0) {
                this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(this.config.getConnectionTimeout());
            }
            if (this.config.getReplyTimeout() != 0) {
                this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(this.config.getConnectionTimeout());
            }
            this.method.getParams().setVersion(HttpVersion.HTTP_1_1);
            if (this.interceptor != null) {
                this.interceptor.processRequest((HttpMethod)this.method);
            }
        }

        protected boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig config) {
            Header header = this.method.getResponseHeader("Content-Encoding");
            return header != null && HttpUtil.isUsingGzipEncoding((String)header.getValue());
        }

        protected void setContentLength(int contentLength) {
            this.contentLength = contentLength;
        }

        protected void setCredentials(XmlRpcHttpClientConfig config) throws XmlRpcClientException {
        }

        protected void setRequestHeader(String header, String value) {
            this.method.setRequestHeader(new Header(header, value));
        }

        protected void writeRequest(final XmlRpcStreamTransport.ReqWriter writer) throws XmlRpcException {
            this.method.setRequestEntity(new RequestEntity(){

                public long getContentLength() {
                    return TracHttpClientTransport.this.getContentLength();
                }

                public String getContentType() {
                    return "text/xml";
                }

                public boolean isRepeatable() {
                    return this.getContentLength() != -1L;
                }

                public void writeRequest(OutputStream pOut) throws IOException {
                    try {
                        FilterOutputStream ostream = TracHttpClientTransport.this.isUsingByteArrayOutput(TracHttpClientTransport.this.config) ? new FilterOutputStream(pOut){

                            @Override
                            public void close() throws IOException {
                                this.flush();
                            }
                        } : new BufferedOutputStream(pOut){

                            @Override
                            public void close() throws IOException {
                                this.flush();
                            }
                        };
                        writer.write((OutputStream)ostream);
                    }
                    catch (XmlRpcException e) {
                        throw new XmlRpcIOException((Throwable)e);
                    }
                    catch (SAXException e) {
                        throw new XmlRpcIOException((Throwable)e);
                    }
                }
            });
            try {
                WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)this.method, (IProgressMonitor)this.monitor);
                if (this.interceptor != null) {
                    this.interceptor.processResponse((HttpMethod)this.method);
                }
            }
            catch (XmlRpcIOException e) {
                Throwable t = e.getLinkedException();
                if (t instanceof XmlRpcException) {
                    throw (XmlRpcException)t;
                }
                throw new XmlRpcException("Unexpected exception: " + t.getMessage(), t);
            }
            catch (SslCertificateException sslCertificateException) {
                throw new TracHttpException(499);
            }
            catch (IOException e) {
                throw new XmlRpcException("I/O error while communicating with HTTP server: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class TracHttpException
    extends XmlRpcException {
        private static final long serialVersionUID = 9032521978140685830L;
        private AuthScheme authScheme;

        public TracHttpException(int responseCode) {
            super(responseCode, "HTTP Error " + responseCode);
        }

        public AuthScheme getAuthScheme() {
            return this.authScheme;
        }

        public void setAuthScheme(AuthScheme authScheme) {
            this.authScheme = authScheme;
        }
    }
}

