/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.internal.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.mylyn.reviews.core.model.IApprovalType;
import org.eclipse.mylyn.reviews.core.model.IChange;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IDated;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IRequirementEntry;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.model.IReviewerEntry;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.core.model.ReviewStatus;
import org.eclipse.mylyn.reviews.internal.core.model.CommentContainer;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewRequirementsMap;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsPackage;
import org.eclipse.mylyn.reviews.internal.core.model.UserApprovalsMap;

public class Review
extends CommentContainer
implements IReview {
    protected static final Date CREATION_DATE_EDEFAULT = null;
    protected Date creationDate = CREATION_DATE_EDEFAULT;
    protected static final Date MODIFICATION_DATE_EDEFAULT = null;
    protected Date modificationDate = MODIFICATION_DATE_EDEFAULT;
    protected static final String ID_EDEFAULT = null;
    protected String id = ID_EDEFAULT;
    protected static final String KEY_EDEFAULT = null;
    protected String key = KEY_EDEFAULT;
    protected static final String SUBJECT_EDEFAULT = null;
    protected String subject = SUBJECT_EDEFAULT;
    protected static final String MESSAGE_EDEFAULT = null;
    protected String message = MESSAGE_EDEFAULT;
    protected IUser owner;
    protected static final ReviewStatus STATE_EDEFAULT = ReviewStatus.NEW;
    protected ReviewStatus state = STATE_EDEFAULT;
    protected EList<IReviewItemSet> sets;
    protected EList<IChange> parents;
    protected EList<IChange> children;
    protected EMap<IUser, IReviewerEntry> reviewerApprovals;
    protected EMap<IApprovalType, IRequirementEntry> requirements;

    protected Review() {
    }

    @Override
    protected EClass eStaticClass() {
        return ReviewsPackage.Literals.REVIEW;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date newCreationDate) {
        Date oldCreationDate = this.creationDate;
        this.creationDate = newCreationDate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldCreationDate, (Object)this.creationDate));
        }
    }

    @Override
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public void setModificationDate(Date newModificationDate) {
        Date oldModificationDate = this.modificationDate;
        this.modificationDate = newModificationDate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldModificationDate, (Object)this.modificationDate));
        }
    }

    @Override
    public List<IReviewItemSet> getSets() {
        if (this.sets == null) {
            this.sets = new EObjectContainmentWithInverseEList.Resolving(IReviewItemSet.class, (InternalEObject)this, 12, 14);
        }
        return this.sets;
    }

    @Override
    public IRepository getRepository() {
        if (this.eContainerFeatureID() != 13) {
            return null;
        }
        return (IRepository)this.eContainer();
    }

    public IRepository basicGetRepository() {
        if (this.eContainerFeatureID() != 13) {
            return null;
        }
        return (IRepository)this.eInternalContainer();
    }

    public NotificationChain basicSetRepository(IRepository newRepository, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newRepository, 13, msgs);
        return msgs;
    }

    @Override
    public void setRepository(IRepository newRepository) {
        if (newRepository != this.eInternalContainer() || this.eContainerFeatureID() != 13 && newRepository != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newRepository)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newRepository != null) {
                msgs = ((InternalEObject)newRepository).eInverseAdd((InternalEObject)this, 5, IRepository.class, msgs);
            }
            if ((msgs = this.basicSetRepository(newRepository, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)newRepository, (Object)newRepository));
        }
    }

    public Date getLastChangeDate() {
        if (this.getModificationDate() != null) {
            return this.getModificationDate();
        }
        return this.getCreationDate();
    }

    @Override
    public List<IComment> getAllComments() {
        ArrayList<IComment> all = new ArrayList<IComment>(this.getComments());
        for (IReviewItemSet set : this.getSets()) {
            all.addAll(set.getAllComments());
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)this, (EStructuralFeature)ReviewsPackage.Literals.COMMENT_CONTAINER__ALL_COMMENTS, all.size(), all.toArray());
    }

    @Override
    public ReviewStatus getState() {
        return this.state;
    }

    @Override
    public void setState(ReviewStatus newState) {
        ReviewStatus oldState = this.state;
        ReviewStatus reviewStatus = this.state = newState == null ? STATE_EDEFAULT : newState;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldState, (Object)this.state));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String newId) {
        String oldId = this.id;
        this.id = newId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldId, (Object)this.id));
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String newKey) {
        String oldKey = this.key;
        this.key = newKey;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldKey, (Object)this.key));
        }
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(String newSubject) {
        String oldSubject = this.subject;
        this.subject = newSubject;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldSubject, (Object)this.subject));
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String newMessage) {
        String oldMessage = this.message;
        this.message = newMessage;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldMessage, (Object)this.message));
        }
    }

    @Override
    public IUser getOwner() {
        if (this.owner != null && this.owner.eIsProxy()) {
            InternalEObject oldOwner = (InternalEObject)this.owner;
            this.owner = (IUser)this.eResolveProxy(oldOwner);
            if (this.owner != oldOwner && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 10, (Object)oldOwner, (Object)this.owner));
            }
        }
        return this.owner;
    }

    public IUser basicGetOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(IUser newOwner) {
        IUser oldOwner = this.owner;
        this.owner = newOwner;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldOwner, (Object)this.owner));
        }
    }

    @Override
    public List<IChange> getParents() {
        if (this.parents == null) {
            this.parents = new EObjectContainmentEList.Resolving(IChange.class, (InternalEObject)this, 14);
        }
        return this.parents;
    }

    @Override
    public List<IChange> getChildren() {
        if (this.children == null) {
            this.children = new EObjectContainmentEList.Resolving(IChange.class, (InternalEObject)this, 15);
        }
        return this.children;
    }

    @Override
    public Map<IUser, IReviewerEntry> getReviewerApprovals() {
        if (this.reviewerApprovals == null) {
            this.reviewerApprovals = new EcoreEMap(ReviewsPackage.Literals.USER_APPROVALS_MAP, UserApprovalsMap.class, (InternalEObject)this, 16);
        }
        return this.reviewerApprovals.map();
    }

    @Override
    public Map<IApprovalType, IRequirementEntry> getRequirements() {
        if (this.requirements == null) {
            this.requirements = new EcoreEMap(ReviewsPackage.Literals.REVIEW_REQUIREMENTS_MAP, ReviewRequirementsMap.class, (InternalEObject)this, 17);
        }
        return this.requirements.map();
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 12: {
                return ((InternalEList)this.getSets()).basicAdd((Object)otherEnd, msgs);
            }
            case 13: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetRepository((IRepository)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 12: {
                return ((InternalEList)this.getSets()).basicRemove((Object)otherEnd, msgs);
            }
            case 13: {
                return this.basicSetRepository(null, msgs);
            }
            case 14: {
                return ((InternalEList)this.getParents()).basicRemove((Object)otherEnd, msgs);
            }
            case 15: {
                return ((InternalEList)this.getChildren()).basicRemove((Object)otherEnd, msgs);
            }
            case 16: {
                return ((InternalEList)((EMap.InternalMapView)this.getReviewerApprovals()).eMap()).basicRemove((Object)otherEnd, msgs);
            }
            case 17: {
                return ((InternalEList)((EMap.InternalMapView)this.getRequirements()).eMap()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 13: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 5, IRepository.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 4: {
                return this.getCreationDate();
            }
            case 5: {
                return this.getModificationDate();
            }
            case 6: {
                return this.getId();
            }
            case 7: {
                return this.getKey();
            }
            case 8: {
                return this.getSubject();
            }
            case 9: {
                return this.getMessage();
            }
            case 10: {
                if (resolve) {
                    return this.getOwner();
                }
                return this.basicGetOwner();
            }
            case 11: {
                return this.getState();
            }
            case 12: {
                return this.getSets();
            }
            case 13: {
                if (resolve) {
                    return this.getRepository();
                }
                return this.basicGetRepository();
            }
            case 14: {
                return this.getParents();
            }
            case 15: {
                return this.getChildren();
            }
            case 16: {
                if (coreType) {
                    return ((EMap.InternalMapView)this.getReviewerApprovals()).eMap();
                }
                return this.getReviewerApprovals();
            }
            case 17: {
                if (coreType) {
                    return ((EMap.InternalMapView)this.getRequirements()).eMap();
                }
                return this.getRequirements();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 4: {
                this.setCreationDate((Date)newValue);
                return;
            }
            case 5: {
                this.setModificationDate((Date)newValue);
                return;
            }
            case 6: {
                this.setId((String)newValue);
                return;
            }
            case 7: {
                this.setKey((String)newValue);
                return;
            }
            case 8: {
                this.setSubject((String)newValue);
                return;
            }
            case 9: {
                this.setMessage((String)newValue);
                return;
            }
            case 10: {
                this.setOwner((IUser)newValue);
                return;
            }
            case 11: {
                this.setState((ReviewStatus)newValue);
                return;
            }
            case 12: {
                this.getSets().clear();
                this.getSets().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.setRepository((IRepository)newValue);
                return;
            }
            case 14: {
                this.getParents().clear();
                this.getParents().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.getChildren().clear();
                this.getChildren().addAll((Collection)newValue);
                return;
            }
            case 16: {
                ((EStructuralFeature.Setting)((EMap.InternalMapView)this.getReviewerApprovals()).eMap()).set(newValue);
                return;
            }
            case 17: {
                ((EStructuralFeature.Setting)((EMap.InternalMapView)this.getRequirements()).eMap()).set(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 4: {
                this.setCreationDate(CREATION_DATE_EDEFAULT);
                return;
            }
            case 5: {
                this.setModificationDate(MODIFICATION_DATE_EDEFAULT);
                return;
            }
            case 6: {
                this.setId(ID_EDEFAULT);
                return;
            }
            case 7: {
                this.setKey(KEY_EDEFAULT);
                return;
            }
            case 8: {
                this.setSubject(SUBJECT_EDEFAULT);
                return;
            }
            case 9: {
                this.setMessage(MESSAGE_EDEFAULT);
                return;
            }
            case 10: {
                this.setOwner(null);
                return;
            }
            case 11: {
                this.setState(STATE_EDEFAULT);
                return;
            }
            case 12: {
                this.getSets().clear();
                return;
            }
            case 13: {
                this.setRepository(null);
                return;
            }
            case 14: {
                this.getParents().clear();
                return;
            }
            case 15: {
                this.getChildren().clear();
                return;
            }
            case 16: {
                this.getReviewerApprovals().clear();
                return;
            }
            case 17: {
                this.getRequirements().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 4: {
                return CREATION_DATE_EDEFAULT == null ? this.creationDate != null : !CREATION_DATE_EDEFAULT.equals(this.creationDate);
            }
            case 5: {
                return MODIFICATION_DATE_EDEFAULT == null ? this.modificationDate != null : !MODIFICATION_DATE_EDEFAULT.equals(this.modificationDate);
            }
            case 6: {
                return ID_EDEFAULT == null ? this.id != null : !ID_EDEFAULT.equals(this.id);
            }
            case 7: {
                return KEY_EDEFAULT == null ? this.key != null : !KEY_EDEFAULT.equals(this.key);
            }
            case 8: {
                return SUBJECT_EDEFAULT == null ? this.subject != null : !SUBJECT_EDEFAULT.equals(this.subject);
            }
            case 9: {
                return MESSAGE_EDEFAULT == null ? this.message != null : !MESSAGE_EDEFAULT.equals(this.message);
            }
            case 10: {
                return this.owner != null;
            }
            case 11: {
                return this.state != STATE_EDEFAULT;
            }
            case 12: {
                return this.sets != null && !this.sets.isEmpty();
            }
            case 13: {
                return this.basicGetRepository() != null;
            }
            case 14: {
                return this.parents != null && !this.parents.isEmpty();
            }
            case 15: {
                return this.children != null && !this.children.isEmpty();
            }
            case 16: {
                return this.reviewerApprovals != null && !this.reviewerApprovals.isEmpty();
            }
            case 17: {
                return this.requirements != null && !this.requirements.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IDated.class) {
            switch (derivedFeatureID) {
                case 4: {
                    return 0;
                }
                case 5: {
                    return 1;
                }
            }
            return -1;
        }
        if (baseClass == IChange.class) {
            switch (derivedFeatureID) {
                case 6: {
                    return 2;
                }
                case 7: {
                    return 3;
                }
                case 8: {
                    return 4;
                }
                case 9: {
                    return 5;
                }
                case 10: {
                    return 6;
                }
                case 11: {
                    return 7;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IDated.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 4;
                }
                case 1: {
                    return 5;
                }
            }
            return -1;
        }
        if (baseClass == IChange.class) {
            switch (baseFeatureID) {
                case 2: {
                    return 6;
                }
                case 3: {
                    return 7;
                }
                case 4: {
                    return 8;
                }
                case 5: {
                    return 9;
                }
                case 6: {
                    return 10;
                }
                case 7: {
                    return 11;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (creationDate: ");
        result.append(this.creationDate);
        result.append(", modificationDate: ");
        result.append(this.modificationDate);
        result.append(", id: ");
        result.append(this.id);
        result.append(", key: ");
        result.append(this.key);
        result.append(", subject: ");
        result.append(this.subject);
        result.append(", message: ");
        result.append(this.message);
        result.append(", state: ");
        result.append(this.state);
        result.append(')');
        return result.toString();
    }
}

