/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.internal.core;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.reviews.internal.core.BuildResult;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class TaskBuildStatusMapper {
    public static final String BUILD_RESULT_TYPE = "BuildResult";
    public static final String JOB_NAME_ATTRIBUTE_KEY = "JOB";
    public static final String BUILD_NUMBER_ATTRIBUTE_KEY = "NUMBER";
    public static final String STATUS_ATTRIBUTE_KEY = "STATUS";
    public static final String URL_ATTRIBUTE_KEY = "URL";
    public static final String ATTR_ID_BUILD_RESULT = "BUILD_RESULT-";
    public static final String ATTR_TYPE_PATCH_SET = "PATCH_SET-";
    private final Iterable<BuildResult> buildResults;

    public TaskBuildStatusMapper(Collection<BuildResult> buildResults) {
        this.buildResults = buildResults;
    }

    public void applyTo(TaskAttribute taskAttribute) {
        Assert.isNotNull((Object)taskAttribute);
        TaskData taskData = taskAttribute.getTaskData();
        TaskAttributeMapper mapper = taskData.getAttributeMapper();
        taskAttribute.getMetaData().defaults().setType(BUILD_RESULT_TYPE);
        Function<BuildResult, String> groupFunction = new Function<BuildResult, String>(){

            public String apply(BuildResult source) {
                return source.getJobName();
            }
        };
        ImmutableListMultimap buildsByJobName = Multimaps.index(this.buildResults, (Function)groupFunction);
        int i = 0;
        for (Map.Entry jobEntry : buildsByJobName.asMap().entrySet()) {
            TaskAttribute child;
            BuildResult result = Collections.max((Collection)jobEntry.getValue(), new Comparator<BuildResult>(){

                @Override
                public int compare(BuildResult o1, BuildResult o2) {
                    return Integer.compare(o1.getBuildNumber(), o2.getBuildNumber());
                }
            });
            TaskAttribute buildAttribute = taskAttribute.createAttribute(ATTR_ID_BUILD_RESULT + i);
            buildAttribute.getMetaData().defaults().setType(BUILD_RESULT_TYPE);
            if (result.getBuildUrl() != null) {
                child = buildAttribute.createAttribute(URL_ATTRIBUTE_KEY);
                child.getMetaData().defaults().setType(BUILD_RESULT_TYPE);
                mapper.setValue(child, result.getBuildUrl());
            }
            if (result.getBuildStatus() != null) {
                child = buildAttribute.createAttribute(STATUS_ATTRIBUTE_KEY);
                child.getMetaData().defaults().setType(BUILD_RESULT_TYPE);
                mapper.setValue(child, result.getBuildStatus().toString());
            }
            if (result.getBuildNumber() > -1) {
                child = buildAttribute.createAttribute(BUILD_NUMBER_ATTRIBUTE_KEY);
                child.getMetaData().defaults().setType(BUILD_RESULT_TYPE);
                mapper.setValue(child, String.valueOf(result.getBuildNumber()));
            }
            if (result.getJobName() != null) {
                child = buildAttribute.createAttribute(JOB_NAME_ATTRIBUTE_KEY);
                child.getMetaData().defaults().setType(BUILD_RESULT_TYPE);
                mapper.setValue(child, result.getJobName());
            }
            ++i;
        }
    }
}

