/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.annotations;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotation;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotationHoverInput;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentInformationControlCreator;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentPopupDialog;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class CommentInformationControl
extends DefaultInformationControl
implements IInformationControlExtension2 {
    private Object input;
    private CommentPopupDialog commentPopupDialog;
    private final CommentInformationControlCreator informationControlCreator;
    private Job markAsReadJob;

    public CommentInformationControl(Shell parent, CommentInformationControlCreator crucibleInformationControlCreator) {
        super(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
        this.informationControlCreator = crucibleInformationControlCreator;
        this.commentPopupDialog = new CommentPopupDialog(parent, 540672, null, null, false);
        this.commentPopupDialog.create();
        this.commentPopupDialog.setInformationControl(this);
    }

    public InformationPresenter getInformationPresenter() {
        return new InformationPresenter((IInformationControlCreator)this.informationControlCreator);
    }

    public void setInformation(String content) {
        this.input = content;
        this.commentPopupDialog.setInput(this.input);
        super.setInformation(content);
    }

    public void setInput(Object input) {
        this.input = input;
        this.commentPopupDialog.setInput(input);
    }

    public boolean hasContents() {
        return this.input != null || super.hasContents();
    }

    private void runMarkCommentAsReadJob(CommentAnnotationHoverInput input) {
        List<CommentAnnotation> annotations = input.getAnnotations();
        if (annotations == null || annotations.size() == 0) {
            return;
        }
        HashSet<? extends IComment> comments = new HashSet<IComment>();
        for (CommentAnnotation annotation : annotations) {
            comments.addAll(this.getUnreadComments(annotation.getComment()));
        }
        comments.size();
    }

    private Collection<? extends IComment> getUnreadComments(IComment comment) {
        HashSet result = new HashSet();
        return result;
    }

    private void cancelMarkCommentAsReadJob() {
        if (this.markAsReadJob != null) {
            this.markAsReadJob.cancel();
            this.markAsReadJob = null;
        }
    }

    public void setVisible(boolean visible) {
        this.cancelMarkCommentAsReadJob();
        if (this.input instanceof String) {
            this.setInformation((String)this.input);
            super.setVisible(visible);
        } else if (this.input instanceof CommentAnnotationHoverInput) {
            if (visible) {
                this.commentPopupDialog.open();
                this.runMarkCommentAsReadJob((CommentAnnotationHoverInput)this.input);
            } else {
                if (this.commentPopupDialog.hasEdits()) {
                    return;
                }
                this.commentPopupDialog.getShell().setVisible(false);
            }
        } else {
            super.setVisible(visible);
        }
    }

    public void dispose() {
        if (!this.commentPopupDialog.hasEdits()) {
            this.cancelMarkCommentAsReadJob();
            this.commentPopupDialog.dispose(false);
            this.commentPopupDialog = null;
        }
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.commentPopupDialog.setSize(width, height);
    }

    public void setLocation(Point location) {
        super.setLocation(location);
        this.commentPopupDialog.setLocation(location);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        super.setSizeConstraints(maxWidth, maxHeight);
        this.commentPopupDialog.setSizeConstraints(maxWidth, maxHeight);
    }

    public Rectangle computeTrim() {
        if (this.input instanceof String) {
            return super.computeTrim();
        }
        if (this.input instanceof CommentAnnotationHoverInput) {
            return this.commentPopupDialog.computeTrim();
        }
        return super.computeTrim();
    }

    public Rectangle getBounds() {
        if (this.input instanceof String) {
            return super.getBounds();
        }
        if (this.input instanceof CommentAnnotationHoverInput) {
            return this.commentPopupDialog.getBounds();
        }
        return super.getBounds();
    }

    public void addDisposeListener(DisposeListener listener) {
        super.addDisposeListener(listener);
        if (this.commentPopupDialog != null) {
            this.commentPopupDialog.addDisposeListener(listener);
        }
    }

    public void removeDisposeListener(DisposeListener listener) {
        super.removeDisposeListener(listener);
        this.commentPopupDialog.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        super.setForegroundColor(foreground);
    }

    public void setBackgroundColor(Color background) {
        super.setBackgroundColor(background);
    }

    public boolean isFocusControl() {
        if (this.input instanceof String) {
            return super.isFocusControl();
        }
        if (this.input instanceof CommentAnnotationHoverInput) {
            return this.commentPopupDialog.isFocusControl();
        }
        return super.isFocusControl();
    }

    public void setFocus() {
        if (this.input instanceof String) {
            super.setFocus();
        } else if (this.input instanceof CommentAnnotationHoverInput) {
            this.commentPopupDialog.setFocus();
        } else {
            super.setFocus();
        }
    }

    public void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
        this.commentPopupDialog.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        super.removeFocusListener(listener);
        this.commentPopupDialog.removeFocusListener(listener);
    }

    public Point computeSizeHint() {
        if (this.input instanceof String) {
            this.setInformation((String)this.input);
            return super.computeSizeHint();
        }
        if (this.input instanceof CommentAnnotationHoverInput) {
            return this.commentPopupDialog.computeSizeHint();
        }
        return super.computeSizeHint();
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new CommentInformationControlCreator();
    }
}

