/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.spi.editor;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.ui.compatibility.CommonColors;
import org.eclipse.mylyn.commons.workbench.forms.ScalingHyperlink;
import org.eclipse.mylyn.internal.reviews.ui.providers.ReviewsLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.reviews.core.model.ICommit;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfObserver;
import org.eclipse.mylyn.reviews.ui.spi.editor.AbstractReviewSection;
import org.eclipse.mylyn.reviews.ui.spi.editor.Messages;
import org.eclipse.mylyn.reviews.ui.spi.editor.ReviewSetSection;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Section;

public class ReviewSetContentSection {
    private static final int MAXIMUM_ITEMS_SHOWN = 30;
    private final ReviewSetSection parentSection;
    private final IReviewItemSet set;
    private final Section section;
    private TableViewer viewer;
    private final RemoteEmfObserver<IReviewItemSet, List<IFileItem>, String, Long> itemListObserver = new RemoteEmfObserver<IReviewItemSet, List<IFileItem>, String, Long>(){

        public void updated(boolean modified) {
            ReviewSetContentSection.this.createItemSetTable();
            if (modified) {
                ReviewSetContentSection.this.updateItemSetTable();
            }
            ReviewSetContentSection.this.updateMessage();
            ReviewSetContentSection.this.createButtons();
        }

        public void updating() {
            ReviewSetContentSection.this.updateMessage();
        }
    };
    private Composite tableContainer;
    private Composite actionContainer;
    private final RemoteEmfObserver<IRepository, IReview, String, Date> reviewObserver;
    private final AbstractTaskEditorPage page;

    public ReviewSetContentSection(ReviewSetSection parentSection, final IReviewItemSet set, AbstractTaskEditorPage page) {
        this.parentSection = parentSection;
        this.set = set;
        this.page = page;
        int style = 8210;
        this.section = parentSection.getToolkit().createSection(parentSection.getComposite(), style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.section);
        this.section.setText(set.getName());
        this.section.setTitleBarForeground(parentSection.getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE"));
        parentSection.addTextClient(parentSection.getToolkit(), this.section, "", false);
        final RemoteEmfConsumer itemSetConsumer = this.getParentSection().getReviewEditorPage().getFactoryProvider().getReviewItemSetContentFactory().getConsumerForLocalKey((EObject)set, (Object)set.getId());
        this.itemListObserver.setConsumer(itemSetConsumer);
        final RemoteEmfConsumer reviewConsumer = this.getParentSection().getReviewEditorPage().getFactoryProvider().getReviewFactory().getConsumerForModel((EObject)set.getReview().getRepository(), (Object)set.getReview());
        this.reviewObserver = new RemoteEmfObserver<IRepository, IReview, String, Date>(){

            public void updated(boolean modified) {
                if (reviewConsumer.getRemoteObject() != null && ReviewSetContentSection.this.section.isExpanded() && modified) {
                    itemSetConsumer.retrieve(false);
                    ReviewSetContentSection.this.updateMessage();
                    ReviewSetContentSection.this.createButtons();
                }
            }
        };
        reviewConsumer.addObserver(this.reviewObserver);
        this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (e.getState()) {
                    if (set.getItems().isEmpty()) {
                        itemSetConsumer.retrieve(false);
                    }
                    ReviewSetContentSection.this.updateMessage();
                    ReviewSetContentSection.this.createButtons();
                }
            }
        });
        this.createMainSection();
        this.createItemSetTable();
        this.updateMessage();
    }

    public void updateMessage() {
        String message;
        if (this.section.isDisposed()) {
            return;
        }
        if (this.itemListObserver.getConsumer().getStatus().isOK()) {
            String time = DateFormat.getDateTimeInstance().format(this.set.getCreationDate());
            int numComments = this.set.getAllComments().size();
            message = numComments > 0 ? NLS.bind((String)Messages.ReviewSetContentSection_X_comma_Y_Comments, (Object)time, (Object)numComments) : time;
            if (this.itemListObserver != null && this.itemListObserver.getConsumer().isRetrieving()) {
                message = String.valueOf(message) + " " + Messages.Reviews_RetrievingContents;
            }
        } else {
            message = NLS.bind((String)Messages.Reviews_UpdateFailure_X, (Object)this.itemListObserver.getConsumer().getStatus().getMessage());
        }
        AbstractReviewSection.appendMessage(this.getSection(), message);
    }

    void createMainSection() {
        Composite composite = this.parentSection.getToolkit().createComposite((Composite)this.section);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(60, LayoutConstants.getSpacing().y).applyTo(composite);
        Composite leftColumn = this.parentSection.getToolkit().createComposite(composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(leftColumn);
        Composite rightColumn = this.parentSection.getToolkit().createComposite(composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(rightColumn);
        this.section.setClient((Control)composite);
        FormColors colors = this.parentSection.getToolkit().getColors();
        this.createAuthorLabel(leftColumn, colors);
        this.createCommitterLabel(leftColumn, colors);
        this.createCommitLink(rightColumn, colors);
        this.createRefLabel(rightColumn, colors);
        this.createParentsLinks(composite, colors);
        TaskAttribute buildAttribute = this.parentSection.getTaskData().getRoot().getAttribute("PATCH_SET-" + this.set.getId());
        if (buildAttribute != null) {
            Composite buildComposite = this.parentSection.getToolkit().createComposite(composite);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(buildComposite);
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)buildComposite);
            AbstractAttributeEditor editor = this.parentSection.getTaskEditorPage().getAttributeEditorFactory().createEditor("BuildResult", buildAttribute);
            editor.createLabelControl(buildComposite, this.parentSection.getToolkit());
            editor.createControl(buildComposite, this.parentSection.getToolkit());
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(editor);
        }
        this.tableContainer = new Composite(composite, 0);
        this.tableContainer.setBackground(Display.getCurrent().getSystemColor(16));
        GridDataFactory.fillDefaults().span(4, 1).grab(true, true).applyTo((Control)this.tableContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.tableContainer);
        this.actionContainer = new Composite(composite, 0);
        GridDataFactory.fillDefaults().span(4, 1).grab(true, true).applyTo((Control)this.actionContainer);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(this.actionContainer);
        this.createButtons();
        this.parentSection.getTaskEditorPage().reflow();
    }

    private AbstractTaskEditorPage getTaskEditorPage() {
        return this.page;
    }

    private void createAuthorLabel(Composite composite, FormColors colors) {
        this.createTitleLabel(composite, colors, Messages.ReviewSetContentSection_Author, 0);
        Text authorText = new Text(composite, 8);
        if (this.set.getAddedBy() != null) {
            authorText.setText(this.set.getAddedBy().getDisplayName());
        } else {
            authorText.setText(Messages.ReviewSetContentSection_Unspecified);
        }
    }

    private void createCommitterLabel(Composite composite, FormColors colors) {
        Label committerLabel = new Label(composite, 0);
        committerLabel.setForeground(colors.getColor("org.eclipse.ui.forms.TITLE"));
        committerLabel.setText(Messages.ReviewSetContentSection_Committer);
        Text committerText = new Text(composite, 8);
        if (this.set.getCommittedBy() != null) {
            committerText.setText(this.set.getCommittedBy().getDisplayName());
        } else {
            committerText.setText(Messages.ReviewSetContentSection_Unspecified);
        }
    }

    private void createCommitLink(Composite composite, FormColors colors) {
        Label commitLabel = new Label(composite, 0);
        commitLabel.setForeground(colors.getColor("org.eclipse.ui.forms.TITLE"));
        commitLabel.setText(Messages.ReviewSetContentSection_Commit);
        ScalingHyperlink commitLink = new ScalingHyperlink(composite, 8);
        commitLink.setText(this.set.getRevision());
        commitLink.setForeground(CommonColors.HYPERLINK_WIDGET);
        commitLink.registerMouseTrackListener();
        commitLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                ReviewSetContentSection.this.getParentSection().getUiFactoryProvider().getOpenCommitFactory(ReviewSetContentSection.this.getParentSection(), ReviewSetContentSection.this.set).execute();
            }
        });
    }

    private void createRefLabel(Composite composite, FormColors colors) {
        Label refLabel = new Label(composite, 0);
        refLabel.setForeground(colors.getColor("org.eclipse.ui.forms.TITLE"));
        refLabel.setText(Messages.ReviewSetContentSection_Ref);
        Text refText = new Text(composite, 8);
        refText.setText(this.set.getReference());
    }

    private void createParentsLinks(Composite composite, FormColors colors) {
        if (this.set.getParentCommits().isEmpty()) {
            return;
        }
        Composite parentsComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(parentsComposite);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)parentsComposite);
        Label parentsLabel = new Label(parentsComposite, 0);
        parentsLabel.setForeground(colors.getColor("org.eclipse.ui.forms.TITLE"));
        parentsLabel.setText(Messages.ReviewSetContentSection_Parents);
        ArrayList<String> parentCommitIds = new ArrayList<String>();
        for (ICommit commit : this.set.getParentCommits()) {
            parentCommitIds.add(commit.getId());
        }
        ScalingHyperlink parentOne = new ScalingHyperlink(parentsComposite, 8);
        GridDataFactory.fillDefaults().indent(13, 0).applyTo((Control)parentOne);
        if (parentCommitIds.size() > 0) {
            this.addParentCommitHyperlink(parentOne, (String)parentCommitIds.get(0));
        }
        if (parentCommitIds.size() == 2 && parentCommitIds.get(1) != null) {
            ScalingHyperlink parentTwo = new ScalingHyperlink(parentsComposite, 8);
            this.addParentCommitHyperlink(parentTwo, (String)parentCommitIds.get(1));
        }
    }

    private void addParentCommitHyperlink(ScalingHyperlink commit, final String commitId) {
        commit.setText(commitId);
        commit.setForeground(CommonColors.HYPERLINK_WIDGET);
        commit.registerMouseTrackListener();
        commit.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                ReviewSetContentSection.this.getParentSection().getUiFactoryProvider().getOpenParentCommitFactory(ReviewSetContentSection.this.getParentSection(), ReviewSetContentSection.this.set, commitId).execute();
            }
        });
    }

    private Label createTitleLabel(Composite composite, FormColors colors, String text, int style) {
        Label titleLabel = new Label(composite, style);
        titleLabel.setForeground(colors.getColor("org.eclipse.ui.forms.TITLE"));
        titleLabel.setText(text);
        return titleLabel;
    }

    public void createItemSetTable() {
        if (this.viewer == null && !this.set.getItems().isEmpty()) {
            boolean fixedViewerSize = this.set.getItems().size() > 30;
            int heightHint = fixedViewerSize ? 300 : -1;
            int style = 268437508;
            style = fixedViewerSize ? (style |= 0x200) : (style |= 0x10);
            this.viewer = new TableViewer(this.tableContainer, style);
            GridDataFactory.fillDefaults().span(2, 1).grab(true, true).hint(500, heightHint).applyTo(this.viewer.getControl());
            this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    return this.getReviewItems(inputElement).toArray();
                }

                private List<IFileItem> getReviewItems(Object inputElement) {
                    if (inputElement instanceof IReviewItemSet) {
                        return ((IReviewItemSet)inputElement).getItems();
                    }
                    return Collections.emptyList();
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
            DelegatingStyledCellLabelProvider styledLabelProvider = new DelegatingStyledCellLabelProvider(new ReviewsLabelProvider.Simple()){

                public String getToolTipText(Object element) {
                    return ReviewsLabelProvider.ITEMS_COLUMN.getToolTipText(element);
                }
            };
            this.viewer.setLabelProvider((IBaseLabelProvider)styledLabelProvider);
            this.viewer.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    IFileItem item = (IFileItem)selection.getFirstElement();
                    if (item != null) {
                        ReviewSetContentSection.this.getParentSection().getUiFactoryProvider().getOpenFileFactory(ReviewSetContentSection.this.getParentSection(), ReviewSetContentSection.this.set, item).execute();
                    }
                }
            });
            EditorUtil.addScrollListener((Scrollable)this.viewer.getTable());
            this.viewer.setInput((Object)this.set);
            this.getParentSection().getTaskEditorPage().reflow();
        }
    }

    public void updateItemSetTable() {
        if (this.set.getItems().size() > 0 && this.viewer != null) {
            this.viewer.setInput((Object)this.set);
        }
    }

    public void createButtons() {
        if (!this.actionContainer.isDisposed()) {
            Control[] controlArray = this.actionContainer.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control oldActionControl = controlArray[n2];
                oldActionControl.dispose();
                ++n2;
            }
            this.getParentSection().getUiFactoryProvider().createControls(this.getParentSection(), this.actionContainer, this.getParentSection().getToolkit(), this.set);
            this.actionContainer.layout();
            this.getParentSection().getTaskEditorPage().reflow();
        }
    }

    public Section getSection() {
        return this.section;
    }

    public ReviewSetSection getParentSection() {
        return this.parentSection;
    }

    public void dispose() {
        this.itemListObserver.dispose();
        this.reviewObserver.dispose();
        this.section.dispose();
    }
}

