/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class HeadingBlock
extends Block {
    private static final Pattern pattern = Pattern.compile("\\s*(\\={1,6})\\s*(.+?)\\s*\\1\\s*");
    private int blockLineCount = 0;
    private Matcher matcher;

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        if (lineOffset == 0) {
            this.matcher = pattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount > 0) {
            throw new IllegalStateException();
        }
        ++this.blockLineCount;
        int level = this.matcher.group(1).length();
        String text = this.matcher.group(2);
        Attributes attributes = new Attributes();
        if (attributes.getId() == null) {
            String textForId = text.replaceAll("</?[a-zA-Z0-9]+.*?>", "");
            attributes.setId(this.state.getIdGenerator().newId("h" + level, textForId));
        }
        this.builder.beginHeading(level, attributes);
        offset = this.matcher.start(2);
        line = text;
        this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.state, offset, line, 0);
        this.builder.endHeading();
        this.setClosed(true);
        return -1;
    }
}

