/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.index.tests.ui;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.mylyn.commons.core.DelegatingProgressMonitor;
import org.eclipse.mylyn.commons.core.IDelegatingProgressMonitor;
import org.eclipse.mylyn.internal.tasks.index.core.TaskListIndex;
import org.eclipse.mylyn.internal.tasks.index.tests.AbstractTaskListIndexTest;
import org.eclipse.mylyn.internal.tasks.index.ui.AbstractIndexReference;
import org.eclipse.mylyn.internal.tasks.index.ui.ContentProposalProvider;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ContentProposalProviderTest
extends AbstractTaskListIndexTest {
    private ContentProposalProvider proposalProvider;

    @Override
    @Before
    public void setup() throws IOException {
        super.setup();
        this.setupIndex();
        this.proposalProvider = new ContentProposalProvider(this.context.getTaskList(), new AbstractIndexReference(){

            public TaskListIndex index() {
                return ContentProposalProviderTest.this.index;
            }
        });
    }

    @Test
    public void testComputeProposalContentState_SimpleProposal() {
        ContentProposalProvider.ProposalContentState state = this.proposalProvider.computeProposalContentState("one tw", 6);
        Assert.assertNotNull((Object)state);
        Assert.assertEquals((Object)"one ", (Object)state.beforePrefixContent);
        Assert.assertEquals((Object)"", (Object)state.fieldPrefix);
        Assert.assertEquals((Object)"tw", (Object)state.prefix);
        Assert.assertEquals((Object)"", (Object)state.suffix);
    }

    @Test
    public void testComputeProposalContentState_FieldValueProposal() {
        String content = "one person:";
        ContentProposalProvider.ProposalContentState state = this.proposalProvider.computeProposalContentState(content, content.length());
        Assert.assertNotNull((Object)state);
        Assert.assertEquals((Object)"one person:", (Object)state.beforePrefixContent);
        Assert.assertEquals((Object)"person", (Object)state.fieldPrefix);
        Assert.assertEquals((Object)"", (Object)state.prefix);
        Assert.assertEquals((Object)"", (Object)state.suffix);
    }

    @Test
    public void testComputeProposalContentState_FieldValueProposalMidRange() {
        String content = "one person:";
        String content2 = " foo";
        ContentProposalProvider.ProposalContentState state = this.proposalProvider.computeProposalContentState(String.valueOf(content) + content2, content.length());
        Assert.assertNotNull((Object)state);
        Assert.assertEquals((Object)"one person:", (Object)state.beforePrefixContent);
        Assert.assertEquals((Object)"person", (Object)state.fieldPrefix);
        Assert.assertEquals((Object)"", (Object)state.prefix);
        Assert.assertEquals((Object)" foo", (Object)state.suffix);
    }

    @Test
    public void testComputeProposalContentState_SimpleProposalMidRange() {
        String content = "one tw";
        String content2 = " foo";
        ContentProposalProvider.ProposalContentState state = this.proposalProvider.computeProposalContentState(String.valueOf(content) + content2, content.length());
        Assert.assertNotNull((Object)state);
        Assert.assertEquals((Object)"one ", (Object)state.beforePrefixContent);
        Assert.assertEquals((Object)"", (Object)state.fieldPrefix);
        Assert.assertEquals((Object)"tw", (Object)state.prefix);
        Assert.assertEquals((Object)" foo", (Object)state.suffix);
    }

    @Test
    public void testGetProposals_FieldName() {
        IContentProposal[] proposals = this.proposalProvider.getProposals("per", 3);
        Assert.assertNotNull((Object)proposals);
        Assert.assertEquals((long)1L, (long)proposals.length);
        Assert.assertEquals((Object)"person:", (Object)proposals[0].getContent());
        Assert.assertEquals((long)7L, (long)proposals[0].getCursorPosition());
    }

    @Test
    public void testGetProposals_PersonSuggest() throws CoreException {
        ITask task = this.context.createRepositoryTask();
        String owner = task.getOwner();
        Assert.assertNotNull((Object)owner);
        Assert.assertTrue((owner.trim().length() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)owner.trim(), (Object)owner);
        IContentProposal[] proposals = this.proposalProvider.getProposals("person:", 7);
        Assert.assertNotNull((Object)proposals);
        Assert.assertEquals((long)1L, (long)proposals.length);
        String expectedValue = "person:" + owner;
        Assert.assertEquals((Object)expectedValue, (Object)proposals[0].getContent());
        Assert.assertEquals((long)expectedValue.length(), (long)proposals[0].getCursorPosition());
        Assert.assertEquals((Object)owner, (Object)proposals[0].getLabel());
    }

    @Test
    public void testGetProposals_PersonSuggestWithSpace() throws CoreException, InterruptedException {
        ITask task = this.context.createRepositoryTask();
        TaskData taskData = this.context.getDataManager().getTaskData(task);
        Assert.assertNotNull((Object)taskData);
        Assert.assertNotNull((Object)taskData.getRepositoryUrl());
        taskData.getRoot().getMappedAttribute("task.common.user.assigned").setValue("Jane Doe");
        this.context.getDataManager().putSubmittedTaskData(task, taskData, (IDelegatingProgressMonitor)new DelegatingProgressMonitor());
        this.context.getTaskList().notifyElementsChanged(Collections.singleton(task));
        this.index.waitUntilIdle();
        String owner = task.getOwner();
        Assert.assertNotNull((Object)owner);
        Assert.assertTrue((owner.trim().length() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)owner.trim(), (Object)owner);
        Assert.assertEquals((Object)"Jane Doe", (Object)owner);
        IContentProposal[] proposals = this.proposalProvider.getProposals("person:", 7);
        Assert.assertNotNull((Object)proposals);
        Assert.assertEquals((long)1L, (long)proposals.length);
        String expectedValue = "person:\"" + owner + "\"";
        Assert.assertEquals((Object)expectedValue, (Object)proposals[0].getContent());
        Assert.assertEquals((long)expectedValue.length(), (long)proposals[0].getCursorPosition());
        Assert.assertEquals((Object)owner, (Object)proposals[0].getLabel());
    }

    @Test
    public void testGetProposals_PersonSuggest_MidStream() throws CoreException {
        ITask task = this.context.createRepositoryTask();
        String owner = task.getOwner();
        Assert.assertNotNull((Object)owner);
        Assert.assertTrue((owner.trim().length() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)owner.trim(), (Object)owner);
        String content2 = " after";
        IContentProposal[] proposals = this.proposalProvider.getProposals("person:" + content2, "person:".length());
        Assert.assertNotNull((Object)proposals);
        Assert.assertEquals((long)1L, (long)proposals.length);
        String expectedValue = "person:" + owner + content2;
        Assert.assertEquals((Object)expectedValue, (Object)proposals[0].getContent());
        Assert.assertEquals((long)("person:" + owner).length(), (long)proposals[0].getCursorPosition());
        Assert.assertEquals((Object)owner, (Object)proposals[0].getLabel());
    }
}

