/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.asciidoc.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.block.AsciiDocBlock;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;

public class PreformattedBlock
extends AsciiDocBlock {
    private static final Pattern startPattern = Pattern.compile("(?: {4}|\\t)((?: {4}|\\t)*)(.*)");

    public PreformattedBlock() {
        super(startPattern);
    }

    @Override
    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0) {
            return startPattern.matcher(line).matches();
        }
        return false;
    }

    @Override
    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }

    @Override
    protected void processBlockStart() {
        this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, new Attributes());
        this.processBlockContent(this.startDelimiter);
    }

    @Override
    protected void processBlockContent(String line) {
        Matcher matcher = startPattern.matcher(line);
        if (!matcher.matches()) {
            this.setClosed(true);
            return;
        }
        String indent = matcher.group(1);
        String content = matcher.group(2);
        if (indent != null) {
            this.builder.characters(indent);
        }
        this.builder.characters(content);
        this.builder.lineBreak();
    }

    @Override
    protected void processBlockEnd() {
    }
}

