/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.confluence.core.ConfluenceDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.tests.TestUtil;

public class ConfluenceDocumentBuilderTest
extends TestCase {
    private DocumentBuilder builder;
    private StringWriter out;

    protected void setUp() throws Exception {
        this.out = new StringWriter();
        this.builder = new ConfluenceDocumentBuilder((Writer)this.out);
        super.setUp();
    }

    public void testParagraph() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text\n\nmore text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"text  more text\n\n", (String)markup);
    }

    public void testParagraphWithCssClass() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes(null, "test", null, null));
        this.builder.characters("text\n\nmore text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"text  more text\n\n", (String)markup);
    }

    public void testParagraphWithCssStyle() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes(null, null, "x-test: foo;", null));
        this.builder.characters("text\n\nmore text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"text  more text\n\n", (String)markup);
    }

    public void testParagraphWithId() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes("123", null, null, null));
        this.builder.characters("text\n\nmore text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"text  more text\n\n", (String)markup);
    }

    public void testParagraphWithIdAndClass() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes("123", "test", null, null));
        this.builder.characters("text\n\nmore text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"text  more text\n\n", (String)markup);
    }

    public void testParagraphWithLink() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text\n\nmore text ");
        LinkAttributes attributes = new LinkAttributes();
        attributes.setHref("http://example.com/foo+bar/baz.gif");
        this.builder.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)attributes);
        this.builder.characters("baz");
        this.builder.endSpan();
        this.builder.characters(" test");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"text  more text [baz | http://example.com/foo+bar/baz.gif] test\n\n", (String)markup);
    }

    public void testBlockCode() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.CODE, new Attributes());
        this.builder.characters("text\n\nmore text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"{code}text\n\nmore text{code}\n\n\n", (String)markup);
    }

    public void testCodeBlockWithLineBreaks() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.CODE, new Attributes());
        this.builder.characters("line 1");
        this.builder.lineBreak();
        this.builder.characters("line 2");
        this.builder.lineBreak();
        this.builder.lineBreak();
        this.builder.characters("line 3");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"{code}line 1\nline 2\n\nline 3{code}\n\n\n", (String)markup);
    }

    public void testPreformattedBlockWithLineBreaks() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, new Attributes());
        this.builder.characters("line 1");
        this.builder.lineBreak();
        this.builder.characters("line 2");
        this.builder.lineBreak();
        this.builder.lineBreak();
        this.builder.characters("line 3");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"{noformat}line 1\nline 2\n\nline 3{noformat}\n\n", (String)markup);
    }

    public void testParagraphFollowingExtendedBlockCode() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.CODE, new Attributes());
        this.builder.characters("text\n\nmore text");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text2");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"{code}text\n\nmore text{code}\n\n\ntext\n\ntext2\n\n", (String)markup);
    }

    public void testHeading1() {
        this.builder.beginDocument();
        this.builder.beginHeading(1, new Attributes());
        this.builder.characters("text\n\nmore text");
        this.builder.endHeading();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"h1. text  more text\n\ntext\n\n", (String)markup);
    }

    public void testHeadingWithLineBreaks() {
        this.builder.beginDocument();
        this.builder.beginHeading(1, new Attributes());
        this.builder.characters("line 1 of heading");
        this.builder.lineBreak();
        this.builder.characters("line 2 of heading");
        this.builder.endHeading();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"h1. line 1 of heading\\\\line 2 of heading\n\ntext\n\n", (String)markup);
    }

    public void testHeading1_WithNestedMarkup() {
        this.builder.beginDocument();
        this.builder.beginHeading(1, new Attributes());
        this.builder.characters("text ");
        this.builder.beginSpan(DocumentBuilder.SpanType.EMPHASIS, new Attributes());
        this.builder.characters("emphasized");
        this.builder.endSpan();
        this.builder.endHeading();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"h1. text _emphasized_\n\ntext\n\n", (String)markup);
    }

    public void testImplicitParagrah() {
        this.builder.beginDocument();
        this.builder.characters("text1");
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text2");
        this.builder.endBlock();
        this.builder.characters("text3");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"text1\n\ntext2\n\ntext3\n\n", (String)markup);
    }

    public void testBoldSpanNoWhitespace_spanAtLineStart() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("text2");
        this.builder.endSpan();
        this.builder.characters("text3");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"*text2* text3\n\n", (String)markup);
    }

    public void testBoldSpanNoWhitespace_spanAtLineEnd() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text3");
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("text2");
        this.builder.endSpan();
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"text3 *text2*\n\n", (String)markup);
    }

    public void testBoldSpanNoWhitespace_spanMidLine() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text3");
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("text2");
        this.builder.endSpan();
        this.builder.characters("text4");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"text3 *text2* text4\n\n", (String)markup);
    }

    public void testBoldSpanNoWhitespace_adjacentSpans() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("text2");
        this.builder.endSpan();
        this.builder.beginSpan(DocumentBuilder.SpanType.ITALIC, new Attributes());
        this.builder.characters("text3");
        this.builder.endSpan();
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"*text2*_text3_\n\n", (String)markup);
    }

    public void testSpanWithAdjacentWhitespace() {
        this.builder.beginDocument();
        this.builder.characters("prefix ");
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("bolded");
        this.builder.endBlock();
        this.builder.characters(" suffix");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"prefix *bolded* suffix\n\n", (String)markup);
    }

    public void testBoldSpanWithAdjacentPunctuation() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("text2");
        this.builder.endSpan();
        this.builder.characters("!");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"*text2*!\n\n", (String)markup);
    }

    public void testEmptySpan() {
        this.builder.beginDocument();
        this.builder.characters("prefix ");
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.endBlock();
        this.builder.characters(" suffix");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"prefix  suffix\n\n", (String)markup);
    }

    public void testMonospaceSpan() {
        this.builder.beginDocument();
        this.builder.characters("prefix ");
        this.builder.beginSpan(DocumentBuilder.SpanType.MONOSPACE, new Attributes());
        this.builder.characters("test");
        this.builder.endSpan();
        this.builder.characters(" suffix");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"prefix {{test}} suffix\n\n", (String)markup);
    }

    public void testLinkSpan() {
        this.builder.beginDocument();
        this.builder.characters("prefix ");
        LinkAttributes attributes = new LinkAttributes();
        attributes.setHref("http://example.com/target");
        this.builder.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)attributes);
        this.builder.characters("test");
        this.builder.endSpan();
        this.builder.characters(" suffix");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"prefix [test | http://example.com/target] suffix\n\n", (String)markup);
    }

    public void testLinkSpanWithAdjacentSpans() {
        this.builder.beginDocument();
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("bold");
        this.builder.endSpan();
        LinkAttributes attributes = new LinkAttributes();
        attributes.setHref("http://example.com/target");
        this.builder.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)attributes);
        this.builder.characters("test");
        this.builder.endSpan();
        this.builder.beginSpan(DocumentBuilder.SpanType.ITALIC, new Attributes());
        this.builder.characters("italic");
        this.builder.endSpan();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"*bold*[test | http://example.com/target]_italic_\n\n", (String)markup);
    }

    public void testLinkSpanWithTitle() {
        this.builder.beginDocument();
        this.builder.characters("prefix ");
        LinkAttributes attributes = new LinkAttributes();
        attributes.setHref("http://example.com/target");
        attributes.setTitle("Title Words");
        this.builder.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)attributes);
        this.builder.characters("test");
        this.builder.endSpan();
        this.builder.characters(" suffix");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"prefix [test | http://example.com/target | Title Words] suffix\n\n", (String)markup);
    }

    public void testLinkSpanNoText() {
        this.builder.beginDocument();
        this.builder.characters("prefix ");
        LinkAttributes attributes = new LinkAttributes();
        attributes.setHref("http://example.com/target");
        this.builder.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)attributes);
        this.builder.endSpan();
        this.builder.characters(" suffix");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"prefix [http://example.com/target] suffix\n\n", (String)markup);
    }

    public void testLinkAlternate() {
        this.builder.beginDocument();
        this.builder.characters("prefix ");
        this.builder.link("#test", "Test 123");
        this.builder.characters(" suffix");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"prefix [Test 123 | #test] suffix\n\n", (String)markup);
    }

    public void testLinkSpanNoHref() {
        this.builder.beginDocument();
        this.builder.characters("prefix ");
        LinkAttributes attributes = new LinkAttributes();
        this.builder.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)attributes);
        this.builder.endSpan();
        this.builder.characters(" suffix");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"prefix [] suffix\n\n", (String)markup);
    }

    public void testTableWithEmptyCells() {
        this.assertTableRow("| |content| |\n\n", DocumentBuilder.BlockType.TABLE_CELL_NORMAL);
    }

    public void testTableWithEmptyHeaderCells() {
        this.assertTableRow("|| ||content|| |\n\n", DocumentBuilder.BlockType.TABLE_CELL_HEADER);
    }

    public void testDivAfterImplicitParagraph() {
        this.builder.beginDocument();
        this.builder.characters("test");
        this.builder.beginBlock(DocumentBuilder.BlockType.DIV, new Attributes());
        this.builder.characters("more ");
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("text");
        this.builder.endSpan();
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.NUMERIC_LIST, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters("text2");
        this.builder.endSpan();
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"test\n\nmore *text*\n\n# text2\n", (String)markup);
    }

    public void testDivWithinTableCell() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, new Attributes());
        this.builder.characters("first");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.DIV, new Attributes());
        this.builder.characters("content");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.DIV, new Attributes());
        this.builder.characters("content2");
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"|first|content content2|\n\n", (String)markup);
    }

    public void testItalics() {
        this.builder.beginDocument();
        this.builder.characters("prefix ");
        this.builder.beginSpan(DocumentBuilder.SpanType.ITALIC, new Attributes());
        this.builder.characters("italic phrase");
        this.builder.endBlock();
        this.builder.characters(" suffix");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"prefix _italic phrase_ suffix\n\n", (String)markup);
    }

    public void testEmptyBoldSpan() {
        this.builder.beginDocument();
        this.builder.characters("first ");
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.endSpan();
        this.builder.characters("second");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"first second\n\n", (String)markup);
    }

    public void testParagraphWithSingleNewline() {
        this.builder.beginDocument();
        this.builder.characters("first");
        this.builder.lineBreak();
        this.builder.characters("second");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"first\nsecond\n\n", (String)markup);
    }

    public void testParagraphWithMultipleNewlines() {
        this.builder.beginDocument();
        this.builder.characters("first");
        this.builder.lineBreak();
        this.builder.lineBreak();
        this.builder.lineBreak();
        this.builder.characters("second");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"first\n\\\\ \\\\second\n\n", (String)markup);
    }

    public void testListItemWithSingleNewline() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.BULLETED_LIST, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters("first");
        this.builder.lineBreak();
        this.builder.characters("second");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters("another");
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"* first\\\\second\n* another\n", (String)markup);
    }

    public void testListItemWithMultipleNewlines() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.BULLETED_LIST, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters("first");
        this.builder.lineBreak();
        this.builder.lineBreak();
        this.builder.characters("second");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters("another");
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"* first\\\\ \\\\second\n* another\n", (String)markup);
    }

    public void testListWithMultipleItems() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.BULLETED_LIST, new Attributes());
        this.emitListItem("first");
        this.emitListItem("second");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"* first\n* second\n", (String)markup);
    }

    private void emitListItem(String text) {
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters(text);
        this.builder.endBlock();
    }

    public void testListWithNestedSublist() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.BULLETED_LIST, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters("first");
        this.builder.beginBlock(DocumentBuilder.BlockType.BULLETED_LIST, new Attributes());
        this.emitListItem("first.1");
        this.emitListItem("first.2");
        this.builder.endBlock();
        this.builder.endBlock();
        this.emitListItem("second");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"* first\n** first.1\n** first.2\n* second\n", (String)markup);
    }

    public void testListWithNestedSublist2() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.BULLETED_LIST, new Attributes());
        this.emitListItem("first");
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters("second");
        this.builder.beginBlock(DocumentBuilder.BlockType.BULLETED_LIST, new Attributes());
        this.emitListItem("second.1");
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.NUMERIC_LIST, new Attributes());
        this.emitListItem("third");
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters("fourth");
        this.builder.beginBlock(DocumentBuilder.BlockType.NUMERIC_LIST, new Attributes());
        this.emitListItem("fourth.1");
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"* first\n* second\n** second.1\n\n# third\n# fourth\n## fourth.1\n", (String)markup);
    }

    public void testPreformattedWithMultipleNewlines() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, new Attributes());
        this.builder.characters("first");
        this.builder.lineBreak();
        this.builder.lineBreak();
        this.builder.characters("second");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"{noformat}first\n\nsecond{noformat}\n\n", (String)markup);
    }

    public void testImplicitParagrahWithSpan() {
        this.builder.beginDocument();
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("text1");
        this.builder.endSpan();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text2");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"*text1*\n\ntext2\n\n", (String)markup);
    }

    public void testSpanOpensImplicitParagraph() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.CODE, new Attributes());
        this.builder.characters("// some code");
        this.builder.endBlock();
        this.builder.beginSpan(DocumentBuilder.SpanType.DELETED, new Attributes());
        this.builder.characters("redacted");
        this.builder.endSpan();
        this.builder.characters(" text");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"{code}// some code{code}\n\n-redacted- text\n\n", (String)markup);
    }

    public void testBlockQuote() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.QUOTE, new Attributes());
        this.builder.characters("block text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"{quote}block text{quote}\n\n", (String)markup);
    }

    public void testBlockQuoteContainingMarkup() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.QUOTE, new Attributes());
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("bold");
        this.builder.endSpan();
        this.builder.characters("text");
        this.builder.beginSpan(DocumentBuilder.SpanType.ITALIC, new Attributes());
        this.builder.characters("italic");
        this.builder.endSpan();
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"{quote}*bold* text _italic_{quote}\n\n", (String)markup);
    }

    public void testCitationAfterBlockQuote() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.QUOTE, new Attributes());
        this.builder.beginSpan(DocumentBuilder.SpanType.CITATION, new Attributes());
        this.builder.characters("citation");
        this.builder.endSpan();
        this.builder.endBlock();
        this.builder.beginSpan(DocumentBuilder.SpanType.CITATION, new Attributes());
        this.builder.characters("citation");
        this.builder.endSpan();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"{quote}??citation??{quote}\n\n??citation??\n\n", (String)markup);
    }

    public void testImageLink() {
        this.builder.beginDocument();
        this.builder.characters("a ");
        this.builder.imageLink((Attributes)new LinkAttributes(), (Attributes)new ImageAttributes(), "#foo", "fooImage.png");
        this.builder.characters(" test");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"a !fooImage.png!:#foo test\n\n", (String)markup);
    }

    public void testImage() {
        this.builder.beginDocument();
        this.builder.characters("a ");
        this.builder.image((Attributes)new ImageAttributes(), "fooImage.png");
        this.builder.characters(" test");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"a !fooImage.png! test\n\n", (String)markup);
    }

    public void testImageNoUrl() {
        this.builder.beginDocument();
        this.builder.characters("a ");
        this.builder.image((Attributes)new ImageAttributes(), null);
        this.builder.characters(" test");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"a  test\n\n", (String)markup);
    }

    public void testSpanSuperscript() {
        this.assertSpan("begin ^span text^ end\n\n", DocumentBuilder.SpanType.SUPERSCRIPT);
    }

    public void testSpanSubscript() {
        this.assertSpan("begin ~span text~ end\n\n", DocumentBuilder.SpanType.SUBSCRIPT);
    }

    public void testSpanBold() {
        this.assertSpan("begin *span text* end\n\n", DocumentBuilder.SpanType.BOLD);
    }

    public void testSpanCitation() {
        this.assertSpan("begin ??span text?? end\n\n", DocumentBuilder.SpanType.CITATION);
    }

    public void testSpanCode() {
        this.assertSpan("begin @span text@ end\n\n", DocumentBuilder.SpanType.CODE);
    }

    public void testSpanDeleted() {
        this.assertSpan("begin -span text- end\n\n", DocumentBuilder.SpanType.DELETED);
    }

    public void testSpanEmphasis() {
        this.assertSpan("begin _span text_ end\n\n", DocumentBuilder.SpanType.EMPHASIS);
    }

    public void testSpanInserted() {
        this.assertSpan("begin +span text+ end\n\n", DocumentBuilder.SpanType.INSERTED);
    }

    public void testSpanItalic() {
        this.assertSpan("begin _span text_ end\n\n", DocumentBuilder.SpanType.ITALIC);
    }

    public void testSpanMonospace() {
        this.assertSpan("begin {{span text}} end\n\n", DocumentBuilder.SpanType.MONOSPACE);
    }

    public void testSpanQuote() {
        this.assertSpan("beginspan textend\n\n", DocumentBuilder.SpanType.QUOTE);
    }

    public void testSpanSpan() {
        this.assertSpan("beginspan textend\n\n", DocumentBuilder.SpanType.SPAN);
    }

    public void testSpanStrong() {
        this.assertSpan("begin *span text* end\n\n", DocumentBuilder.SpanType.STRONG);
    }

    public void testSpanUnderlined() {
        this.assertSpan("begin +span text+ end\n\n", DocumentBuilder.SpanType.UNDERLINED);
    }

    public void testNestedBoldItalic() {
        this.assertNestedSpan("begin *_span_* end\n\n", DocumentBuilder.SpanType.BOLD, DocumentBuilder.SpanType.ITALIC);
    }

    public void testNestedItalicBold() {
        this.assertNestedSpan("begin _*span*_ end\n\n", DocumentBuilder.SpanType.ITALIC, DocumentBuilder.SpanType.BOLD);
    }

    public void testNestedDeletedSuperscript() {
        this.assertNestedSpan("begin -^span^- end\n\n", DocumentBuilder.SpanType.DELETED, DocumentBuilder.SpanType.SUPERSCRIPT);
    }

    public void testNestedSuperscriptDeleted() {
        this.assertNestedSpan("begin ^-span-^ end\n\n", DocumentBuilder.SpanType.SUPERSCRIPT, DocumentBuilder.SpanType.DELETED);
    }

    public void testNestedUnderlineSubscript() {
        this.assertNestedSpan("begin +~span~+ end\n\n", DocumentBuilder.SpanType.UNDERLINED, DocumentBuilder.SpanType.SUBSCRIPT);
    }

    public void testNestedSubscriptUnderline() {
        this.assertNestedSpan("begin ~+span+~ end\n\n", DocumentBuilder.SpanType.SUBSCRIPT, DocumentBuilder.SpanType.UNDERLINED);
    }

    public void testNestedMonospaceCitation() {
        this.assertNestedSpan("begin {{??span??}} end\n\n", DocumentBuilder.SpanType.MONOSPACE, DocumentBuilder.SpanType.CITATION);
    }

    public void testNestedCitationMonospace() {
        this.assertNestedSpan("begin ??{{span}}?? end\n\n", DocumentBuilder.SpanType.CITATION, DocumentBuilder.SpanType.MONOSPACE);
    }

    public void testNestedLinkCode() {
        this.assertNestedSpan("begin %@span@% end\n\n", DocumentBuilder.SpanType.LINK, DocumentBuilder.SpanType.CODE);
    }

    public void testNestedCodeLink() {
        this.assertNestedSpan("begin @%span%@ end\n\n", DocumentBuilder.SpanType.CODE, DocumentBuilder.SpanType.LINK);
    }

    public void testAdjacentBoldItalic() {
        this.assertAdjacentSpan("begin *left*_right_ end\n\n", DocumentBuilder.SpanType.BOLD, DocumentBuilder.SpanType.ITALIC);
    }

    public void testAdjacentItalicBold() {
        this.assertAdjacentSpan("begin _left_*right* end\n\n", DocumentBuilder.SpanType.ITALIC, DocumentBuilder.SpanType.BOLD);
    }

    public void testAdjacentDeletedSuperscript() {
        this.assertAdjacentSpan("begin -left-^right^ end\n\n", DocumentBuilder.SpanType.DELETED, DocumentBuilder.SpanType.SUPERSCRIPT);
    }

    public void testAdjacentSuperscriptDeleted() {
        this.assertAdjacentSpan("begin ^left^-right- end\n\n", DocumentBuilder.SpanType.SUPERSCRIPT, DocumentBuilder.SpanType.DELETED);
    }

    public void testAdjacentUnderlineSubscript() {
        this.assertAdjacentSpan("begin +left+~right~ end\n\n", DocumentBuilder.SpanType.UNDERLINED, DocumentBuilder.SpanType.SUBSCRIPT);
    }

    public void testAdjacentSubscriptUnderline() {
        this.assertAdjacentSpan("begin ~left~+right+ end\n\n", DocumentBuilder.SpanType.SUBSCRIPT, DocumentBuilder.SpanType.UNDERLINED);
    }

    public void testAdjacentMonospaceCitation() {
        this.assertAdjacentSpan("begin {{left}}??right?? end\n\n", DocumentBuilder.SpanType.MONOSPACE, DocumentBuilder.SpanType.CITATION);
    }

    public void testAdjacentCitationMonospace() {
        this.assertAdjacentSpan("begin ??left??{{right}} end\n\n", DocumentBuilder.SpanType.CITATION, DocumentBuilder.SpanType.MONOSPACE);
    }

    public void testAdjacentLinkCode() {
        this.assertAdjacentSpan("begin %left%@right@ end\n\n", DocumentBuilder.SpanType.LINK, DocumentBuilder.SpanType.CODE);
    }

    public void testAdjacentCodeLink() {
        this.assertAdjacentSpan("begin @left@%right% end\n\n", DocumentBuilder.SpanType.CODE, DocumentBuilder.SpanType.LINK);
    }

    public void testItalicBoldItalic() {
        this.builder.beginDocument();
        this.builder.beginSpan(DocumentBuilder.SpanType.ITALIC, new Attributes());
        this.builder.characters("italic");
        this.builder.endSpan();
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.beginSpan(DocumentBuilder.SpanType.ITALIC, new Attributes());
        this.builder.characters("bolditalic");
        this.builder.endSpan();
        this.builder.endSpan();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)"_italic_*_bolditalic_*\n\n", (String)markup);
    }

    private void assertSpan(String expected, DocumentBuilder.SpanType spanType) {
        this.builder.beginDocument();
        this.builder.characters("begin");
        this.builder.beginSpan(spanType, new Attributes());
        this.builder.characters("span text");
        this.builder.endSpan();
        this.builder.characters("end");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)expected, (String)markup);
    }

    private void assertNestedSpan(String expected, DocumentBuilder.SpanType outerSpan, DocumentBuilder.SpanType innerSpan) {
        this.builder.beginDocument();
        this.builder.characters("begin");
        this.builder.beginSpan(outerSpan, new Attributes());
        this.builder.beginSpan(innerSpan, new Attributes());
        this.builder.characters("span");
        this.builder.endSpan();
        this.builder.endSpan();
        this.builder.characters("end");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)expected, (String)markup);
    }

    private void assertAdjacentSpan(String expected, DocumentBuilder.SpanType leftSpan, DocumentBuilder.SpanType rightSpan) {
        this.builder.beginDocument();
        this.builder.characters("begin");
        this.builder.beginSpan(leftSpan, new Attributes());
        this.builder.characters("left");
        this.builder.endSpan();
        this.builder.beginSpan(rightSpan, new Attributes());
        this.builder.characters("right");
        this.builder.endSpan();
        this.builder.characters("end");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)expected, (String)markup);
    }

    private void assertTableRow(String expectedMarkup, DocumentBuilder.BlockType cellType) {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, new Attributes());
        this.builder.beginBlock(cellType, new Attributes());
        this.builder.endBlock();
        this.builder.beginBlock(cellType, new Attributes());
        this.builder.characters("content");
        this.builder.endBlock();
        this.builder.beginBlock(cellType, new Attributes());
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        ConfluenceDocumentBuilderTest.assertEquals((String)expectedMarkup, (String)markup);
    }
}

