/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.syntax;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import junit.framework.TestCase;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.MarkupDocumentProvider;

public class DialectDocumentProviderTest
extends TestCase {
    public void testCleanUpEolMarkers() {
        String[] lines = new String[]{"one", "two", "three"};
        this.doTestCleanUpEolMarkers(lines, "\r");
        this.doTestCleanUpEolMarkers(lines, "\r\n");
        this.doTestCleanUpEolMarkers(lines, "\n");
    }

    private void doTestCleanUpEolMarkers(String[] lines, String documentEol) {
        StringBuilder buf = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (buf.length() > 0) {
                buf.append(documentEol);
            }
            buf.append(line);
            ++n2;
        }
        Document document = new Document();
        document.set(buf.toString());
        MarkupDocumentProvider.cleanUpEolMarkers((IDocument)document);
        try {
            String line;
            int index = -1;
            BufferedReader reader = new BufferedReader(new StringReader(document.get()));
            while ((line = reader.readLine()) != null) {
                DialectDocumentProviderTest.assertEquals((String)lines[++index], (String)line);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

