/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tests;

import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractMarkupGenerationTest<L extends MarkupLanguage> {
    protected MarkupParser parser;
    protected L markupLanguage;

    @Before
    public void initParser() {
        this.parser = new MarkupParser();
        this.markupLanguage = this.createMarkupLanguage();
        this.parser.setMarkupLanguage(this.markupLanguage);
    }

    protected abstract L createMarkupLanguage();

    protected void assertMarkup(String expectedHtml, String markup) {
        String html = this.toHtml(markup);
        Assert.assertEquals((Object)expectedHtml, (Object)html);
    }

    protected String toHtml(String markup) {
        StringWriter writer = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)writer);
        builder.setEmitAsDocument(false);
        this.parser.setBuilder((DocumentBuilder)builder);
        this.parser.parse(markup);
        String html = ((Object)writer).toString();
        TestUtil.println("HTML: \n" + html);
        return html;
    }
}

