/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.support;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.spi.RepositoryConnectorBranding;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;

public class MockRepositoryConnectorAdapter
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{AbstractRepositoryConnector.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof MockRepositoryConnector) {
            AbstractRepositoryConnector connector = (AbstractRepositoryConnector)adaptableObject;
            if (adapterType == AbstractRepositoryConnectorUi.class) {
                return new DynamicMockRepositoryConnectorUi(connector);
            }
            if (adapterType == RepositoryConnectorBranding.class) {
                return new RepositoryConnectorBranding(){

                    public InputStream getOverlayImageData() throws IOException {
                        return CommonTestUtil.getResource((Object)((Object)this), (String)"testdata/icons/mock-overlay.gif");
                    }

                    public InputStream getBrandingImageData() throws IOException {
                        return CommonTestUtil.getResource((Object)((Object)this), (String)"testdata/icons/mock-repository.gif");
                    }

                    public List<String> getBrands() {
                        ArrayList<String> brands = new ArrayList<String>((Collection<String>)ImmutableList.of((Object)"org.mylyn", (Object)"org.eclipse", (Object)"exceptional"));
                        brands.add(1, null);
                        return brands;
                    }

                    public String getConnectorLabel(String brand) {
                        if ("exceptional".equals(brand)) {
                            throw new NullPointerException();
                        }
                        if (this.getBrands().contains(brand)) {
                            return "Label for " + brand;
                        }
                        return super.getConnectorLabel(brand);
                    }

                    public InputStream getOverlayImageData(String brand) throws IOException {
                        if ("org.mylyn".equals(brand)) {
                            return CommonTestUtil.getResource((Object)((Object)this), (String)"testdata/icons/mock-5x5.gif");
                        }
                        if ("org.eclipse".equals(brand)) {
                            return CommonTestUtil.getResource((Object)((Object)this), (String)"testdata/icons/mock-4x4.gif");
                        }
                        if ("exceptional".equals(brand)) {
                            throw new NullPointerException();
                        }
                        return super.getOverlayImageData(brand);
                    }

                    public InputStream getBrandingImageData(String brand) throws IOException {
                        if ("org.mylyn".equals(brand)) {
                            return CommonTestUtil.getResource((Object)((Object)this), (String)"testdata/icons/mock-3x3.gif");
                        }
                        if ("org.eclipse".equals(brand)) {
                            return CommonTestUtil.getResource((Object)((Object)this), (String)"testdata/icons/mock-2x2.gif");
                        }
                        if ("exceptional".equals(brand)) {
                            throw new NullPointerException();
                        }
                        return super.getBrandingImageData(brand);
                    }
                };
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return ADAPTER_LIST;
    }

    public static final class DynamicMockRepositoryConnectorUi
    extends MockRepositoryConnectorUi {
        private final AbstractRepositoryConnector connector;

        DynamicMockRepositoryConnectorUi(AbstractRepositoryConnector connector) {
            this.connector = connector;
        }

        @Override
        public String getConnectorKind() {
            return this.connector.getConnectorKind();
        }
    }
}

