/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.core;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttributeMapper;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.junit.Test;

public class BugzillaAttributeMapperTest
extends TestCase {
    private BugzillaAttributeMapper mapper;
    private TaskData oldTaskData;
    private TaskData newTaskData;

    protected void setUp() throws Exception {
        TaskRepository repository = new TaskRepository("bugzilla", "http://repository");
        this.mapper = new BugzillaAttributeMapper(repository, null);
        this.oldTaskData = new TaskData((TaskAttributeMapper)this.mapper, "bugzilla", "http://repository", "id");
        this.newTaskData = new TaskData((TaskAttributeMapper)this.mapper, "bugzilla", "http://repository", "id");
    }

    @Test
    public void testEqualsTaskAttributeResolution() {
        TaskAttribute oldAttribute = this.oldTaskData.getRoot().createAttribute(BugzillaAttribute.RESOLUTION.getKey());
        TaskAttribute newAttribute = this.newTaskData.getRoot().createAttribute(BugzillaAttribute.RESOLUTION.getKey());
        BugzillaAttributeMapperTest.assertTrue((boolean)this.mapper.equals(newAttribute, oldAttribute));
        oldAttribute.setValue("");
        BugzillaAttributeMapperTest.assertTrue((boolean)this.mapper.equals(newAttribute, oldAttribute));
        newAttribute.setValue("");
        BugzillaAttributeMapperTest.assertTrue((boolean)this.mapper.equals(newAttribute, oldAttribute));
    }

    @Test
    public void testEqualsTaskAttributeDescription() {
        TaskAttribute oldAttribute = this.oldTaskData.getRoot().createAttribute(BugzillaAttribute.DESC.getKey());
        TaskAttribute newAttribute = this.newTaskData.getRoot().createAttribute(BugzillaAttribute.DESC.getKey());
        BugzillaAttributeMapperTest.assertTrue((boolean)this.mapper.equals(newAttribute, oldAttribute));
        oldAttribute.setValue("");
        BugzillaAttributeMapperTest.assertFalse((boolean)this.mapper.equals(newAttribute, oldAttribute));
        newAttribute.setValue("");
        BugzillaAttributeMapperTest.assertTrue((boolean)this.mapper.equals(newAttribute, oldAttribute));
    }

    @Test
    public void testEqualsTaskAttributeBugFileLoc() {
        TaskAttribute oldAttribute = this.oldTaskData.getRoot().createAttribute(BugzillaAttribute.BUG_FILE_LOC.getKey());
        TaskAttribute newAttribute = this.newTaskData.getRoot().createAttribute(BugzillaAttribute.BUG_FILE_LOC.getKey());
        BugzillaAttributeMapperTest.assertTrue((boolean)this.mapper.equals(newAttribute, oldAttribute));
        oldAttribute.setValue("");
        BugzillaAttributeMapperTest.assertTrue((boolean)this.mapper.equals(newAttribute, oldAttribute));
        newAttribute.setValue("");
        BugzillaAttributeMapperTest.assertTrue((boolean)this.mapper.equals(newAttribute, oldAttribute));
    }

    @Test
    public void testEqualsTaskAttributeStatusWhiteboard() {
        TaskAttribute oldAttribute = this.oldTaskData.getRoot().createAttribute(BugzillaAttribute.STATUS_WHITEBOARD.getKey());
        TaskAttribute newAttribute = this.newTaskData.getRoot().createAttribute(BugzillaAttribute.STATUS_WHITEBOARD.getKey());
        BugzillaAttributeMapperTest.assertTrue((boolean)this.mapper.equals(newAttribute, oldAttribute));
        oldAttribute.setValue("");
        BugzillaAttributeMapperTest.assertTrue((boolean)this.mapper.equals(newAttribute, oldAttribute));
        newAttribute.setValue("");
        BugzillaAttributeMapperTest.assertTrue((boolean)this.mapper.equals(newAttribute, oldAttribute));
    }

    @Test
    public void testEqualsTaskAttributeKeywords() {
        TaskAttribute oldAttribute = this.oldTaskData.getRoot().createAttribute(BugzillaAttribute.KEYWORDS.getKey());
        TaskAttribute newAttribute = this.newTaskData.getRoot().createAttribute(BugzillaAttribute.KEYWORDS.getKey());
        BugzillaAttributeMapperTest.assertTrue((boolean)this.mapper.equals(newAttribute, oldAttribute));
        oldAttribute.setValue("");
        BugzillaAttributeMapperTest.assertTrue((boolean)this.mapper.equals(newAttribute, oldAttribute));
        newAttribute.setValue("");
        BugzillaAttributeMapperTest.assertTrue((boolean)this.mapper.equals(newAttribute, oldAttribute));
        newAttribute.addValue("AA");
        BugzillaAttributeMapperTest.assertFalse((boolean)this.mapper.equals(newAttribute, oldAttribute));
    }
}

