/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.core;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;

public class BugzillaVersionTest
extends TestCase {
    public static final BugzillaVersion BUGZILLA_2_18_1 = new BugzillaVersion("2.18.1");
    public static final BugzillaVersion BUGZILLA_2_18_2 = new BugzillaVersion("2.18.2");
    public static final BugzillaVersion BUGZILLA_2_20_3 = new BugzillaVersion("2.20.3");
    public static final BugzillaVersion BUGZILLA_3_0_4 = new BugzillaVersion("3.0.4");

    public void testwrongVersion() throws Exception {
        BugzillaVersion version = new BugzillaVersion("3.2.X");
        BugzillaVersionTest.assertEquals((String)"3.2", (String)version.toString());
    }

    public void testMissingVersion() throws Exception {
        BugzillaVersion version = new BugzillaVersion("3..1.X.");
        BugzillaVersionTest.assertEquals((String)"3.0.1", (String)version.toString());
    }

    public void testRCVersions() throws Exception {
        BugzillaVersion versionRC1 = new BugzillaVersion("3.2RC1");
        BugzillaVersionTest.assertEquals((String)"3.2RC1", (String)versionRC1.toString());
        BugzillaVersion versionRC2 = new BugzillaVersion("3.2RC2");
        BugzillaVersionTest.assertEquals((String)"3.2RC2", (String)versionRC2.toString());
        BugzillaVersionTest.assertEquals((int)-1, (int)versionRC1.compareTo(versionRC2));
        BugzillaVersionTest.assertEquals((int)1, (int)versionRC2.compareTo(versionRC1));
        BugzillaVersionTest.assertEquals((int)-1, (int)versionRC1.compareTo(BugzillaVersion.BUGZILLA_3_2));
        BugzillaVersionTest.assertEquals((int)0, (int)versionRC1.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_2));
    }

    public void testCompareAll() throws Exception {
        BugzillaVersionTest.assertEquals((int)0, (int)BUGZILLA_2_18_1.compareTo(BUGZILLA_2_18_1));
        BugzillaVersionTest.assertEquals((int)-1, (int)BUGZILLA_2_18_1.compareTo(BUGZILLA_2_18_2));
        BugzillaVersionTest.assertEquals((int)1, (int)BUGZILLA_2_18_2.compareTo(BUGZILLA_2_18_1));
        BugzillaVersionTest.assertEquals((int)-1, (int)BUGZILLA_2_18_1.compareTo(BUGZILLA_2_20_3));
        BugzillaVersionTest.assertEquals((int)1, (int)BUGZILLA_3_0_4.compareMajorMinorOnly(BUGZILLA_2_20_3));
    }

    public void testCompareMajorMinorOnly() throws Exception {
        BugzillaVersionTest.assertEquals((int)0, (int)BUGZILLA_2_18_1.compareMajorMinorOnly(BUGZILLA_2_18_1));
        BugzillaVersionTest.assertEquals((int)0, (int)BUGZILLA_2_18_1.compareMajorMinorOnly(BUGZILLA_2_18_2));
        BugzillaVersionTest.assertEquals((int)0, (int)BUGZILLA_2_18_2.compareMajorMinorOnly(BUGZILLA_2_18_1));
        BugzillaVersionTest.assertEquals((int)-1, (int)BUGZILLA_2_18_1.compareMajorMinorOnly(BUGZILLA_2_20_3));
        BugzillaVersionTest.assertEquals((int)1, (int)BUGZILLA_3_0_4.compareMajorMinorOnly(BUGZILLA_2_20_3));
    }

    public void testToString() throws Exception {
        BugzillaVersionTest.assertEquals((String)"2.18.1", (String)BUGZILLA_2_18_1.toString());
        BugzillaVersionTest.assertEquals((String)"3.0.4", (String)BUGZILLA_3_0_4.toString());
    }

    public void testPlusVersions() throws Exception {
        BugzillaVersion versionPlus = new BugzillaVersion("3.2+");
        BugzillaVersionTest.assertEquals((String)"3.2+", (String)versionPlus.toString());
        BugzillaVersion versionRC1 = new BugzillaVersion("3.2RC1");
        BugzillaVersionTest.assertEquals((String)"3.2RC1", (String)versionRC1.toString());
        BugzillaVersion versionRC2 = new BugzillaVersion("3.2RC2");
        BugzillaVersionTest.assertEquals((String)"3.2RC2", (String)versionRC2.toString());
        BugzillaVersion versionRC1Plus = new BugzillaVersion("3.2RC1+");
        BugzillaVersionTest.assertEquals((String)"3.2RC1+", (String)versionRC1Plus.toString());
        BugzillaVersionTest.assertEquals((int)1, (int)versionRC1Plus.compareTo(versionRC1));
        BugzillaVersionTest.assertEquals((int)0, (int)versionRC1Plus.compareMajorMinorOnly(versionRC1));
        BugzillaVersionTest.assertEquals((int)-1, (int)versionRC1.compareTo(versionRC1Plus));
        BugzillaVersionTest.assertEquals((int)1, (int)versionRC2.compareTo(versionRC1Plus));
        BugzillaVersionTest.assertEquals((int)1, (int)versionPlus.compareTo(BugzillaVersion.BUGZILLA_3_2));
        BugzillaVersionTest.assertEquals((int)0, (int)versionPlus.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_2));
    }
}

