/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskGroup;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnsubmittedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.SortCriterion;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListInterestSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class TaskListSorterTest
extends TestCase {
    private static final String MEMENTO_KEY_SORT_DIRECTION = "sortDirection";
    private static final String MEMENTO_KEY_SORT_INDEX = "sortIndex";
    private static final String MEMENTO_KEY_SORTER = "sorter";
    private static final String MEMENTO_KEY_SORTER2 = "sorter2";

    public void testPreferenceMigration() throws Exception {
        TaskListSorter sorter = new TaskListSorter();
        TaskListView view = new TaskListView();
        XMLMemento memento = XMLMemento.createWriteRoot((String)MEMENTO_KEY_SORT_INDEX);
        IMemento child = memento.createChild(MEMENTO_KEY_SORTER);
        child.putInteger(MEMENTO_KEY_SORT_INDEX, 0);
        child.putInteger(MEMENTO_KEY_SORT_DIRECTION, 1);
        child = memento.createChild(MEMENTO_KEY_SORTER2);
        child.putInteger(MEMENTO_KEY_SORT_INDEX, 1);
        child.putInteger(MEMENTO_KEY_SORT_DIRECTION, -1);
        view.migrateSorterState(sorter, (IMemento)memento);
        TaskListSorterTest.assertEquals((Object)SortCriterion.SortKey.PRIORITY, (Object)sorter.getTaskComparator().getSortCriterion(0).getKey());
        TaskListSorterTest.assertEquals((int)1, (int)sorter.getTaskComparator().getSortCriterion(0).getDirection());
        TaskListSorterTest.assertEquals((Object)SortCriterion.SortKey.SUMMARY, (Object)sorter.getTaskComparator().getSortCriterion(1).getKey());
        TaskListSorterTest.assertEquals((int)-1, (int)sorter.getTaskComparator().getSortCriterion(1).getDirection());
        memento = XMLMemento.createWriteRoot((String)MEMENTO_KEY_SORT_INDEX);
        child = memento.createChild(MEMENTO_KEY_SORTER);
        child.putInteger(MEMENTO_KEY_SORT_INDEX, 3);
        child.putInteger(MEMENTO_KEY_SORT_DIRECTION, -1);
        child = memento.createChild(MEMENTO_KEY_SORTER2);
        child.putInteger(MEMENTO_KEY_SORT_INDEX, 2);
        child.putInteger(MEMENTO_KEY_SORT_DIRECTION, -1);
        view.migrateSorterState(sorter, (IMemento)memento);
        TaskListSorterTest.assertEquals((Object)SortCriterion.SortKey.TASK_ID, (Object)sorter.getTaskComparator().getSortCriterion(0).getKey());
        TaskListSorterTest.assertEquals((int)-1, (int)sorter.getTaskComparator().getSortCriterion(0).getDirection());
        TaskListSorterTest.assertEquals((Object)SortCriterion.SortKey.DATE_CREATED, (Object)sorter.getTaskComparator().getSortCriterion(1).getKey());
        TaskListSorterTest.assertEquals((int)-1, (int)sorter.getTaskComparator().getSortCriterion(1).getDirection());
    }

    public void testSortWithError() {
        TaskListSorter sorter = new TaskListSorter();
        LocalTask task1 = new LocalTask("1", null);
        MockTask task2 = new MockTask("local", "", "1");
        Object[] tasks = new Object[]{task1, task2};
        Date start = new Date();
        task2.setCreationDate(start);
        task1.setCreationDate(new Date(start.getTime() - 1L));
        task1.setPriority("P5");
        task2.setPriority("P1");
        sorter.getTaskComparator().getSortCriterion(0).setKey(SortCriterion.SortKey.TASK_ID);
        sorter.sort((Viewer)new EmptyViewer(), tasks);
        TaskListSorterTest.assertEquals((Object)task1, (Object)tasks[1]);
        TaskListSorterTest.assertEquals((Object)((Object)task2), (Object)tasks[0]);
        sorter.getTaskComparator().getSortCriterion(0).setKey(SortCriterion.SortKey.DATE_CREATED);
        sorter.sort((Viewer)new EmptyViewer(), tasks);
        TaskListSorterTest.assertEquals((Object)task1, (Object)tasks[0]);
        TaskListSorterTest.assertEquals((Object)((Object)task2), (Object)tasks[1]);
        sorter.getTaskComparator().getSortCriterion(0).setKey(SortCriterion.SortKey.PRIORITY);
        sorter.sort((Viewer)new EmptyViewer(), tasks);
        TaskListSorterTest.assertEquals((Object)task1, (Object)tasks[1]);
        TaskListSorterTest.assertEquals((Object)((Object)task2), (Object)tasks[0]);
        sorter.getTaskComparator().getSortCriterion(0).setKey(SortCriterion.SortKey.SUMMARY);
        sorter.getTaskComparator().getSortCriterion(0).setDirection(-1);
        sorter.sort((Viewer)new EmptyViewer(), tasks);
        TaskListSorterTest.assertEquals((Object)task1, (Object)tasks[0]);
        TaskListSorterTest.assertEquals((Object)((Object)task2), (Object)tasks[1]);
    }

    public void testRootTaskSorting() {
        TaskListSorter sorter = new TaskListSorter();
        sorter.getTaskComparator().getSortCriterion(0).setKey(SortCriterion.SortKey.SUMMARY);
        LocalTask task = new LocalTask("1", "");
        UncategorizedTaskContainer uncategorizedTaskContainer = new UncategorizedTaskContainer();
        UnsubmittedTaskContainer unsubmittedTaskContainer = new UnsubmittedTaskContainer("connectorKind", "repositoryUrl");
        TaskCategory category = new TaskCategory("cat");
        RepositoryQuery repositoryQuery = new RepositoryQuery("connectorKind", "queryName");
        TaskGroup taskGroup = new TaskGroup("parentHandle", "summary", "groupBy");
        UnmatchedTaskContainer unmatchedTaskContainer = new UnmatchedTaskContainer("connectorKind", "repositoryUrl");
        this.checkToRootElements(sorter, (AbstractTaskContainer)uncategorizedTaskContainer, (AbstractTaskContainer)unsubmittedTaskContainer);
        this.checkToRootElements(sorter, (AbstractTaskContainer)uncategorizedTaskContainer, (AbstractTaskContainer)category);
        this.checkToRootElements(sorter, (AbstractTaskContainer)uncategorizedTaskContainer, (AbstractTaskContainer)repositoryQuery);
        this.checkToRootElements(sorter, (AbstractTaskContainer)uncategorizedTaskContainer, (AbstractTaskContainer)taskGroup);
        this.checkToRootElements(sorter, (AbstractTaskContainer)uncategorizedTaskContainer, (AbstractTaskContainer)unmatchedTaskContainer);
        this.checkToRootElements(sorter, (AbstractTaskContainer)unsubmittedTaskContainer, (AbstractTaskContainer)category);
        this.checkToRootElements(sorter, (AbstractTaskContainer)unsubmittedTaskContainer, (AbstractTaskContainer)repositoryQuery);
        this.checkToRootElements(sorter, (AbstractTaskContainer)unsubmittedTaskContainer, (AbstractTaskContainer)taskGroup);
        this.checkToRootElements(sorter, (AbstractTaskContainer)unsubmittedTaskContainer, (AbstractTaskContainer)unmatchedTaskContainer);
        this.checkToRootElements(sorter, (AbstractTaskContainer)category, (AbstractTaskContainer)repositoryQuery);
        this.checkToRootElements(sorter, (AbstractTaskContainer)category, (AbstractTaskContainer)taskGroup);
        this.checkToRootElements(sorter, (AbstractTaskContainer)category, (AbstractTaskContainer)unmatchedTaskContainer);
        this.checkToRootElements(sorter, (AbstractTaskContainer)repositoryQuery, (AbstractTaskContainer)taskGroup);
        this.checkToRootElements(sorter, (AbstractTaskContainer)repositoryQuery, (AbstractTaskContainer)unmatchedTaskContainer);
        this.checkToRootElements(sorter, (AbstractTaskContainer)taskGroup, (AbstractTaskContainer)unmatchedTaskContainer);
        this.checkToRootElements(sorter, (AbstractTaskContainer)task, (AbstractTaskContainer)uncategorizedTaskContainer);
        this.checkToRootElements(sorter, (AbstractTaskContainer)task, (AbstractTaskContainer)unsubmittedTaskContainer);
        this.checkToRootElements(sorter, (AbstractTaskContainer)task, (AbstractTaskContainer)category);
        this.checkToRootElements(sorter, (AbstractTaskContainer)task, (AbstractTaskContainer)repositoryQuery);
        this.checkToRootElements(sorter, (AbstractTaskContainer)task, (AbstractTaskContainer)taskGroup);
        this.checkToRootElements(sorter, (AbstractTaskContainer)task, (AbstractTaskContainer)unmatchedTaskContainer);
    }

    private void checkToRootElements(TaskListSorter sorter, AbstractTaskContainer e1, AbstractTaskContainer e2) {
        TaskListSorterTest.assertEquals((int)-1, (int)sorter.compare(null, (Object)e1, (Object)e2));
        TaskListSorterTest.assertEquals((int)1, (int)sorter.compare(null, (Object)e2, (Object)e1));
    }

    public void testScheduledTaskSorting() {
        TaskListInterestSorter sorter = new TaskListInterestSorter();
        MockTask task1 = new MockTask("local", "MYLN:1", "1");
        MockTask task2 = new MockTask("local", "MYLN:2", "2");
        Calendar start1 = TaskActivityUtil.getCalendar();
        start1.add(3, -1);
        TaskActivityUtil.snapStartOfWorkWeek((Calendar)start1);
        Calendar end1 = TaskActivityUtil.getCalendar();
        end1.setTimeInMillis(start1.getTimeInMillis());
        TaskActivityUtil.snapEndOfWeek((Calendar)end1);
        WeekDateRange range1 = new WeekDateRange(start1, end1);
        TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)task1, (DateRange)range1);
        Calendar start2 = TaskActivityUtil.getCalendar();
        start2.add(11, -1);
        Calendar end2 = TaskActivityUtil.getCalendar();
        DateRange range2 = new DateRange(start2, end2);
        TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)task2, range2);
        TaskListSorterTest.assertTrue((sorter.compare((Viewer)new EmptyViewer(), (Object)task1, (Object)task2) < 0 ? 1 : 0) != 0);
    }

    public void testSummaryOrderSorting() {
        MockTask[] tasks = new MockTask[]{new MockTask("local", "4", "c"), new MockTask("local", "1", "b"), new MockTask("local", "11", "a"), new MockTask("local", "11", "d"), new MockTask("local", "3", "c"), new MockTask("local", "5", "a")};
        Date start = new Date();
        tasks[5].setCreationDate(start);
        tasks[4].setCreationDate(new Date(start.getTime() - 1L));
        tasks[3].setCreationDate(new Date(start.getTime() - 2L));
        tasks[2].setCreationDate(new Date(start.getTime() - 3L));
        tasks[1].setCreationDate(new Date(start.getTime() - 4L));
        tasks[0].setCreationDate(new Date(start.getTime() - 5L));
        TaskListSorter sorter = new TaskListSorter();
        sorter.getTaskComparator().getSortCriterion(0).setKey(SortCriterion.SortKey.SUMMARY);
        sorter.getTaskComparator().getSortCriterion(1).setKey(SortCriterion.SortKey.DATE_CREATED);
        sorter.sort((Viewer)new EmptyViewer(), (Object[])tasks);
        TaskListSorterTest.assertEquals((String)"11", (String)tasks[0].getTaskKey());
        TaskListSorterTest.assertEquals((String)"a", (String)tasks[0].getSummary());
        TaskListSorterTest.assertEquals((String)"5", (String)tasks[1].getTaskKey());
        TaskListSorterTest.assertEquals((String)"1", (String)tasks[2].getTaskKey());
        TaskListSorterTest.assertEquals((String)"4", (String)tasks[3].getTaskKey());
        TaskListSorterTest.assertEquals((String)"3", (String)tasks[4].getTaskKey());
        TaskListSorterTest.assertEquals((String)"11", (String)tasks[5].getTaskKey());
        TaskListSorterTest.assertEquals((String)"d", (String)tasks[5].getSummary());
    }

    public void testRankOrderSorting() {
        MockTask[] tasks = new MockTask[]{new MockTask("local", "4", "c"), new MockTask("local", "1", "b"), new MockTask("local", "11", "a"), new MockTask("local", "11", "d"), new MockTask("local", "3", "c"), new MockTask("local", "5", "a")};
        Date start = new Date();
        tasks[5].setCreationDate(start);
        tasks[4].setCreationDate(new Date(start.getTime() - 1L));
        tasks[3].setCreationDate(new Date(start.getTime() - 2L));
        tasks[2].setCreationDate(new Date(start.getTime() - 3L));
        tasks[1].setCreationDate(new Date(start.getTime() - 4L));
        tasks[0].setCreationDate(new Date(start.getTime() - 5L));
        tasks[0].setAttribute("task.common.rank", "1");
        tasks[2].setAttribute("task.common.rank", "2");
        tasks[4].setAttribute("task.common.rank", "3");
        tasks[1].setAttribute("task.common.rank", "4");
        tasks[3].setAttribute("task.common.rank", "5");
        tasks[5].setAttribute("task.common.rank", "6");
        TaskListSorter sorter = new TaskListSorter();
        sorter.getTaskComparator().getSortCriterion(0).setKey(SortCriterion.SortKey.RANK);
        sorter.getTaskComparator().getSortCriterion(1).setKey(SortCriterion.SortKey.DATE_CREATED);
        sorter.sort((Viewer)new EmptyViewer(), (Object[])tasks);
        TaskListSorterTest.assertEquals((String)"4", (String)tasks[0].getTaskKey());
        TaskListSorterTest.assertEquals((String)"11", (String)tasks[1].getTaskKey());
        TaskListSorterTest.assertEquals((String)"a", (String)tasks[1].getSummary());
        TaskListSorterTest.assertEquals((String)"3", (String)tasks[2].getTaskKey());
        TaskListSorterTest.assertEquals((String)"1", (String)tasks[3].getTaskKey());
        TaskListSorterTest.assertEquals((String)"11", (String)tasks[4].getTaskKey());
        TaskListSorterTest.assertEquals((String)"d", (String)tasks[4].getSummary());
        TaskListSorterTest.assertEquals((String)"5", (String)tasks[5].getTaskKey());
    }

    public void testRankOrderSortingWithNullRank() {
        MockTask[] tasks = new MockTask[]{new MockTask("local", "1", "a"), new MockTask("local", "2", "b"), new MockTask("local", "3", "c"), new MockTask("local", "4", "d"), new MockTask("local", "5", "e"), new MockTask("local", "6", "f")};
        Date start = new Date();
        tasks[5].setCreationDate(start);
        tasks[4].setCreationDate(new Date(start.getTime() - 1L));
        tasks[3].setCreationDate(new Date(start.getTime() - 2L));
        tasks[2].setCreationDate(new Date(start.getTime() - 3L));
        tasks[1].setCreationDate(new Date(start.getTime() - 4L));
        tasks[0].setCreationDate(new Date(start.getTime() - 5L));
        tasks[0].setAttribute("task.common.rank", "3");
        tasks[1].setAttribute("task.common.rank", null);
        tasks[2].setAttribute("task.common.rank", "2");
        tasks[3].setAttribute("task.common.rank", "1");
        tasks[4].setAttribute("task.common.rank", "");
        tasks[5].setAttribute("task.common.rank", null);
        TaskListSorter sorter = new TaskListSorter();
        sorter.getTaskComparator().getSortCriterion(0).setKey(SortCriterion.SortKey.RANK);
        sorter.getTaskComparator().getSortCriterion(1).setKey(SortCriterion.SortKey.DATE_CREATED);
        sorter.sort((Viewer)new EmptyViewer(), (Object[])tasks);
        TaskListSorterTest.assertEquals((String)"2", (String)tasks[0].getTaskKey());
        TaskListSorterTest.assertEquals((String)"5", (String)tasks[1].getTaskKey());
        TaskListSorterTest.assertEquals((String)"6", (String)tasks[2].getTaskKey());
        TaskListSorterTest.assertEquals((String)"4", (String)tasks[3].getTaskKey());
        TaskListSorterTest.assertEquals((String)"3", (String)tasks[4].getTaskKey());
        TaskListSorterTest.assertEquals((String)"1", (String)tasks[5].getTaskKey());
    }

    public void testModuleSummaryOrderSorting() {
        MockTask[] tasks = new MockTask[]{new MockTask("local", "MYLN:4", "c"), new MockTask("local", "MYLN:1", "b"), new MockTask("local", "MYLN:11", "a"), new MockTask("local", "MYLN:11", "b"), new MockTask("local", "MYLN:5", "a")};
        Date start = new Date();
        tasks[4].setCreationDate(start);
        tasks[3].setCreationDate(new Date(start.getTime() - 1L));
        tasks[2].setCreationDate(new Date(start.getTime() - 2L));
        tasks[1].setCreationDate(new Date(start.getTime() - 3L));
        tasks[0].setCreationDate(new Date(start.getTime() - 4L));
        TaskListSorter sorter = new TaskListSorter();
        sorter.getTaskComparator().getSortCriterion(0).setKey(SortCriterion.SortKey.SUMMARY);
        sorter.getTaskComparator().getSortCriterion(1).setKey(SortCriterion.SortKey.DATE_CREATED);
        sorter.sort((Viewer)new EmptyViewer(), (Object[])tasks);
        TaskListSorterTest.assertEquals((String)"MYLN:11", (String)tasks[0].getTaskKey());
        TaskListSorterTest.assertEquals((String)"a", (String)tasks[0].getSummary());
        TaskListSorterTest.assertEquals((String)"MYLN:5", (String)tasks[1].getTaskKey());
        TaskListSorterTest.assertEquals((String)"MYLN:1", (String)tasks[2].getTaskKey());
        TaskListSorterTest.assertEquals((String)"MYLN:11", (String)tasks[3].getTaskKey());
        TaskListSorterTest.assertEquals((String)"b", (String)tasks[3].getSummary());
        TaskListSorterTest.assertEquals((String)"MYLN:4", (String)tasks[4].getTaskKey());
    }

    public void testLocalTaskSort() {
        TaskListSorter sorter = new TaskListSorter();
        LocalTask task1 = new LocalTask("1", "task1");
        LocalTask task2 = new LocalTask("2", "task2");
        LocalTask task3 = new LocalTask("3", "task3");
        Object[] tasks = new ITask[]{task1, task2, task3};
        Date start = new Date();
        task1.setCreationDate(start);
        task2.setCreationDate(new Date(start.getTime() - 1L));
        task3.setCreationDate(new Date(start.getTime() - 2L));
        sorter.getTaskComparator().getSortCriterion(0).setKey(SortCriterion.SortKey.DATE_CREATED);
        sorter.sort((Viewer)new EmptyViewer(), tasks);
        sorter.getTaskComparator().getSortCriterion(0).setDirection(-1);
        sorter.sort((Viewer)new EmptyViewer(), tasks);
    }

    public class EmptyViewer
    extends Viewer {
        public Control getControl() {
            return null;
        }

        public Object getInput() {
            return null;
        }

        public ISelection getSelection() {
            return null;
        }

        public void refresh() {
        }

        public void setInput(Object input) {
        }

        public void setSelection(ISelection selection, boolean reveal) {
        }
    }
}

