/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskComparator;
import org.eclipse.mylyn.tasks.core.ITask;
import org.junit.Assert;
import org.junit.Test;

public class TaskComparatorTest {
    @Test
    public void compareRank() {
        this.assertCompare(this.taskWithRank("5"), this.taskWithRank("7"));
        this.assertCompare(this.taskWithRank("5"), this.taskWithRank("17"));
        this.assertCompare(this.taskWithRank("5"), this.taskWithRank("17.1"));
        this.assertCompare(this.taskWithRank("5.3"), this.taskWithRank("17.1"));
        this.assertCompare(this.taskWithRank("#$d"), this.taskWithRank("#$e"));
        this.assertCompare(this.taskWithRank("gjp"), this.taskWithRank("gkp"));
        this.assertCompare(this.taskWithRank("A"), this.taskWithRank("a"));
        this.assertCompare(this.taskWithRank("dsfhgSd"), this.taskWithRank("dsfhgsd"));
        this.assertCompare(this.taskWithRank("dsfhgS"), this.taskWithRank("dsfhgsd"));
        this.assertCompare(this.taskWithRank("dsfhgs"), this.taskWithRank("dsfhgsd"));
        Assert.assertEquals((long)0L, (long)this.compare(this.taskWithRank("5"), this.taskWithRank("5")));
        Assert.assertEquals((long)0L, (long)this.compare(this.taskWithRank("17.1"), this.taskWithRank("17.1")));
        Assert.assertEquals((long)0L, (long)this.compare(this.taskWithRank("dsfhgs"), this.taskWithRank("dsfhgs")));
        Assert.assertEquals((long)0L, (long)this.compare(this.taskWithRank("ds#fHgs"), this.taskWithRank("ds#fHgs")));
    }

    private void assertCompare(ITask task1, ITask task2) {
        Assert.assertTrue((this.compare(task1, task2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.compare(task2, task1) > 0 ? 1 : 0) != 0);
    }

    private int compare(ITask task1, ITask task2) {
        return new TaskComparator().compare(task1, task2);
    }

    private ITask taskWithRank(String rank) {
        TaskTask task = new TaskTask("kind", "http://mock", "1");
        task.setPriority("");
        task.setAttribute("task.common.rank", rank);
        return task;
    }
}

