/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests;

import java.io.PrintStream;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.ManagedTestSuite;
import org.eclipse.mylyn.commons.sdk.util.TestConfiguration;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.trac.tests.AllTracHeadlessStandaloneTests;
import org.eclipse.mylyn.trac.tests.EmptyTest;
import org.eclipse.mylyn.trac.tests.core.TracAttachmentHandlerTest;
import org.eclipse.mylyn.trac.tests.core.TracRepositoryConnectorTest;
import org.eclipse.mylyn.trac.tests.core.TracRepositoryConnectorWebTest;
import org.eclipse.mylyn.trac.tests.core.TracRepositoryQueryTest;
import org.eclipse.mylyn.trac.tests.core.TracTaskDataHandlerXmlRpcTest;
import org.eclipse.mylyn.trac.tests.core.TracUtilTest;
import org.eclipse.mylyn.trac.tests.support.TracFixture;
import org.eclipse.mylyn.trac.tests.support.TracTestCleanupUtil;
import org.eclipse.mylyn.trac.tests.ui.TracHyperlinkUtilTest;
import org.eclipse.mylyn.trac.tests.ui.TracRepositorySettingsPageTest;

public class AllTracTests {
    public static Test suite() {
        if (CommonTestUtil.fixProxyConfiguration()) {
            CommonTestUtil.dumpSystemInfo((PrintStream)System.err);
        }
        ManagedTestSuite suite = new ManagedTestSuite(AllTracTests.class.getName());
        AllTracTests.addEmptyTest((TestSuite)suite, TestConfiguration.getDefault());
        return suite;
    }

    public static Test suite(TestConfiguration configuration) {
        TestSuite suite = new TestSuite(AllTracTests.class.getName());
        AllTracTests.addEmptyTest(suite, configuration);
        return suite;
    }

    private static void addEmptyTest(TestSuite suite, TestConfiguration default1) {
        suite.addTestSuite(EmptyTest.class);
    }

    public static void addTests(TestSuite suite, TestConfiguration configuration) {
        suite.addTest(AllTracHeadlessStandaloneTests.suite(configuration));
        suite.addTestSuite(TracUtilTest.class);
        suite.addTestSuite(TracHyperlinkUtilTest.class);
        if (!configuration.isLocalOnly()) {
            suite.addTestSuite(TracRepositoryQueryTest.class);
            suite.addTestSuite(TracRepositorySettingsPageTest.class);
            List fixtures = configuration.discover(TracFixture.class, "trac");
            for (TracFixture fixture : fixtures) {
                if (fixture.hasTag(TracFixture.TAG_MISC)) continue;
                AllTracTests.addTests(suite, configuration, fixture);
            }
        }
    }

    protected static void addTests(TestSuite suite, TestConfiguration configuration, TracFixture fixture) {
        fixture.createSuite(suite);
        if (configuration.hasKind(TestConfiguration.TestKind.INTEGRATION) && !configuration.isLocalOnly() && CommonTestUtil.hasCredentials((CommonTestUtil.PrivilegeLevel)CommonTestUtil.PrivilegeLevel.ADMIN)) {
            fixture.add(TracTestCleanupUtil.class);
        }
        fixture.add(TracRepositoryConnectorTest.class);
        if (fixture.getAccessMode() == ITracClient.Version.XML_RPC) {
            fixture.add(TracTaskDataHandlerXmlRpcTest.class);
            fixture.add(TracAttachmentHandlerTest.class);
        } else {
            fixture.add(TracRepositoryConnectorWebTest.class);
        }
        fixture.done();
    }
}

