/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.mylyn.internal.wikitext.core.ant.AbstractTestAntTask;
import org.eclipse.mylyn.internal.wikitext.core.ant.HtmlToMarkupTask;
import org.eclipse.mylyn.wikitext.tests.TestUtil;

public class HtmlToMarkupTaskTest
extends AbstractTestAntTask {
    private HtmlToMarkupTask task;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.task = this.createTask();
        this.task.setMarkupLanguage(this.languageName);
    }

    private HtmlToMarkupTask createTask() {
        return new HtmlToMarkupTask();
    }

    public void testSimpleOutput() throws IOException {
        File markup = this.createSimpleHtmlMarkup();
        this.task.setFile(markup);
        this.task.execute();
        this.listFiles();
        File markupFile = new File(markup.getParentFile(), "markup.textile");
        HtmlToMarkupTaskTest.assertTrue((String)("Expecting file: " + markupFile), (markupFile.exists() && markupFile.isFile() ? 1 : 0) != 0);
        String content = this.getContent(markupFile);
        TestUtil.println(content);
        HtmlToMarkupTaskTest.assertTrue((boolean)content.equals("h1. First Heading\n\nsome content\n\nh1. Second Heading\n\nsome more content\n\n"));
    }

    private File createSimpleHtmlMarkup() throws IOException {
        File htmlFile = new File(this.tempFolder, "markup.html");
        try (PrintWriter writer = new PrintWriter(new FileWriter(htmlFile));){
            writer.println("<html><body>\n<h1>First Heading</h1>\n\n<p>some content</p>\n<h1>Second Heading</h1>\n<p>some more content</p></body></html>");
        }
        return htmlFile;
    }

    public void testTaskdef() {
        HtmlToMarkupTaskTest.assertEquals((String)HtmlToMarkupTask.class.getName(), (String)this.loadTaskdefBundle().getString("html-to-wikitext"));
    }
}

