/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import org.eclipse.mylyn.internal.tasks.ui.TaskReviewArtifactFilter;
import org.eclipse.mylyn.tasks.core.ITask;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ArtifactFilterTest {
    @Test
    public void testReviewArtifactIsFiltered() {
        ITask task = (ITask)Mockito.mock(ITask.class);
        Mockito.when((Object)task.getAttribute("org.eclipse.mylyn.is.artifact")).thenReturn((Object)"true");
        TaskReviewArtifactFilter filter = new TaskReviewArtifactFilter();
        boolean wasFiltered = !filter.select(null, (Object)task);
        Assert.assertTrue((boolean)wasFiltered);
    }

    @Test
    public void testNonReviewArtifactIsntFiltered() {
        ITask task = (ITask)Mockito.mock(ITask.class);
        Mockito.when((Object)task.getAttribute("org.eclipse.mylyn.is.artifact")).thenReturn((Object)"false");
        TaskReviewArtifactFilter filter = new TaskReviewArtifactFilter();
        boolean wasFiltered = !filter.select(null, (Object)task);
        Assert.assertFalse((boolean)wasFiltered);
    }

    @Test
    public void testUnclassifiedReviewArtifactIsntFiltered() {
        TaskReviewArtifactFilter filter = new TaskReviewArtifactFilter();
        ITask task = (ITask)Mockito.mock(ITask.class);
        boolean wasFiltered = !filter.select(null, (Object)task);
        Assert.assertFalse((boolean)wasFiltered);
    }

    @Test
    public void testArbitaryElementsAreNotFiltered() {
        TaskReviewArtifactFilter filter = new TaskReviewArtifactFilter();
        Object element = new Object();
        boolean wasFiltered = !filter.select(null, element);
        Assert.assertFalse((boolean)wasFiltered);
    }
}

