/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.mylyn.internal.trac.core.client.InvalidTicketException;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.util.TracUtil;

public class WebSearchResultParser {
    private final List<TracTicket> tickets = new ArrayList<TracTicket>();

    public void parse(BufferedReader reader) throws IOException, TracException {
        TracTicket.Key[] fields = this.parseHeader(reader);
        this.parseTickets(reader, fields);
    }

    public void parseTickets(BufferedReader reader, TracTicket.Key[] fields) throws IOException, InvalidTicketException {
        String line;
        while ((line = reader.readLine()) != null) {
            TracTicket ticket = new TracTicket();
            this.tickets.add(ticket);
            StringTokenizer t = new StringTokenizer(line, "\t", true);
            int i = 0;
            while (i < fields.length && t.hasMoreTokens()) {
                String nextToken = t.nextToken();
                if (nextToken.equals("\t")) {
                    nextToken = "";
                } else if (t.hasMoreTokens()) {
                    t.nextToken();
                }
                TracTicket.Key key = fields[i];
                if (key != null) {
                    this.assignTicketValue(ticket, key, nextToken);
                }
                ++i;
            }
        }
    }

    public void assignTicketValue(TracTicket ticket, TracTicket.Key key, String value) throws InvalidTicketException {
        try {
            if (key == TracTicket.Key.ID) {
                ticket.setId(Integer.parseInt(value));
            } else if (key == TracTicket.Key.TIME) {
                ticket.setCreated(TracUtil.parseDate(Integer.parseInt(value)));
            } else if (key == TracTicket.Key.CHANGE_TIME) {
                ticket.setLastChanged(TracUtil.parseDate(Integer.parseInt(value)));
            } else {
                ticket.putBuiltinValue(key, WebSearchResultParser.parseTicketValue(value));
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private TracTicket.Key[] parseHeader(BufferedReader reader) throws IOException, InvalidTicketException {
        String line = reader.readLine();
        if (line == null) {
            throw new InvalidTicketException();
        }
        StringTokenizer t = new StringTokenizer(line, "\ufeff\t");
        TracTicket.Key[] fields = new TracTicket.Key[t.countTokens()];
        int i = 0;
        while (i < fields.length) {
            fields[i] = TracTicket.Key.fromKey(t.nextToken());
            ++i;
        }
        return fields;
    }

    public List<TracTicket> getTickets() {
        return this.tickets;
    }

    public static String parseTicketValue(String value) {
        if ("--".equals(value)) {
            return null;
        }
        return value;
    }
}

