/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.sql;

import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.client.StatementExecutor;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.SequenceModel;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.schema.sql.SqlStringTypeInfo;
import com.google.gwtorm.schema.sql.SqlTimestampTypeInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;

public class DialectMySQL
extends SqlDialect {
    public DialectMySQL() {
        this.types.put(String.class, new SqlStringTypeInfo(){

            @Override
            public String getSqlType(ColumnModel col, SqlDialect dialect) {
                Column column = col.getColumnAnnotation();
                StringBuilder r = new StringBuilder();
                if (column.length() <= 0) {
                    r.append("VARCHAR(255)");
                    if (col.isNotNull()) {
                        r.append(" DEFAULT ''");
                    }
                } else if (column.length() <= 255) {
                    r.append("VARCHAR(" + column.length() + ")");
                    if (col.isNotNull()) {
                        r.append(" DEFAULT ''");
                    }
                } else {
                    r.append(dialect.getSqlTypeName(-1));
                }
                if (col.isNotNull()) {
                    r.append(" NOT NULL");
                }
                return r.toString();
            }
        });
        this.types.put(Timestamp.class, new SqlTimestampTypeInfo(){

            @Override
            public String getSqlType(ColumnModel col, SqlDialect dialect) {
                StringBuilder r = new StringBuilder();
                r.append(dialect.getSqlTypeName(this.getSqlTypeConstant()));
                if (col.isNotNull()) {
                    r.append(" NOT NULL");
                } else {
                    r.append(" NULL DEFAULT NULL");
                }
                return r.toString();
            }
        });
    }

    @Override
    public String getCreateSequenceSql(SequenceModel seq) {
        StringBuilder r = new StringBuilder();
        r.append("CREATE TABLE ");
        r.append(seq.getSequenceName());
        r.append("(s SERIAL)");
        return r.toString();
    }

    @Override
    public String getDropSequenceSql(String name) {
        return "DROP TABLE " + name;
    }

    @Override
    public String getNextSequenceValueSql(String seqname) {
        return seqname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextLong(Connection conn, String seqname) throws OrmException {
        long l;
        Statement st = conn.createStatement();
        try {
            long r;
            st.execute("INSERT INTO " + seqname + "(s)VALUES(NULL)", 1);
            ResultSet rs = st.getGeneratedKeys();
            try {
                if (!rs.next()) {
                    throw new SQLException("No result row for sequence query");
                }
                r = rs.getLong(1);
            }
            finally {
                rs.close();
            }
            st.execute("DELETE FROM " + seqname + " WHERE s=" + r);
            l = r;
        }
        catch (Throwable throwable) {
            try {
                st.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw this.convertError("sequence", seqname, e);
            }
        }
        st.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listTables(Connection db) throws SQLException {
        String[] types = new String[]{"TABLE"};
        ResultSet rs = db.getMetaData().getTables(null, null, null, types);
        try {
            HashSet<String> tables = new HashSet<String>();
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                if (this.isSequence(db, name)) continue;
                tables.add(name.toLowerCase());
            }
            HashSet<String> hashSet = tables;
            return hashSet;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listSequences(Connection db) throws SQLException {
        String[] types = new String[]{"TABLE"};
        ResultSet rs = db.getMetaData().getTables(null, null, null, types);
        try {
            HashSet<String> sequences = new HashSet<String>();
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                if (!this.isSequence(db, name)) continue;
                sequences.add(name.toLowerCase());
            }
            HashSet<String> hashSet = sequences;
            return hashSet;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSequence(Connection db, String tableName) throws SQLException {
        DatabaseMetaData meta = db.getMetaData();
        if (meta.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        } else if (meta.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        }
        ResultSet rs = meta.getColumns(null, null, tableName, null);
        try {
            int cnt = 0;
            boolean serial = false;
            while (rs.next()) {
                ++cnt;
                if (rs.getInt("DATA_TYPE") != -5 || !"YES".equalsIgnoreCase(rs.getString("IS_AUTOINCREMENT"))) continue;
                serial = true;
            }
            boolean bl = cnt == 1 && serial;
            return bl;
        }
        finally {
            rs.close();
        }
    }

    @Override
    public void renameColumn(StatementExecutor stmt, String tableName, String fromColumn, ColumnModel col) throws OrmException {
        StringBuffer r = new StringBuffer();
        r.append("ALTER TABLE ");
        r.append(tableName);
        r.append(" CHANGE ");
        r.append(fromColumn);
        r.append(" ");
        r.append(col.getColumnName());
        r.append(" ");
        r.append(this.getSqlTypeInfo(col).getSqlType(col, this));
        stmt.execute(r.toString());
    }
}

