/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.html.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.internal.wikitext.html.core.HtmlElementStrategy;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;

abstract class ElementStrategies<ElementType extends Enum<ElementType>, ElementStrategy, HtmlElementStrategyType extends HtmlElementStrategy<ElementType>> {
    private Map<ElementType, ElementStrategy> elementStrategyByElementType;
    private final List<HtmlElementStrategyType> elementStrategies;

    ElementStrategies(Class<ElementType> elementTypeClass, Set<ElementType> elementTypes, List<HtmlElementStrategyType> elementStrategies) {
        Preconditions.checkNotNull(elementTypeClass);
        Preconditions.checkNotNull(elementTypes);
        this.elementStrategies = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(elementStrategies)));
        this.initialize(elementTypeClass, elementTypes);
    }

    public ElementStrategy getStrategy(ElementType elementType, Attributes attributes) {
        Preconditions.checkNotNull(elementType);
        for (HtmlElementStrategy strategy : this.elementStrategies) {
            if (!strategy.matcher().matches(elementType, attributes)) continue;
            return this.getElementStrategy(strategy);
        }
        return (ElementStrategy)Preconditions.checkNotNull(this.elementStrategyByElementType.get(elementType));
    }

    abstract ElementStrategy getElementStrategy(HtmlElementStrategyType var1);

    private void initialize(Class<ElementType> elementTypeClass, Set<ElementType> elementTypes) {
        HashMap elementStrategyByElementType = Maps.newHashMap();
        for (Enum elementType : elementTypes) {
            this.addSupportedElementType(elementStrategyByElementType, elementType);
        }
        this.addImplicitElementTypes(elementStrategyByElementType, elementTypes);
        HashMap alternativesByElementType = Maps.newHashMap();
        for (Enum elementType : EnumSet.allOf(elementTypeClass)) {
            if (elementStrategyByElementType.containsKey(elementType)) continue;
            alternativesByElementType.put(elementType, this.calculateFallBackElementStrategy(elementStrategyByElementType, elementType));
        }
        elementStrategyByElementType.putAll(alternativesByElementType);
        this.elementStrategyByElementType = ImmutableMap.copyOf((Map)elementStrategyByElementType);
    }

    abstract void addImplicitElementTypes(Map<ElementType, ElementStrategy> var1, Set<ElementType> var2);

    void addSupportedElementType(Map<ElementType, ElementStrategy> elementStrategyByElementType, ElementType elementType) {
        elementStrategyByElementType.put(elementType, this.getSupportedStrategy(elementType));
    }

    abstract ElementStrategy getSupportedStrategy(ElementType var1);

    abstract ElementStrategy getUnsupportedElementStrategy(ElementType var1);

    abstract ElementStrategy createSubstitutionElementStrategy(ElementType var1);

    abstract Map<ElementType, List<ElementType>> getElementTypeToAlternatives();

    private ElementStrategy calculateFallBackElementStrategy(Map<ElementType, ElementStrategy> strategies, ElementType elementType) {
        ElementStrategy elementStrategy = null;
        List<ElementType> alternatives = this.getElementTypeToAlternatives().get(elementType);
        if (alternatives != null) {
            for (Enum alternative : alternatives) {
                if (!strategies.containsKey(alternative)) continue;
                elementStrategy = this.createSubstitutionElementStrategy(alternative);
                break;
            }
        }
        if (elementStrategy == null) {
            elementStrategy = this.getUnsupportedElementStrategy(elementType);
        }
        return elementStrategy;
    }
}

