/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tests;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.wikitext.tests.ClassFilter;
import org.eclipse.mylyn.wikitext.tests.ClassTraversal;
import org.eclipse.mylyn.wikitext.tests.NoDiscovery;

@NoDiscovery
public class DiscoveryTestSuite
extends TestSuite
implements ClassFilter {
    public DiscoveryTestSuite(ClassFilter filter) {
        this.discoverTests(filter);
    }

    protected void discoverTests(final ClassFilter filter) {
        new ClassTraversal().visitClasses(new ClassTraversal.Visitor(){

            @Override
            public void visit(Class<?> clazz) {
                if (!DiscoveryTestSuite.this.filter(clazz) && !filter.filter(clazz)) {
                    if (TestSuite.class.isAssignableFrom(clazz)) {
                        try {
                            Method suiteMethod = clazz.getMethod("suite", new Class[0]);
                            if (!Modifier.isStatic(suiteMethod.getModifiers()) || !Modifier.isPublic(suiteMethod.getModifiers())) {
                                throw new IllegalStateException(String.valueOf(clazz.getName()) + "#" + suiteMethod.getName());
                            }
                            DiscoveryTestSuite.this.addTest((Test)suiteMethod.invoke(null, new Object[0]));
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            try {
                                DiscoveryTestSuite.this.addTest((Test)clazz.newInstance());
                            }
                            catch (InstantiationException e1) {
                                throw new IllegalStateException(clazz.getName(), e1);
                            }
                            catch (IllegalAccessException e1) {
                                throw new IllegalStateException(clazz.getName(), e1);
                            }
                        }
                        catch (Throwable e) {
                            throw new IllegalStateException(clazz.getName(), e);
                        }
                    } else {
                        DiscoveryTestSuite.this.addTest((Test)new JUnit4TestAdapter(clazz));
                    }
                }
            }
        });
    }

    private boolean hasTestMethods(Class<?> clazz) {
        Class<?> c = clazz;
        while (c != null && c != Object.class) {
            Method[] methods = c.getDeclaredMethods();
            if (methods != null) {
                Method[] methodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    if (m.getAnnotation(org.junit.Test.class) != null) {
                        return true;
                    }
                    ++n2;
                }
            }
            c = c.getSuperclass();
        }
        return false;
    }

    public static boolean inEclipseRuntime() {
        return Platform.isRunning();
    }

    @Override
    public boolean filter(Class<?> clazz) {
        if (!Test.class.isAssignableFrom(clazz) && !this.hasTestMethods(clazz)) {
            return true;
        }
        if (DiscoveryTestSuite.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz.getAnnotation(NoDiscovery.class) != null) {
            return true;
        }
        int modifiers = clazz.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            return true;
        }
        return !Modifier.isPublic(modifiers);
    }
}

