/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.bugzilla.tests.AbstractBugzillaTest;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaTestSupportUtil;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaStatus;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.tasks.core.TaskAttachment;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class BugzillaAttachmentHandlerTest
extends AbstractBugzillaTest {
    public void testUpdateAttachmentFlags() throws Exception {
        TaskData taskData = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, "update of Attachment Flags", "description for testUpdateAttachmentFlags");
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        int numAttached = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").size();
        BugzillaAttachmentHandlerTest.assertEquals((int)0, (int)numAttached);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)this.repository.getCredentials(AuthenticationType.REPOSITORY));
        BugzillaAttachmentHandlerTest.assertNotNull((Object)this.repository.getCredentials(AuthenticationType.REPOSITORY).getUserName());
        BugzillaAttachmentHandlerTest.assertNotNull((Object)this.repository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
        BugzillaClient client = this.connector.getClientManager().getClient(this.repository, (IProgressMonitor)new NullProgressMonitor());
        TaskAttribute attrAttachment = taskData.getAttributeMapper().createTaskAttachment(taskData);
        TaskAttachmentMapper attachmentMapper = TaskAttachmentMapper.createFrom((TaskAttribute)attrAttachment);
        attachmentMapper.setComment("test Update AttachmentFlags");
        String fileName = "test-attach-1.txt";
        File attachFile = new File(fileName);
        attachFile.createNewFile();
        attachFile.deleteOnExit();
        BufferedWriter write = new BufferedWriter(new FileWriter(attachFile));
        write.write("test file from " + System.currentTimeMillis());
        write.close();
        FileTaskAttachmentSource attachment = new FileTaskAttachmentSource(attachFile);
        attachment.setContentType("text/plain");
        attachment.setDescription("Description");
        attachment.setName("My Attachment 1");
        client.postAttachment(taskData.getTaskId(), attachmentMapper.getComment(), (AbstractTaskAttachmentSource)attachment, attrAttachment, (IProgressMonitor)new NullProgressMonitor());
        taskData = BugzillaFixture.current().getTask(taskData.getTaskId(), client);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        numAttached = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").size();
        BugzillaAttachmentHandlerTest.assertEquals((int)1, (int)numAttached);
        TaskAttribute attachmentAttribute = (TaskAttribute)taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").get(0);
        int flagCount = 0;
        int flagCountUnused = 0;
        TaskAttribute attachmentFlag1 = null;
        TaskAttribute attachmentFlag2 = null;
        for (TaskAttribute attribute : attachmentAttribute.getAttributes().values()) {
            if (!attribute.getId().startsWith("task.common.kind.flag")) continue;
            ++flagCount;
            if (!attribute.getId().startsWith("task.common.kind.flag_type")) continue;
            ++flagCountUnused;
            TaskAttribute stateAttribute = taskData.getAttributeMapper().getAssoctiatedAttribute(attribute);
            if (stateAttribute.getMetaData().getLabel().equals("AttachmentFlag1")) {
                attachmentFlag1 = attribute;
            }
            if (!stateAttribute.getMetaData().getLabel().equals("AttachmentFlag2")) continue;
            attachmentFlag2 = attribute;
        }
        BugzillaAttachmentHandlerTest.assertEquals((int)2, (int)flagCount);
        BugzillaAttachmentHandlerTest.assertEquals((int)2, (int)flagCountUnused);
        BugzillaAttachmentHandlerTest.assertNotNull(attachmentFlag1);
        BugzillaAttachmentHandlerTest.assertNotNull(attachmentFlag2);
        TaskAttribute stateAttribute1 = taskData.getAttributeMapper().getAssoctiatedAttribute(attachmentFlag1);
        stateAttribute1.setValue("?");
        TaskAttribute requestee = attachmentFlag1.getAttribute("requestee");
        requestee.setValue("guest@mylyn.eclipse.org");
        client.postUpdateAttachment(attachmentAttribute, "update", null);
        taskData = BugzillaFixture.current().getTask(taskData.getTaskId(), client);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        attachmentAttribute = (TaskAttribute)taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").get(0);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)attachmentAttribute);
        flagCount = 0;
        flagCountUnused = 0;
        attachmentFlag1 = null;
        attachmentFlag2 = null;
        TaskAttribute attachmentFlag1used = null;
        TaskAttribute attachmentFlag2used = null;
        for (TaskAttribute attribute : attachmentAttribute.getAttributes().values()) {
            TaskAttribute stateAttribute;
            if (!attribute.getId().startsWith("task.common.kind.flag")) continue;
            ++flagCount;
            if (attribute.getId().startsWith("task.common.kind.flag_type")) {
                ++flagCountUnused;
                stateAttribute = taskData.getAttributeMapper().getAssoctiatedAttribute(attribute);
                if (stateAttribute.getMetaData().getLabel().equals("AttachmentFlag1")) {
                    attachmentFlag1 = attribute;
                }
                if (!stateAttribute.getMetaData().getLabel().equals("AttachmentFlag2")) continue;
                attachmentFlag2 = attribute;
                continue;
            }
            stateAttribute = taskData.getAttributeMapper().getAssoctiatedAttribute(attribute);
            if (stateAttribute.getMetaData().getLabel().equals("AttachmentFlag1")) {
                attachmentFlag1used = attribute;
            }
            if (!stateAttribute.getMetaData().getLabel().equals("AttachmentFlag2")) continue;
            attachmentFlag2used = attribute;
        }
        BugzillaAttachmentHandlerTest.assertEquals((int)3, (int)flagCount);
        BugzillaAttachmentHandlerTest.assertEquals((int)2, (int)flagCountUnused);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)attachmentFlag1);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)attachmentFlag2);
        BugzillaAttachmentHandlerTest.assertNotNull(attachmentFlag1used);
        BugzillaAttachmentHandlerTest.assertNull(attachmentFlag2used);
        TaskAttribute stateAttribute1used = taskData.getAttributeMapper().getAssoctiatedAttribute(attachmentFlag1used);
        TaskAttribute requesteeused = attachmentFlag1used.getAttribute("requestee");
        BugzillaAttachmentHandlerTest.assertNotNull((Object)stateAttribute1used);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)requesteeused);
        BugzillaAttachmentHandlerTest.assertEquals((String)"?", (String)stateAttribute1used.getValue());
        BugzillaAttachmentHandlerTest.assertEquals((String)"guest@mylyn.eclipse.org", (String)requesteeused.getValue());
        stateAttribute1used.setValue(" ");
        client.postUpdateAttachment(attachmentAttribute, "update", null);
        taskData = BugzillaFixture.current().getTask(taskData.getTaskId(), client);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        attachmentAttribute = (TaskAttribute)taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").get(0);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)attachmentAttribute);
        flagCount = 0;
        flagCountUnused = 0;
        attachmentFlag1 = null;
        attachmentFlag2 = null;
        attachmentFlag1used = null;
        attachmentFlag2used = null;
        for (TaskAttribute attribute : attachmentAttribute.getAttributes().values()) {
            TaskAttribute stateAttribute;
            if (!attribute.getId().startsWith("task.common.kind.flag")) continue;
            ++flagCount;
            if (attribute.getId().startsWith("task.common.kind.flag_type")) {
                ++flagCountUnused;
                stateAttribute = taskData.getAttributeMapper().getAssoctiatedAttribute(attribute);
                if (stateAttribute.getMetaData().getLabel().equals("AttachmentFlag1")) {
                    attachmentFlag1 = attribute;
                }
                if (!stateAttribute.getMetaData().getLabel().equals("AttachmentFlag2")) continue;
                attachmentFlag2 = attribute;
                continue;
            }
            stateAttribute = taskData.getAttributeMapper().getAssoctiatedAttribute(attribute);
            if (stateAttribute.getMetaData().getLabel().equals("AttachmentFlag1")) {
                attachmentFlag1used = attribute;
            }
            if (!stateAttribute.getMetaData().getLabel().equals("AttachmentFlag2")) continue;
            attachmentFlag2used = attribute;
        }
        BugzillaAttachmentHandlerTest.assertEquals((int)2, (int)flagCount);
        BugzillaAttachmentHandlerTest.assertEquals((int)2, (int)flagCountUnused);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)attachmentFlag1);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)attachmentFlag2);
        BugzillaAttachmentHandlerTest.assertNull((Object)attachmentFlag1used);
        BugzillaAttachmentHandlerTest.assertNull((Object)attachmentFlag2used);
    }

    public void testAttachToExistingReport() throws Exception {
        TaskData taskData = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        int numAttached = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").size();
        BugzillaAttachmentHandlerTest.assertNotNull((Object)this.repository.getCredentials(AuthenticationType.REPOSITORY));
        BugzillaAttachmentHandlerTest.assertNotNull((Object)this.repository.getCredentials(AuthenticationType.REPOSITORY).getUserName());
        BugzillaAttachmentHandlerTest.assertNotNull((Object)this.repository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
        BugzillaClient client = this.connector.getClientManager().getClient(this.repository, (IProgressMonitor)new NullProgressMonitor());
        TaskAttribute attrAttachment = taskData.getAttributeMapper().createTaskAttachment(taskData);
        TaskAttachmentMapper attachmentMapper = TaskAttachmentMapper.createFrom((TaskAttribute)attrAttachment);
        attachmentMapper.setDescription("Test attachment " + new Date());
        attachmentMapper.setContentType("text/plain");
        attachmentMapper.setPatch(Boolean.valueOf(false));
        attachmentMapper.setComment("Automated JUnit attachment test");
        attachmentMapper.applyTo(attrAttachment);
        String filePath = "/this/is/not/a/real-file";
        FileTaskAttachmentSource attachment = new FileTaskAttachmentSource(new File(filePath));
        attachment.setContentType("application/octet-stream");
        attachment.setDescription("mylyn/context/zip");
        attachment.setName("mylyn-context.zip");
        try {
            client.postAttachment(taskData.getTaskId(), attachmentMapper.getComment(), (AbstractTaskAttachmentSource)attachment, attrAttachment, (IProgressMonitor)new NullProgressMonitor());
            BugzillaAttachmentHandlerTest.fail((String)"never reach this!");
        }
        catch (Exception e) {
            this.assertFileEmptyError(e);
        }
        taskData = BugzillaFixture.current().getTask(taskData.getTaskId(), client);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        BugzillaAttachmentHandlerTest.assertEquals((int)numAttached, (int)taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").size());
        String fileName = "test-attach-" + System.currentTimeMillis() + ".txt";
        File attachFile = new File(fileName);
        attachFile.createNewFile();
        attachFile.deleteOnExit();
        BufferedWriter write = new BufferedWriter(new FileWriter(attachFile));
        attachment = new FileTaskAttachmentSource(attachFile);
        attachment.setContentType("application/octet-stream");
        attachment.setDescription("mylyn/context/zip");
        attachment.setName("mylyn-context.zip");
        try {
            client.postAttachment(taskData.getTaskId(), attachmentMapper.getComment(), (AbstractTaskAttachmentSource)attachment, attrAttachment, (IProgressMonitor)new NullProgressMonitor());
            BugzillaAttachmentHandlerTest.fail((String)"never reach this!");
        }
        catch (Exception e) {
            this.assertFileEmptyError(e);
        }
        taskData = BugzillaFixture.current().getTask(taskData.getTaskId(), client);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        BugzillaAttachmentHandlerTest.assertEquals((int)numAttached, (int)taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").size());
        write.write("test file");
        write.close();
        client.postAttachment(taskData.getTaskId(), attachmentMapper.getComment(), (AbstractTaskAttachmentSource)attachment, attrAttachment, (IProgressMonitor)new NullProgressMonitor());
        taskData = BugzillaFixture.current().getTask(taskData.getTaskId(), client);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        BugzillaAttachmentHandlerTest.assertEquals((int)(numAttached + 1), (int)taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").size());
        BugzillaAttachmentHandlerTest.assertTrue((boolean)attachFile.delete());
    }

    public void testAttachmentWithUnicode() throws Exception {
        this.testAttachmentWithSpecialCharacters("\u00e7\u00f1\u00a5\u20ac\u00a3\u00bd\u00bc\u03b2\u03b8\u53f0\u5317\u3096\u3097\uff73");
    }

    public void testAttachmentWithSpecialCharacters() throws Exception {
        this.testAttachmentWithSpecialCharacters("~`!@#$%^&()_-+={[}];',");
    }

    private void testAttachmentWithSpecialCharacters(String specialCharacters) throws Exception {
        TaskData taskData = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        TaskAttribute attachmentAttr = taskData.getAttributeMapper().createTaskAttachment(taskData);
        TaskAttachmentMapper attachmentMapper = TaskAttachmentMapper.createFrom((TaskAttribute)attachmentAttr);
        String description = "Test attachment " + specialCharacters + System.currentTimeMillis();
        attachmentMapper.setDescription(description);
        attachmentMapper.setContentType("text/plain");
        attachmentMapper.setPatch(Boolean.valueOf(false));
        attachmentMapper.applyTo(attachmentAttr);
        String filename = "test" + specialCharacters + System.currentTimeMillis() + ".txt";
        File attachFile = new File(filename);
        attachFile.createNewFile();
        attachFile.deleteOnExit();
        BufferedWriter write = new BufferedWriter(new FileWriter(attachFile));
        write.write("test file content");
        write.close();
        FileTaskAttachmentSource attachment = new FileTaskAttachmentSource(attachFile);
        attachment.setContentType("text/plain");
        attachment.setDescription(description);
        attachment.setName(filename);
        this.client.postAttachment(taskData.getTaskId(), attachmentMapper.getComment(), (AbstractTaskAttachmentSource)attachment, attachmentAttr, (IProgressMonitor)new NullProgressMonitor());
        taskData = BugzillaFixture.current().getTask(taskData.getTaskId(), this.client);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        List attachmentAttrs = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment");
        BugzillaAttachmentHandlerTest.assertEquals((int)1, (int)attachmentAttrs.size());
        attachmentMapper = TaskAttachmentMapper.createFrom((TaskAttribute)((TaskAttribute)attachmentAttrs.get(0)));
        BugzillaAttachmentHandlerTest.assertEquals((String)description, (String)attachmentMapper.getDescription());
        BugzillaAttachmentHandlerTest.assertEquals((String)filename, (String)attachmentMapper.getFileName());
        BugzillaAttachmentHandlerTest.assertEquals((String)"text/plain", (String)attachmentMapper.getContentType());
        BugzillaAttachmentHandlerTest.assertEquals((Object)Boolean.FALSE, (Object)attachmentMapper.isPatch());
        BugzillaAttachmentHandlerTest.assertTrue((boolean)attachFile.delete());
    }

    private void assertFileEmptyError(Exception e) {
        if (BugzillaFixture.current().getBugzillaVersion().compareTo(BugzillaVersion.BUGZILLA_4_5_2) >= 0) {
            BugzillaAttachmentHandlerTest.assertEquals((String)"An unknown repository error has occurred: file is empty", (String)e.getMessage());
        } else {
            BugzillaAttachmentHandlerTest.assertEquals((String)"file is empty:  The file you are trying to attach is empty, does not exist, or you don't have permission to read it.", (String)e.getMessage());
        }
    }

    public void testAttachmentToken() throws Exception {
        TaskData taskData = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        this.doAttachment(taskData);
        taskData = BugzillaFixture.current().getTask(taskData.getTaskId(), this.client);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        TaskAttribute attachment = (TaskAttribute)taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").get(0);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)attachment);
        TaskAttribute obsolete = attachment.getMappedAttribute("task.common.attachment.deprecated");
        BugzillaAttachmentHandlerTest.assertNotNull((Object)obsolete);
        TaskAttribute token = attachment.getAttribute(BugzillaAttribute.TOKEN.getKey());
        BugzillaAttachmentHandlerTest.assertNotNull((Object)token);
        attachment.removeAttribute(BugzillaAttribute.TOKEN.getKey());
        token = attachment.getAttribute(BugzillaAttribute.TOKEN.getKey());
        BugzillaAttachmentHandlerTest.assertNull((Object)token);
        boolean oldObsoleteOn = obsolete.getValue().equals("1");
        if (oldObsoleteOn) {
            obsolete.setValue("0");
        } else {
            obsolete.setValue("1");
        }
        try {
            ((BugzillaTaskDataHandler)this.connector.getTaskDataHandler()).postUpdateAttachment(this.repository, attachment, "update", (IProgressMonitor)new NullProgressMonitor());
            BugzillaAttachmentHandlerTest.fail((String)"CoreException expected but not reached");
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            BugzillaAttachmentHandlerTest.assertTrue((boolean)(status instanceof BugzillaStatus));
            BugzillaAttachmentHandlerTest.assertEquals((int)99, (int)status.getCode());
        }
        taskData = BugzillaFixture.current().getTask(taskData.getTaskId(), this.client);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        attachment = (TaskAttribute)taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").get(0);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)attachment);
        obsolete = attachment.getMappedAttribute("task.common.attachment.deprecated");
        BugzillaAttachmentHandlerTest.assertNotNull((Object)obsolete);
        token = attachment.getAttribute(BugzillaAttribute.TOKEN.getKey());
        BugzillaAttachmentHandlerTest.assertNotNull((Object)token);
        oldObsoleteOn = obsolete.getValue().equals("1");
        if (oldObsoleteOn) {
            obsolete.setValue("0");
        } else {
            obsolete.setValue("1");
        }
        ((BugzillaTaskDataHandler)this.connector.getTaskDataHandler()).postUpdateAttachment(this.repository, attachment, "update", (IProgressMonitor)new NullProgressMonitor());
    }

    private void doAttachment(TaskData taskData) throws Exception {
        TaskAttribute attrAttachment = taskData.getAttributeMapper().createTaskAttachment(taskData);
        TaskAttachmentMapper attachmentMapper = TaskAttachmentMapper.createFrom((TaskAttribute)attrAttachment);
        attachmentMapper.setDescription("Test attachment " + new Date());
        attachmentMapper.setContentType("text/plain");
        attachmentMapper.setPatch(Boolean.valueOf(false));
        attachmentMapper.setComment("Automated JUnit attachment test");
        attachmentMapper.applyTo(attrAttachment);
        String fileName = "test-attach-" + System.currentTimeMillis() + ".txt";
        File attachFile = new File(fileName);
        attachFile.createNewFile();
        attachFile.deleteOnExit();
        BufferedWriter write = new BufferedWriter(new FileWriter(attachFile));
        write.write("test file");
        write.close();
        FileTaskAttachmentSource attachment = new FileTaskAttachmentSource(attachFile);
        attachment.setContentType("application/octet-stream");
        attachment.setDescription("mylyn/context/zip");
        attachment.setName("mylyn-context.zip");
        this.client.postAttachment(taskData.getTaskId(), attachmentMapper.getComment(), (AbstractTaskAttachmentSource)attachment, attrAttachment, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testObsoleteAttachment() throws Exception {
        TaskData taskData = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        this.doAttachment(taskData);
        taskData = BugzillaFixture.current().getTask(taskData.getTaskId(), this.client);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        TaskAttribute attachment = (TaskAttribute)taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").get(0);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)attachment);
        TaskAttribute obsolete = attachment.getMappedAttribute("task.common.attachment.deprecated");
        BugzillaAttachmentHandlerTest.assertNotNull((Object)obsolete);
        boolean oldObsoleteOn = obsolete.getValue().equals("1");
        if (oldObsoleteOn) {
            obsolete.setValue("0");
        } else {
            obsolete.setValue("1");
        }
        ((BugzillaTaskDataHandler)this.connector.getTaskDataHandler()).postUpdateAttachment(this.repository, attachment, "update", (IProgressMonitor)new NullProgressMonitor());
        taskData = BugzillaFixture.current().getTask(taskData.getTaskId(), this.client);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        attachment = (TaskAttribute)taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").get(0);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)attachment);
        obsolete = attachment.getMappedAttribute("task.common.attachment.deprecated");
        BugzillaAttachmentHandlerTest.assertNotNull((Object)obsolete);
        boolean newObsoleteOn = obsolete.getValue().equals("1");
        BugzillaAttachmentHandlerTest.assertEquals((boolean)true, (boolean)(oldObsoleteOn ^ newObsoleteOn));
    }

    public void testAttachmentAttributes() throws Exception {
        String taskId = this.harness.taskAttachmentAttributesExists();
        if (taskId == null) {
            taskId = this.harness.createAttachmentAttributesTask();
        }
        String taskNumber = taskId;
        TaskData taskData = BugzillaFixture.current().getTask(taskNumber, this.client);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        ITask task = TasksUi.getRepositoryModel().createTask(this.repository, taskData.getTaskId());
        boolean[] blArray = new boolean[4];
        blArray[2] = true;
        blArray[3] = true;
        boolean[] isPatch = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[1] = true;
        blArray2[3] = true;
        boolean[] isObsolete = blArray2;
        int index = 0;
        for (TaskAttribute attribute : taskData.getAttributeMapper().getAttributesByType(taskData, "attachment")) {
            BugzillaAttachmentHandlerTest.assertTrue((boolean)this.validateAttachmentAttributes(taskData, attribute, isPatch[index], isObsolete[index], task));
            ++index;
        }
        BugzillaAttachmentHandlerTest.assertEquals((int)4, (int)index);
    }

    private boolean validateAttachmentAttributes(TaskData data, TaskAttribute taskAttribute, boolean isPatch, boolean isObsolete, ITask task) {
        TaskAttachment taskAttachment = new TaskAttachment(BugzillaFixture.current().repository(), task, taskAttribute);
        data.getAttributeMapper().updateTaskAttachment((ITaskAttachment)taskAttachment, taskAttribute);
        return taskAttachment.isPatch() == isPatch && taskAttachment.isDeprecated() == isObsolete;
    }

    public void testContextAttachFailure() throws Exception {
        this.repository = this.client.getTaskRepository();
        TaskData taskData = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        ITask task = TasksUi.getRepositoryModel().createTask(this.repository, taskData.getTaskId());
        TasksUiPlugin.getTaskList().addTask(task);
        TasksUi.getTaskActivityManager().activateTask(task);
        File sourceContextFile = TasksUiPlugin.getContextStore().getFileForContext(task);
        sourceContextFile.createNewFile();
        sourceContextFile.deleteOnExit();
        this.repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("wrong", "wrong"), false);
        try {
            FileTaskAttachmentSource attachment = new FileTaskAttachmentSource(sourceContextFile);
            attachment.setContentType("application/octet-stream");
            attachment.setDescription("mylyn/context/zip");
            attachment.setName("mylyn-context.zip");
            TaskAttribute attrAttachment = taskData.getAttributeMapper().createTaskAttachment(taskData);
            TaskAttachmentMapper attachmentMapper = TaskAttachmentMapper.createFrom((TaskAttribute)attrAttachment);
            attachmentMapper.setDescription("Test attachment " + new Date());
            attachmentMapper.setContentType("mylyn/context/zip");
            attachmentMapper.setPatch(Boolean.valueOf(false));
            attachmentMapper.setComment("Context attachment failure Test");
            attachmentMapper.applyTo(attrAttachment);
            this.connector.getTaskAttachmentHandler().postContent(this.repository, task, (AbstractTaskAttachmentSource)attachment, attachmentMapper.getComment(), attrAttachment, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            BugzillaAttachmentHandlerTest.assertTrue((boolean)BugzillaTestSupportUtil.isInvalidLogon(e));
            BugzillaAttachmentHandlerTest.assertEquals((Object)ITask.SynchronizationState.SYNCHRONIZED, (Object)task.getSynchronizationState());
            return;
        }
        BugzillaAttachmentHandlerTest.fail((String)"Should have failed due to invalid userid and password.");
    }

    public void testDownloadAttachmentFile() throws Exception {
        TaskData taskData = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, "update of Attachment Flags", "description for testUpdateAttachmentFlags");
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        int numAttached = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").size();
        BugzillaAttachmentHandlerTest.assertEquals((int)0, (int)numAttached);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)this.repository.getCredentials(AuthenticationType.REPOSITORY));
        BugzillaAttachmentHandlerTest.assertNotNull((Object)this.repository.getCredentials(AuthenticationType.REPOSITORY).getUserName());
        BugzillaAttachmentHandlerTest.assertNotNull((Object)this.repository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
        BugzillaClient client = this.connector.getClientManager().getClient(this.repository, (IProgressMonitor)new NullProgressMonitor());
        TaskAttribute attrAttachment = taskData.getAttributeMapper().createTaskAttachment(taskData);
        TaskAttachmentMapper attachmentMapper = TaskAttachmentMapper.createFrom((TaskAttribute)attrAttachment);
        attachmentMapper.setComment("test Update AttachmentFlags");
        String fileName = "test-attach-1.txt";
        File attachFile = new File(fileName);
        attachFile.createNewFile();
        attachFile.deleteOnExit();
        BufferedWriter write = new BufferedWriter(new FileWriter(attachFile));
        String expected = "test file from " + System.currentTimeMillis();
        write.write(expected);
        write.close();
        FileTaskAttachmentSource attachment = new FileTaskAttachmentSource(attachFile);
        attachment.setContentType("text/plain");
        attachment.setDescription("Description");
        attachment.setName("My Attachment 1");
        client.postAttachment(taskData.getTaskId(), attachmentMapper.getComment(), (AbstractTaskAttachmentSource)attachment, attrAttachment, (IProgressMonitor)new NullProgressMonitor());
        taskData = BugzillaFixture.current().getTask(taskData.getTaskId(), client);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        numAttached = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").size();
        BugzillaAttachmentHandlerTest.assertEquals((int)1, (int)numAttached);
        TaskAttribute attachmentAttribute = (TaskAttribute)taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").get(0);
        File file = File.createTempFile("mylyn", null);
        TaskTask iTask = new TaskTask(this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), taskData.getTaskId());
        TaskAttachment taskAttachment = new TaskAttachment(this.repository, (ITask)iTask, attachmentAttribute);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            AttachmentUtil.downloadAttachment((ITaskAttachment)taskAttachment, (OutputStream)out, (IProgressMonitor)new NullProgressMonitor());
        }
        FileInputStream raf = new FileInputStream(file);
        byte[] data = new byte[expected.length()];
        try {
            raf.read(data);
        }
        finally {
            raf.close();
            file.delete();
        }
        BugzillaAttachmentHandlerTest.assertEquals((String)expected, (String)new String(data));
    }

    public void testDownloadNonExsistingAttachmentFile() throws Exception {
        TaskData taskData = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, "update of Attachment Flags", "description for testUpdateAttachmentFlags");
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        int numAttached = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").size();
        BugzillaAttachmentHandlerTest.assertEquals((int)0, (int)numAttached);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)this.repository.getCredentials(AuthenticationType.REPOSITORY));
        BugzillaAttachmentHandlerTest.assertNotNull((Object)this.repository.getCredentials(AuthenticationType.REPOSITORY).getUserName());
        BugzillaAttachmentHandlerTest.assertNotNull((Object)this.repository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
        BugzillaClient client = this.connector.getClientManager().getClient(this.repository, (IProgressMonitor)new NullProgressMonitor());
        TaskAttribute attrAttachment = taskData.getAttributeMapper().createTaskAttachment(taskData);
        TaskAttachmentMapper attachmentMapper = TaskAttachmentMapper.createFrom((TaskAttribute)attrAttachment);
        attachmentMapper.setComment("test Update AttachmentFlags");
        String fileName = "test-attach-1.txt";
        File attachFile = new File(fileName);
        attachFile.createNewFile();
        attachFile.deleteOnExit();
        BufferedWriter write = new BufferedWriter(new FileWriter(attachFile));
        String expected = "test file from " + System.currentTimeMillis();
        write.write(expected);
        write.close();
        FileTaskAttachmentSource attachment = new FileTaskAttachmentSource(attachFile);
        attachment.setContentType("text/plain");
        attachment.setDescription("Description");
        attachment.setName("My Attachment 1");
        client.postAttachment(taskData.getTaskId(), attachmentMapper.getComment(), (AbstractTaskAttachmentSource)attachment, attrAttachment, (IProgressMonitor)new NullProgressMonitor());
        taskData = BugzillaFixture.current().getTask(taskData.getTaskId(), client);
        BugzillaAttachmentHandlerTest.assertNotNull((Object)taskData);
        numAttached = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").size();
        BugzillaAttachmentHandlerTest.assertEquals((int)1, (int)numAttached);
        TaskAttribute attachmentAttribute = (TaskAttribute)taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").get(0);
        attachmentAttribute.setValue("99999999");
        File file = File.createTempFile("mylyn", null);
        TaskTask iTask = new TaskTask(this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), taskData.getTaskId());
        TaskAttachment taskAttachment = new TaskAttachment(this.repository, (ITask)iTask, attachmentAttribute);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            try {
                AttachmentUtil.downloadAttachment((ITaskAttachment)taskAttachment, (OutputStream)out, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                String message = e.getMessage();
                BugzillaAttachmentHandlerTest.assertTrue((boolean)message.startsWith("invalid attachment id: "));
                ((OutputStream)out).close();
            }
        }
    }
}

