/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.bugzilla.tests.AbstractBugzillaTest;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaHarness;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.internal.bugzilla.core.AbstractBugzillaOperation;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttributeMapper;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.bugzilla.core.CustomTransitionManager;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.core.service.BugzillaXmlRpcClient;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.core.sync.SubmitJob;

public class BugzillaXmlRpcClientTest
extends AbstractBugzillaTest {
    private static final String BUGZILLA_LE_4_0 = "<4.0";
    private static final String BUGZILLA_GE_4_0 = ">=4.0";
    private BugzillaXmlRpcClient bugzillaClient;
    private final Map<String, Map<String, ArrayList<String>>> fixtureTransitionsMap = new HashMap<String, Map<String, ArrayList<String>>>(){
        {
            this.put(BugzillaXmlRpcClientTest.BUGZILLA_LE_4_0, new HashMap<String, ArrayList<String>>(){
                {
                    this.put("NEW", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("accept");
                            this.add("duplicate");
                        }
                    });
                    this.put("UNCONFIRMED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("accept");
                            this.add("duplicate");
                            this.add("markNew");
                        }
                    });
                    this.put("ASSIGNED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("duplicate");
                            this.add("markNew");
                        }
                    });
                    this.put("REOPENED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("accept");
                            this.add("duplicate");
                            this.add("markNew");
                        }
                    });
                    this.put("RESOLVED", new ArrayList<String>(){
                        {
                            this.add("verify");
                            this.add("reopen");
                            this.add("close");
                        }
                    });
                    this.put("VERIFIED", new ArrayList<String>(){
                        {
                            this.add("reopen");
                            this.add("resolve");
                            this.add("duplicate");
                            this.add("close");
                        }
                    });
                    this.put("CLOSED", new ArrayList<String>(){
                        {
                            this.add("reopen");
                            this.add("resolve");
                            this.add("duplicate");
                        }
                    });
                }
            });
            this.put(BugzillaXmlRpcClientTest.BUGZILLA_GE_4_0, new HashMap<String, ArrayList<String>>(){
                {
                    this.put("UNCONFIRMED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("CONFIRMED");
                            this.add("duplicate");
                            this.add("IN_PROGRESS");
                        }
                    });
                    this.put("IN_PROGRESS", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("duplicate");
                            this.add("CONFIRMED");
                        }
                    });
                    this.put("CONFIRMED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("duplicate");
                            this.add("IN_PROGRESS");
                        }
                    });
                    this.put("RESOLVED", new ArrayList<String>(){
                        {
                            this.add("verify");
                            this.add("unconfirmed");
                            this.add("CONFIRMED");
                        }
                    });
                    this.put("VERIFIED", new ArrayList<String>(){
                        {
                            this.add("unconfirmed");
                            this.add("CONFIRMED");
                        }
                    });
                }
            });
            this.put("Custom Workflow", new HashMap<String, ArrayList<String>>(){
                {
                    this.put("UNCONFIRMED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("CONFIRMED");
                            this.add("IN_PROGRESS");
                            this.add("duplicate");
                        }
                    });
                    this.put("CONFIRMED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("verify");
                            this.add("IN_PROGRESS");
                            this.add("duplicate");
                        }
                    });
                    this.put("IN_PROGRESS", new ArrayList<String>(){
                        {
                            this.add("unconfirmed");
                            this.add("resolve");
                            this.add("duplicate");
                        }
                    });
                    this.put("RESOLVED", new ArrayList<String>(){
                        {
                            this.add("unconfirmed");
                            this.add("CONFIRMED");
                            this.add("verify");
                        }
                    });
                    this.put("VERIFIED", new ArrayList<String>(){
                        {
                            this.add("unconfirmed");
                            this.add("CONFIRMED");
                            this.add("resolve");
                        }
                    });
                }
            });
            this.put("Custom Workflow and Status", new HashMap<String, ArrayList<String>>(){
                {
                    this.put("UNCONFIRMED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("CONFIRMED");
                            this.add("IN_PROGRESS");
                            this.add("duplicate");
                            this.add("verify");
                        }
                    });
                    this.put("CONFIRMED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("verify");
                            this.add("IN_PROGRESS");
                            this.add("duplicate");
                        }
                    });
                    this.put("IN_PROGRESS", new ArrayList<String>(){
                        {
                            this.add("CONFIRMED");
                            this.add("resolve");
                            this.add("duplicate");
                            this.add("verify");
                        }
                    });
                    this.put("RESOLVED", new ArrayList<String>(){
                        {
                            this.add("unconfirmed");
                            this.add("CONFIRMED");
                            this.add("verify");
                        }
                    });
                    this.put("VERIFIED", new ArrayList<String>(){
                        {
                            this.add("MODIFIED");
                            this.add("CONFIRMED");
                        }
                    });
                    this.put("ON_DEV", new ArrayList<String>(){
                        {
                            this.add("verify");
                            this.add("POST");
                        }
                    });
                    this.put("POST", new ArrayList<String>(){
                        {
                            this.add("verify");
                        }
                    });
                    this.put("MODIFIED", new ArrayList<String>(){
                        {
                            this.add("verify");
                            this.add("ON_DEV");
                        }
                    });
                }
            });
        }
    };
    private BugzillaHarness harness;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.harness = BugzillaFixture.current().createHarness();
        WebLocation webLocation = new WebLocation(String.valueOf(BugzillaFixture.current().getRepositoryUrl()) + "/xmlrpc.cgi");
        webLocation.setCredentials(AuthenticationType.REPOSITORY, "tests@mylyn.eclipse.org", "mylyntest");
        this.bugzillaClient = new BugzillaXmlRpcClient((AbstractWebLocation)webLocation, this.client);
        this.bugzillaClient.setContentTypeCheckingEnabled(true);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected ITaskDataWorkingCopy getWorkingCopy(ITask task) throws CoreException {
        return TasksUiPlugin.getTaskDataManager().getWorkingCopy(task);
    }

    @Override
    protected void submit(TaskDataModel model) {
        SubmitJob submitJob = TasksUiInternal.getJobFactory().createSubmitTaskJob((AbstractRepositoryConnector)this.connector, model.getTaskRepository(), model.getTask(), model.getTaskData(), model.getChangedOldAttributes());
        submitJob.schedule();
        try {
            submitJob.join();
        }
        catch (InterruptedException e) {
            BugzillaXmlRpcClientTest.fail((String)e.getMessage());
        }
    }

    public void testGetVersion() throws Exception {
        if (!BugzillaFixture.current().isXmlRpcEnabled()) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        String version = this.bugzillaClient.getVersion((IProgressMonitor)monitor);
        BugzillaXmlRpcClientTest.assertEquals((int)0, (int)new BugzillaVersion(BugzillaFixture.current().getVersion()).compareMajorMinorOnly(new BugzillaVersion(version)));
    }

    public void testUserInfo() throws Exception {
        if (!BugzillaFixture.current().isXmlRpcEnabled()) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        BugzillaVersion version = BugzillaFixture.current().getBugzillaVersion();
        this.bugzillaClient.logout((IProgressMonitor)monitor);
        int uID = this.bugzillaClient.login((IProgressMonitor)monitor);
        BugzillaXmlRpcClientTest.assertEquals((int)2, (int)uID);
        Object[] userList0 = this.bugzillaClient.getUserInfoFromIDs((IProgressMonitor)monitor, new Integer[]{1, 2});
        BugzillaXmlRpcClientTest.assertNotNull((Object)userList0);
        BugzillaXmlRpcClientTest.assertEquals((int)2, (int)userList0.length);
        BugzillaXmlRpcClientTest.assertEquals((Object)1, ((HashMap)userList0[0]).get("id"));
        if (BugzillaFixture.current().isBugzilla51OrGreater()) {
            BugzillaXmlRpcClientTest.assertEquals((String)"admin@mylyn.eclipse.org", (String)((String)((HashMap)userList0[0]).get("email")));
        }
        BugzillaXmlRpcClientTest.assertEquals((String)"admin@mylyn.eclipse.org", (String)((String)((HashMap)userList0[0]).get("name")));
        BugzillaXmlRpcClientTest.assertEquals((String)"Mylyn Admin", (String)((String)((HashMap)userList0[0]).get("real_name")));
        BugzillaXmlRpcClientTest.assertEquals((Object)true, ((HashMap)userList0[0]).get("can_login"));
        BugzillaXmlRpcClientTest.assertEquals((Object)2, ((HashMap)userList0[1]).get("id"));
        if (BugzillaFixture.current().isBugzilla51OrGreater()) {
            BugzillaXmlRpcClientTest.assertEquals((String)"tests@mylyn.eclipse.org", (String)((String)((HashMap)userList0[1]).get("email")));
        }
        BugzillaXmlRpcClientTest.assertEquals((String)"tests@mylyn.eclipse.org", (String)((String)((HashMap)userList0[1]).get("name")));
        BugzillaXmlRpcClientTest.assertEquals((String)"Mylyn Test", (String)((String)((HashMap)userList0[1]).get("real_name")));
        BugzillaXmlRpcClientTest.assertEquals((Object)true, ((HashMap)userList0[1]).get("can_login"));
        Object[] userList1 = this.bugzillaClient.getUserInfoFromNames((IProgressMonitor)monitor, new String[]{"tests@mylyn.eclipse.org"});
        BugzillaXmlRpcClientTest.assertNotNull((Object)userList1);
        BugzillaXmlRpcClientTest.assertEquals((int)1, (int)userList1.length);
        BugzillaXmlRpcClientTest.assertEquals((Object)2, ((HashMap)userList1[0]).get("id"));
        if (version.compareTo(BugzillaVersion.BUGZILLA_5_1) < 0) {
            BugzillaXmlRpcClientTest.assertEquals((String)"tests@mylyn.eclipse.org", (String)((String)((HashMap)userList1[0]).get("email")));
        }
        BugzillaXmlRpcClientTest.assertEquals((String)"tests@mylyn.eclipse.org", (String)((String)((HashMap)userList1[0]).get("name")));
        BugzillaXmlRpcClientTest.assertEquals((String)"Mylyn Test", (String)((String)((HashMap)userList1[0]).get("real_name")));
        BugzillaXmlRpcClientTest.assertEquals((Object)true, ((HashMap)userList1[0]).get("can_login"));
    }

    public void testProductInfo() throws Exception {
        if (!BugzillaFixture.current().isXmlRpcEnabled()) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        int uID = this.bugzillaClient.login((IProgressMonitor)monitor);
        BugzillaXmlRpcClientTest.assertEquals((int)2, (int)uID);
        Object[] selProductIDs = this.bugzillaClient.getSelectableProducts((IProgressMonitor)monitor);
        BugzillaXmlRpcClientTest.assertNotNull((Object)selProductIDs);
        BugzillaXmlRpcClientTest.assertEquals((int)3, (int)selProductIDs.length);
        Object[] enterProductIDs = this.bugzillaClient.getEnterableProducts((IProgressMonitor)monitor);
        BugzillaXmlRpcClientTest.assertNotNull((Object)enterProductIDs);
        BugzillaXmlRpcClientTest.assertEquals((int)3, (int)enterProductIDs.length);
        Object[] accessibleProductIDs = this.bugzillaClient.getAccessibleProducts((IProgressMonitor)monitor);
        BugzillaXmlRpcClientTest.assertNotNull((Object)accessibleProductIDs);
        BugzillaXmlRpcClientTest.assertEquals((int)3, (int)accessibleProductIDs.length);
        Object[] productDetails = this.bugzillaClient.getProducts((IProgressMonitor)monitor, (Object[])new Integer[]{1, 3});
        BugzillaXmlRpcClientTest.assertNotNull((Object)productDetails);
        BugzillaXmlRpcClientTest.assertEquals((int)2, (int)productDetails.length);
        BugzillaXmlRpcClientTest.assertTrue(((Integer)((HashMap)productDetails[0]).get("id") == 1 || (Integer)((HashMap)productDetails[1]).get("id") == 1 ? 1 : 0) != 0);
        BugzillaXmlRpcClientTest.assertTrue(((Integer)((HashMap)productDetails[0]).get("id") == 3 || (Integer)((HashMap)productDetails[1]).get("id") == 3 ? 1 : 0) != 0);
        int idx = (Integer)((HashMap)productDetails[0]).get("id") == 1 ? 0 : 1;
        BugzillaXmlRpcClientTest.assertEquals((Object)1, ((HashMap)productDetails[idx]).get("id"));
        BugzillaXmlRpcClientTest.assertEquals((String)"This is a test product. This ought to be blown away and replaced with real stuff in a finished installation of bugzilla.", (String)((String)((HashMap)productDetails[idx]).get("description")));
        idx = (idx + 1) % 2;
        BugzillaXmlRpcClientTest.assertEquals((Object)3, ((HashMap)productDetails[idx]).get("id"));
        BugzillaXmlRpcClientTest.assertEquals((String)"Product for manual testing", (String)((String)((HashMap)productDetails[idx]).get("description")));
    }

    public void testXmlRpcInstalled() throws Exception {
        int uID = -1;
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (!BugzillaFixture.current().isXmlRpcEnabled()) {
            try {
                uID = this.bugzillaClient.login((IProgressMonitor)monitor);
                BugzillaXmlRpcClientTest.fail((String)"Never reach this! We should get an XmlRpcException");
            }
            catch (XmlRpcException e) {
                BugzillaXmlRpcClientTest.assertEquals((String)"The server returned an unexpected content type: 'text/html; charset=UTF-8'", (String)e.getMessage());
            }
        } else {
            uID = this.bugzillaClient.login((IProgressMonitor)monitor);
            BugzillaXmlRpcClientTest.assertEquals((int)2, (int)uID);
        }
    }

    public void testTransitionManagerWithXml() throws Exception {
        if (BugzillaFixture.current().getBugzillaVersion().isSmaller(BugzillaVersion.BUGZILLA_3_6)) {
            return;
        }
        if (!BugzillaFixture.current().isXmlRpcEnabled()) {
            return;
        }
        CustomTransitionManager ctm = new CustomTransitionManager();
        ctm.parse((IProgressMonitor)new NullProgressMonitor(), this.bugzillaClient);
        ArrayList<String> transitions = new ArrayList<String>();
        Map<String, ArrayList<String>> expectTransitions = BugzillaFixture.current().isCustomWorkflow() ? this.fixtureTransitionsMap.get("Custom Workflow") : (BugzillaFixture.current().isCustomWorkflowAndStatus() ? this.fixtureTransitionsMap.get("Custom Workflow and Status") : (BugzillaFixture.current().getBugzillaVersion().isSmaller(BugzillaVersion.BUGZILLA_4_0) ? this.fixtureTransitionsMap.get(BUGZILLA_LE_4_0) : this.fixtureTransitionsMap.get(BUGZILLA_GE_4_0)));
        for (String start : expectTransitions.keySet()) {
            transitions.clear();
            ArrayList<String> expectedStateTransition = expectTransitions.get(start);
            for (AbstractBugzillaOperation s : ctm.getValidTransitions(start)) {
                String end = s.toString();
                if (expectedStateTransition.contains(end)) {
                    transitions.add(end);
                    continue;
                }
                BugzillaXmlRpcClientTest.fail((String)("The status " + start + " is not expected to transition to " + end.toString()));
            }
            BugzillaXmlRpcClientTest.assertEquals((String)("Missing transitions for " + start + ", only found " + transitions), (int)transitions.size(), (int)ctm.getValidTransitions(start).size());
        }
    }

    public void testXmlRpcBugGet() throws Exception {
        if (!BugzillaFixture.current().isXmlRpcEnabled()) {
            return;
        }
        HashSet<String> taskIds = new HashSet<String>();
        String taskId = this.harness.taskXmlRpcExists();
        if (taskId == null) {
            taskId = this.harness.createXmlRpcTask();
        }
        taskIds.add(taskId);
        final HashMap results = new HashMap();
        final HashMap resultsXMLRPC = new HashMap();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                results.put(taskData.getTaskId(), taskData);
            }
        };
        TaskDataCollector collectorXMLRPC = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                resultsXMLRPC.put(taskData.getTaskId(), taskData);
            }
        };
        CoreException[] collectionException = new CoreException[1];
        Boolean[] updateConfig = new Boolean[1];
        class CollectorWrapper
        extends TaskDataCollector {
            private final IProgressMonitor monitor2;
            private final TaskDataCollector collector;
            private final /* synthetic */ Boolean[] val$updateConfig;
            private final /* synthetic */ CoreException[] val$collectionException;

            public void failed(String taskId, IStatus status) {
                this.collector.failed(taskId, status);
            }

            public CollectorWrapper(TaskDataCollector collector, IProgressMonitor monitor2, Boolean[] booleanArray, CoreException[] coreExceptionArray) {
                this.val$updateConfig = booleanArray;
                this.val$collectionException = coreExceptionArray;
                this.collector = collector;
                this.monitor2 = monitor2;
            }

            public void accept(TaskData taskData) {
                block4: {
                    try {
                        AbstractTaskDataHandler taskDataHandler = BugzillaXmlRpcClientTest.this.connector.getTaskDataHandler();
                        taskDataHandler.initializeTaskData(BugzillaXmlRpcClientTest.this.repository, taskData, null, (IProgressMonitor)new SubProgressMonitor(this.monitor2, 1));
                    }
                    catch (CoreException e) {
                        if (e.getStatus().getCode() == 1 && e.getMessage().contains("Update Config")) {
                            if (this.val$updateConfig[0] == null) {
                                this.val$updateConfig[0] = new Boolean(true);
                            }
                        }
                        if (this.val$collectionException[0] != null) break block4;
                        this.val$collectionException[0] = e;
                    }
                }
                this.collector.accept(taskData);
                this.monitor2.worked(1);
            }
        }
        CollectorWrapper collector2 = new CollectorWrapper(collector, (IProgressMonitor)new NullProgressMonitor(), updateConfig, collectionException);
        CollectorWrapper collector3 = new CollectorWrapper(collectorXMLRPC, (IProgressMonitor)new NullProgressMonitor(), updateConfig, collectionException);
        this.client.getTaskData(taskIds, (TaskDataCollector)collector2, (TaskAttributeMapper)new BugzillaAttributeMapper(this.repository, this.connector), (IProgressMonitor)new NullProgressMonitor());
        if (collectionException[0] != null) {
            throw collectionException[0];
        }
        this.bugzillaClient.getTaskData(taskIds, (TaskDataCollector)collector3, (TaskAttributeMapper)new BugzillaAttributeMapper(this.repository, this.connector), (IProgressMonitor)new NullProgressMonitor());
        if (collectionException[0] != null) {
            throw collectionException[0];
        }
        BugzillaXmlRpcClientTest.assertEquals((int)results.size(), (int)resultsXMLRPC.size());
        String div = "";
        for (String taskID : results.keySet()) {
            TaskData taskDataHTML = (TaskData)results.get(taskID);
            TaskData taskDataXMLRPC = (TaskData)resultsXMLRPC.get(taskID);
            BugzillaXmlRpcClientTest.assertNotNull((Object)taskDataHTML);
            BugzillaXmlRpcClientTest.assertNotNull((Object)taskDataXMLRPC);
            Map attributesHTML = taskDataHTML.getRoot().getAttributes();
            Map attributesXMLRPC = taskDataXMLRPC.getRoot().getAttributes();
            div = String.valueOf(div) + this.compareAttributes(attributesHTML, attributesXMLRPC, "", "Root-" + taskID + ": ");
        }
    }

    private String compareAttributes(Map<String, TaskAttribute> attributesHTML, Map<String, TaskAttribute> attributesXMLRPC, String div, String prefix) {
        for (String attributeNameHTML : attributesHTML.keySet()) {
            Map subAttribHTML;
            TaskAttribute attributeHTML = attributesHTML.get(attributeNameHTML);
            TaskAttribute attributeXMLRPC = attributesXMLRPC.get(attributeNameHTML);
            if (attributeXMLRPC == null) {
                div = String.valueOf(div) + prefix + attributeNameHTML + " not in XMLRPC\n";
                continue;
            }
            if (attributeHTML.getValues().size() > 1) {
                List i1 = attributeHTML.getValues();
                List i2 = attributeXMLRPC.getValues();
                if (i1.size() != i2.size()) {
                    div = String.valueOf(div) + prefix + attributeNameHTML + " has size " + i1.size() + " but got " + i2.size() + "\n";
                }
                for (String string : i1) {
                    if (i2.contains(string)) continue;
                    div = String.valueOf(div) + prefix + attributeNameHTML + " did not have " + string + "\n";
                }
            }
            if (attributeHTML.getValue().compareTo(attributeXMLRPC.getValue()) != 0) {
                div = String.valueOf(div) + prefix + attributeNameHTML + " value not equal HTML = '" + attributeHTML.getValue() + "' XMLRPC = '" + attributeXMLRPC.getValue() + "'\n";
            }
            TaskAttributeMetaData metaHTML = attributeHTML.getMetaData();
            TaskAttributeMetaData metaXMLRPC = attributeXMLRPC.getMetaData();
            if (metaHTML != null && metaXMLRPC == null) {
                div = String.valueOf(div) + prefix + attributeNameHTML + " MetaData not in XMLRPC\n";
            }
            if (metaHTML != null && metaXMLRPC != null) {
                if (metaHTML.getKind() != null && metaXMLRPC.getKind() == null) {
                    div = String.valueOf(div) + prefix + attributeNameHTML + " MetaData Kind not in XMLRPC\n";
                } else if (metaHTML.getKind() != null && metaHTML.getKind().compareTo(metaXMLRPC.getKind()) != 0) {
                    div = String.valueOf(div) + prefix + attributeNameHTML + " Meta Kind not equal HTML = '" + metaHTML.getKind() + "' XMLRPC = '" + metaXMLRPC.getKind() + "'\n";
                }
                if (metaHTML.getType() != null && metaXMLRPC.getType() == null) {
                    div = String.valueOf(div) + prefix + attributeNameHTML + " MetaData Type not in XMLRPC\n";
                } else if (metaHTML.getType() != null && metaHTML.getType().compareTo(metaXMLRPC.getType()) != 0) {
                    div = String.valueOf(div) + prefix + attributeNameHTML + " Meta Type not equal HTML = '" + metaHTML.getType() + "' XMLRPC = '" + metaXMLRPC.getType() + "'\n";
                }
                if (metaHTML.getLabel() != null && metaXMLRPC.getLabel() == null) {
                    div = String.valueOf(div) + prefix + attributeNameHTML + " MetaData Label not in XMLRPC\n";
                } else if (metaHTML.getLabel() != null && metaHTML.getLabel().compareTo(metaXMLRPC.getLabel()) != 0) {
                    div = String.valueOf(div) + prefix + attributeNameHTML + " Meta Label not equal HTML = '" + metaHTML.getLabel() + "' XMLRPC = '" + metaXMLRPC.getLabel() + "'\n";
                }
            }
            if ((subAttribHTML = attributeHTML.getAttributes()).isEmpty()) continue;
            Map subAttribXMLRPC = attributeXMLRPC.getAttributes();
            div = this.compareAttributes(subAttribHTML, subAttribXMLRPC, div, String.valueOf(prefix) + attributeNameHTML + ": ");
        }
        return div;
    }

    public void testUpdateProductInfo() throws Exception {
        if (!BugzillaFixture.current().isXmlRpcEnabled()) {
            return;
        }
        RepositoryConfiguration repositoryConfiguration = this.connector.getRepositoryConfiguration(this.repository.getRepositoryUrl());
        for (String product : repositoryConfiguration.getOptionValues(BugzillaAttribute.PRODUCT)) {
            repositoryConfiguration.setDefaultMilestone(product, null);
        }
        this.bugzillaClient.updateProductInfo((IProgressMonitor)new NullProgressMonitor(), repositoryConfiguration);
        for (String product : repositoryConfiguration.getOptionValues(BugzillaAttribute.PRODUCT)) {
            if (product.equals("ManualTest") || product.equals("Product with Spaces") || product.equals("TestProduct")) {
                BugzillaXmlRpcClientTest.assertEquals((String)"---", (String)repositoryConfiguration.getDefaultMilestones(product));
                continue;
            }
            BugzillaXmlRpcClientTest.fail((String)"never reach this");
        }
    }
}

