/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.mylyn.internal.wikitext.core.ant.AbstractTestAntTask;
import org.eclipse.mylyn.internal.wikitext.core.ant.MarkupToXslfoTask;

public class MarkupToXslfoTaskTest
extends AbstractTestAntTask {
    private MarkupToXslfoTask task;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.task = new MarkupToXslfoTask();
        this.task.setMarkupLanguage(this.languageName);
    }

    public void testSimpleOutput() throws IOException {
        File markup = this.createSimpleTextileMarkup();
        this.task.setFile(markup);
        this.task.execute();
        this.listFiles();
        File targetFile = new File(markup.getParentFile(), "markup.fo");
        MarkupToXslfoTaskTest.assertTrue((targetFile.exists() && targetFile.isFile() ? 1 : 0) != 0);
        String content = this.getContent(targetFile);
        MarkupToXslfoTaskTest.assertTrue((boolean)content.contains("<root xmlns=\"http://www.w3.org/1999/XSL/Format\""));
        MarkupToXslfoTaskTest.assertTrue((boolean)content.contains("</root>"));
        MarkupToXslfoTaskTest.assertTrue((boolean)content.contains(">markup</block>"));
        MarkupToXslfoTaskTest.assertTrue((boolean)content.contains(" id=\"FirstHeading\">First Heading</block>"));
        MarkupToXslfoTaskTest.assertTrue((boolean)content.contains(" id=\"SecondHeading\">Second Heading</block>"));
    }

    protected File createSimpleTextileMarkup() throws IOException {
        File markupFile = new File(this.tempFolder, "markup.textile");
        try (PrintWriter writer = new PrintWriter(new FileWriter(markupFile));){
            writer.println("h1. First Heading");
            writer.println();
            writer.println("some content");
            writer.println();
            writer.println("h1. Second Heading");
            writer.println();
            writer.println("some more content");
        }
        return markupFile;
    }

    public void testTaskdef() {
        MarkupToXslfoTaskTest.assertEquals((String)MarkupToXslfoTask.class.getName(), (String)this.loadTaskdefBundle().getString("wikitext-to-xslfo"));
    }
}

