/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.tasks.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.commons.workbench.forms.SectionComposite;
import org.eclipse.mylyn.internal.provisional.tasks.ui.wizards.AbstractQueryPageSchema;
import org.eclipse.mylyn.internal.provisional.tasks.ui.wizards.QueryPageDetails;
import org.eclipse.mylyn.internal.provisional.tasks.ui.wizards.QueryPageSearch;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskDiffUtil;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelEvent;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelListener;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage2;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RepositoryQuerySchemaPage
extends AbstractRepositoryQueryPage2 {
    private static final String QUERYPAGE_FILTER_ID = "org.eclipse.mylyn.tasks.ui.wizards.QueryPageFilter";
    private static final int LABEL_WIDTH = 110;
    private static final int COLUMN_WIDTH = 140;
    private static final int COLUMN_GAP = 20;
    private static final int MULTI_COLUMN_WIDTH = 420;
    private static final int MULTI_ROW_HEIGHT = 55;
    protected final AbstractQueryPageSchema schema;
    private final TaskData data;
    private final Pattern URL_PATTERN;
    private QueryPageSearch search;
    private final QueryPageDetails pageDetails;
    private AttributeEditorFactory factory;
    private SectionComposite scrolledComposite;
    private TaskData targetTaskData;
    protected final Map<String, AbstractAttributeEditor> editorMap = new HashMap<String, AbstractAttributeEditor>();

    public RepositoryQuerySchemaPage(String pageName, TaskRepository repository, IRepositoryQuery query, AbstractQueryPageSchema schema, TaskData data, QueryPageDetails pageDetails) {
        super(pageName, repository, query);
        this.schema = schema;
        this.data = data;
        this.pageDetails = pageDetails;
        this.setTitle(pageDetails.getPageTitle());
        this.setDescription(pageDetails.getPageDescription());
        this.URL_PATTERN = Pattern.compile(pageDetails.getUrlPattern());
        this.search = query != null ? new QueryPageSearch(query.getUrl()) : new QueryPageSearch();
    }

    @Override
    protected void createPageContent(@NonNull SectionComposite parent) {
        this.scrolledComposite = parent;
        Composite scrolledBodyComposite = this.scrolledComposite.getContent();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        scrolledBodyComposite.setLayout((Layout)layout);
        Composite attributesComposite = new Composite(scrolledBodyComposite, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)attributesComposite);
        layout = new GridLayout(6, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        attributesComposite.setLayout((Layout)layout);
        GridData g = new GridData(4, 4, true, true);
        g.widthHint = 400;
        attributesComposite.setLayoutData((Object)g);
        attributesComposite.setForeground(parent.getDisplay().getSystemColor(24));
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        TaskRepository repository = this.getTaskRepository();
        TaskTask nTask = new TaskTask(repository.getConnectorKind(), repository.getRepositoryUrl(), this.data.getTaskId());
        ITaskDataWorkingCopy workingCopy = TasksUi.getTaskDataManager().createWorkingCopy((ITask)nTask, this.data);
        TaskDataModel model = new TaskDataModel(repository, (ITask)nTask, workingCopy);
        this.factory = new AttributeEditorFactory(model, repository);
        model.addModelListener(new TaskDataModelListener(){

            public void attributeChanged(TaskDataModelEvent event) {
                RepositoryQuerySchemaPage.this.getContainer().updateButtons();
            }
        });
        this.targetTaskData = workingCopy.getLocalData();
        TaskAttribute target = this.targetTaskData.getRoot();
        this.createFieldControls(attributesComposite, toolkit, layout.numColumns, target);
        Point p = scrolledBodyComposite.computeSize(-1, -1, true);
        this.scrolledComposite.setMinSize(p);
    }

    private void createFieldControls(Composite attributesComposite, FormToolkit toolkit, int columnCount, TaskAttribute target) {
        int currentColumn = 1;
        int currentPriority = 0;
        int currentLayoutPriority = 0;
        for (AbstractQueryPageSchema.Field field : this.schema.getFields()) {
            GridData gd;
            int priority;
            TaskAttribute dataAttribute = target.getAttribute(field.getKey());
            AbstractAttributeEditor attributeEditor = this.factory.createEditor(field.getType(), dataAttribute);
            this.editorMap.put(dataAttribute.getId(), attributeEditor);
            String layoutPriorityString = dataAttribute.getMetaData().getValue("LayoutPriority");
            int layoutPriority = layoutPriorityString == null ? -1 : Integer.parseInt(layoutPriorityString);
            int n = priority = attributeEditor.getLayoutHint() != null ? attributeEditor.getLayoutHint().getPriority() : 10;
            if (priority != currentPriority || currentLayoutPriority != layoutPriority) {
                currentPriority = priority;
                currentLayoutPriority = layoutPriority;
                if (currentColumn > 1) {
                    while (currentColumn <= columnCount) {
                        Label l = toolkit.createLabel(attributesComposite, "");
                        gd = GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(0, -1).create();
                        l.setLayoutData((Object)gd);
                        ++currentColumn;
                    }
                    currentColumn = 1;
                }
            }
            if (attributeEditor.hasLabel()) {
                attributeEditor.createLabelControl(attributesComposite, toolkit);
                Label label = attributeEditor.getLabelControl();
                label.setBackground(attributesComposite.getBackground());
                label.setForeground(attributesComposite.getForeground());
                String text = label.getText();
                String shortenText = TaskDiffUtil.shortenText((Drawable)label, text, 110);
                label.setText(shortenText);
                if (!text.equals(shortenText)) {
                    label.setToolTipText(text);
                }
                GridData gd2 = GridDataFactory.fillDefaults().align(131072, 0x1000000).grab(true, true).hint(110, -1).create();
                if (currentColumn > 1) {
                    gd2.horizontalIndent = 20;
                    gd2.widthHint = 130;
                }
                label.setLayoutData((Object)gd2);
                ++currentColumn;
            }
            attributeEditor.createControl(attributesComposite, toolkit);
            attributeEditor.getControl().setBackground(attributesComposite.getParent().getDisplay().getSystemColor(25));
            attributeEditor.getControl().setForeground(attributesComposite.getForeground());
            LayoutHint layoutHint = attributeEditor.getLayoutHint();
            gd = new GridData(4, 4, true, true);
            LayoutHint.RowSpan rowSpan = layoutHint != null && layoutHint.rowSpan != null ? layoutHint.rowSpan : LayoutHint.RowSpan.SINGLE;
            LayoutHint.ColumnSpan columnSpan = layoutHint != null && layoutHint.columnSpan != null ? layoutHint.columnSpan : LayoutHint.ColumnSpan.SINGLE;
            gd.horizontalIndent = 1;
            if (rowSpan == LayoutHint.RowSpan.SINGLE && columnSpan == LayoutHint.ColumnSpan.SINGLE) {
                gd.widthHint = 140;
                gd.horizontalSpan = 1;
            } else {
                if (rowSpan == LayoutHint.RowSpan.MULTIPLE) {
                    gd.heightHint = 55;
                }
                if (columnSpan == LayoutHint.ColumnSpan.SINGLE) {
                    gd.widthHint = 140;
                    gd.horizontalSpan = 1;
                } else {
                    gd.widthHint = 420;
                    gd.horizontalSpan = columnCount - currentColumn + 1;
                }
            }
            attributeEditor.getControl().setLayoutData((Object)gd);
            currentColumn += gd.horizontalSpan;
            currentColumn %= columnCount;
        }
    }

    @Override
    public boolean isPageComplete() {
        this.setMessage(this.pageDetails.getPageDescription());
        boolean result = super.isPageComplete();
        if (!result) {
            return result;
        }
        this.setErrorMessage(null);
        this.setMessage("");
        boolean oneFieldHasValue = false;
        for (AbstractQueryPageSchema.Field field : this.schema.getFields()) {
            String text;
            oneFieldHasValue |= this.targetTaskData.getRoot().getAttribute(field.getKey()).hasValue() && !this.targetTaskData.getRoot().getAttribute(field.getKey()).getValue().equals("");
            if (field.isQueryRequired() && ((text = this.targetTaskData.getRoot().getAttribute(field.getKey()).getValue()) == null || text.length() == 0)) {
                this.setMessage("Enter a value for " + field.getLabel());
                return false;
            }
            if (!field.getType().equals("url") || (text = this.targetTaskData.getRoot().getAttribute(field.getKey()).getValue()) == null || text.length() <= 0) continue;
            Matcher m = this.URL_PATTERN.matcher(text);
            if (m.find()) {
                this.setErrorMessage(null);
                return true;
            }
            this.setErrorMessage("Please specify a valid URL in " + field.getLabel());
            return false;
        }
        if (!oneFieldHasValue) {
            this.setErrorMessage("Please fill at least on field!");
        }
        return true;
    }

    protected String getQueryUrl(String repsitoryUrl) {
        StringBuilder sb = new StringBuilder();
        sb.append(repsitoryUrl);
        sb.append("/");
        sb.append(this.pageDetails.getQueryUrlPart());
        sb.append(this.search.toQuery());
        return sb.toString();
    }

    @Override
    public void applyTo(IRepositoryQuery query) {
        query.setSummary(this.getQueryTitle());
        query.setUrl(this.getQueryUrl(this.getTaskRepository().getRepositoryUrl()));
        if (this.pageDetails.getQueryAttributeName() != null) {
            query.setAttribute(this.pageDetails.getQueryAttributeName(), Boolean.TRUE.toString());
        }
    }

    @Override
    protected void doRefreshControls() {
    }

    @Override
    protected boolean hasRepositoryConfiguration() {
        return true;
    }

    @Override
    protected boolean restoreState(@NonNull IRepositoryQuery query) {
        return false;
    }

    protected TaskData getTargetTaskData() {
        return this.targetTaskData;
    }
}

