/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.parser;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ws.commons.util.NamespaceContextImpl;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcStreamConfig;
import org.apache.xmlrpc.parser.RecursiveTypeParserImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MapParser
extends RecursiveTypeParserImpl {
    private int level = 0;
    private String name;
    private Map map;
    private boolean inName;
    private boolean inValue;
    private boolean doneValue;

    public MapParser(XmlRpcStreamConfig pConfig, NamespaceContextImpl pContext, TypeFactory pFactory) {
        super(pConfig, pContext, pFactory);
    }

    protected void addResult(Object pResult) throws SAXException {
        if (this.name == null) {
            throw new SAXParseException("Invalid state: Expected name", this.getDocumentLocator());
        }
        if (this.map.containsKey(this.name)) {
            throw new SAXParseException("Duplicate name: " + this.name, this.getDocumentLocator());
        }
        this.map.put(this.name, pResult);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.level = 0;
        this.map = new HashMap();
        this.inName = false;
        this.inValue = false;
    }

    public void characters(char[] pChars, int pOffset, int pLength) throws SAXException {
        if (this.inName) {
            String s = new String(pChars, pOffset, pLength);
            this.name = this.name == null ? s : this.name + s;
        } else {
            super.characters(pChars, pOffset, pLength);
        }
    }

    public void ignorableWhitespace(char[] pChars, int pOffset, int pLength) throws SAXException {
        if (this.inName) {
            this.characters(pChars, pOffset, pLength);
        } else {
            super.ignorableWhitespace(pChars, pOffset, pLength);
        }
    }

    public void startElement(String pURI, String pLocalName, String pQName, Attributes pAttrs) throws SAXException {
        switch (this.level++) {
            case 0: {
                if ("".equals(pURI) && "struct".equals(pLocalName)) break;
                throw new SAXParseException("Expected struct, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
            }
            case 1: {
                if (!"".equals(pURI) || !"member".equals(pLocalName)) {
                    throw new SAXParseException("Expected member, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                this.inValue = false;
                this.inName = false;
                this.doneValue = false;
                this.name = null;
                break;
            }
            case 2: {
                if (this.doneValue) {
                    throw new SAXParseException("Expected /member, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                if ("".equals(pURI) && "name".equals(pLocalName)) {
                    if (this.name == null) {
                        this.inName = true;
                        break;
                    }
                    throw new SAXParseException("Expected value, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                if (!"".equals(pURI) || !"value".equals(pLocalName)) break;
                if (this.name == null) {
                    throw new SAXParseException("Expected name, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                this.inValue = true;
                this.startValueTag();
                break;
            }
            default: {
                super.startElement(pURI, pLocalName, pQName, pAttrs);
            }
        }
    }

    public void endElement(String pURI, String pLocalName, String pQName) throws SAXException {
        switch (--this.level) {
            case 0: {
                this.setResult(this.map);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.inName) {
                    this.inName = false;
                    break;
                }
                if (!this.inValue) break;
                this.endValueTag();
                this.doneValue = true;
                break;
            }
            default: {
                super.endElement(pURI, pLocalName, pQName);
            }
        }
    }
}

