/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;

public class TaskListContentProviderTest
extends TestCase {
    private TaskListContentProvider provider;
    private TaskListView view;
    private TaskList taskList;

    protected void setUp() throws Exception {
        super.setUp();
        TasksUiUtil.openTasksViewInActivePerspective();
        this.view = TaskListView.getFromActivePerspective();
        this.provider = (TaskListContentProvider)this.view.getViewer().getContentProvider();
        TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.group.subtasks", true);
        this.view.clearFilters();
        this.view.addFilter((AbstractTaskListFilter)this.view.getCompleteFilter());
        this.taskList = TasksUiPlugin.getTaskList();
    }

    protected void tearDown() throws Exception {
        this.view.clearFilters();
        super.tearDown();
    }

    public void testHasChildren() {
        LocalTask parent = new LocalTask("parent", "parent label");
        LocalTask completedChild = new LocalTask("completed child", "completed child label");
        completedChild.setCompletionDate(new Date());
        this.taskList.addTask((ITask)parent);
        this.taskList.addTask((ITask)completedChild, (AbstractTaskContainer)parent);
        TaskListContentProviderTest.assertFalse((boolean)this.provider.hasChildren((Object)parent));
        LocalTask incompleteChild = new LocalTask("incomplete child", "incomplete child label");
        incompleteChild.setCompletionDate(null);
        this.taskList.addTask((ITask)incompleteChild, (AbstractTaskContainer)parent);
        TaskListContentProviderTest.assertTrue((boolean)this.provider.hasChildren((Object)parent));
    }
}

