/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;

public class MockServer
implements Runnable {
    public static String CRLF = "\r\n";
    public static final String HEADER_CONNECTION_CLOSE = "Connection: Close";
    public static final String HEADER_NO_CONTENT = "Content-Length: 0";
    public static final Message NOT_FOUND = new Message("HTTP/1.1 404 Not Found");
    public static final Message OK = new Message("HTTP/1.1 200 OK");
    public static final Message TIMEOUT = new Message("HTTP/1.1 200 OK");
    public static final Message UNAUTHORIZED = new Message("HTTP/1.1 401 Unauthorized");
    public static final Message SERVICE_UNVAILABLE = MockServer.createEmptyMessage("HTTP/1.1 503 Service Unavailable");
    private boolean autoClose;
    private IOException exception;
    private final int listenPort;
    private final List<Message> requests = new ArrayList<Message>();
    private final List<Message> responses = new ArrayList<Message>();
    private Thread runner;
    private volatile ServerSocket serverSocket;
    private volatile boolean stopped;
    private boolean waitForResponse;
    private boolean closeOnConnect;
    private boolean debugEnabled;

    static {
        MockServer.NOT_FOUND.headers.add(HEADER_CONNECTION_CLOSE);
        MockServer.OK.headers.add(HEADER_CONNECTION_CLOSE);
        MockServer.SERVICE_UNVAILABLE.headers.add(HEADER_CONNECTION_CLOSE);
        MockServer.TIMEOUT.headers.add("Content-Length: 500");
        MockServer.UNAUTHORIZED.headers.add("WWW-Authenticate: Basic realm=\"Test\"");
    }

    private static Message createEmptyMessage(String status) {
        return new Message(String.valueOf(status) + "\n" + HEADER_NO_CONTENT + "\n\n");
    }

    public MockServer() {
        this(0);
    }

    public MockServer(int listenPort) {
        this.listenPort = listenPort;
        this.autoClose = true;
    }

    public synchronized void addRequest(Message request) {
        this.requests.add(request);
        this.notifyAll();
    }

    public synchronized void addResponse(Message response) {
        this.responses.add(response);
        this.notifyAll();
    }

    public synchronized void addResponse(String response) {
        this.responses.add(new Message(response));
        this.notifyAll();
    }

    public synchronized void checkForException() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public synchronized Message getRequest() throws InterruptedException {
        if (this.requests.isEmpty()) {
            throw new AssertionFailedError("Request list is empty");
        }
        return this.requests.remove(0);
    }

    private void handleConnection(Socket socket) {
        block20: {
            try {
                while (!this.closeOnConnect && !this.stopped) {
                    Message request = this.readMessage(socket.getInputStream());
                    if (!this.stopped && request != null) {
                        this.addRequest(request);
                        if (this.hasMoreResponses() || this.waitForResponse) {
                            Message response = this.waitForResponse();
                            if (!this.stopped && response != null) {
                                this.writeMessage(response, socket.getOutputStream());
                                if (!this.autoClose || !response.toString().contains(HEADER_CONNECTION_CLOSE)) continue;
                            }
                        } else {
                            this.writeMessage(SERVICE_UNVAILABLE, socket.getOutputStream());
                            System.err.println("Unexpected request: ");
                            System.err.println(request.toString());
                        }
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.setException(e);
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                break block20;
            }
            catch (InterruptedException interruptedException) {
                try {}
                catch (Throwable throwable) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                break block20;
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private synchronized boolean hasMoreResponses() {
        return !this.responses.isEmpty();
    }

    public synchronized boolean hasRequest() {
        return !this.requests.isEmpty();
    }

    public boolean isAutoClose() {
        return this.autoClose;
    }

    public boolean isCloseOnConnect() {
        return this.closeOnConnect;
    }

    private Message readMessage(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        Message message = null;
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0) {
                if (message == null) {
                    throw new IOException("Incomplete message");
                }
                return message;
            }
            if (message == null) {
                if (this.isDebugEnabled()) {
                    System.err.println("< " + line);
                }
                message = new Message(line);
                continue;
            }
            message.headers.add(line);
        }
        throw new EOFException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            this.serverSocket = new ServerSocket(this.listenPort);
            while (!this.stopped) {
                Socket socket = this.serverSocket.accept();
                this.handleConnection(socket);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            if (this.serverSocket == null) return;
            try {
                this.serverSocket.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException e) {
            try {
                this.setException(e);
                if (this.serverSocket == null) return;
            }
            catch (Throwable throwable) {
                if (this.serverSocket == null) throw throwable;
                try {
                    this.serverSocket.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                this.serverSocket.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (this.serverSocket == null) return;
        try {
            this.serverSocket.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void setCloseOnConnect(boolean closeOnConnect) {
        this.closeOnConnect = closeOnConnect;
    }

    public void setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
    }

    private synchronized void setException(IOException exception) {
        this.exception = exception;
        this.notifyAll();
    }

    public void setWaitForResponse(boolean waitForResponse) {
        this.waitForResponse = waitForResponse;
    }

    public void start() {
        this.runner = new Thread((Runnable)this, "MockServer :" + this.listenPort);
        this.runner.start();
    }

    public int startAndWait() throws InterruptedException {
        this.start();
        while (this.serverSocket == null || this.serverSocket.getLocalPort() == -1) {
            Thread.sleep(100L);
        }
        return this.serverSocket.getLocalPort();
    }

    public String getUrl() {
        InetSocketAddress address = new InetSocketAddress("localhost", this.serverSocket.getLocalPort());
        return "http://" + address.getHostName() + ":" + address.getPort() + "/";
    }

    public void stop() {
        this.stopped = true;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {}
        this.runner.interrupt();
        try {
            this.runner.join(500L);
        }
        catch (InterruptedException interruptedException) {}
    }

    public synchronized Message waitForRequest() throws InterruptedException {
        while (this.requests.isEmpty()) {
            if (this.stopped) {
                return null;
            }
            this.wait();
        }
        return this.requests.remove(0);
    }

    public synchronized Message waitForResponse() throws InterruptedException {
        while (!this.stopped && this.responses.isEmpty()) {
            if (this.stopped || this.autoClose) {
                return null;
            }
            this.wait();
        }
        return this.responses.remove(0);
    }

    private void writeMessage(Message message, OutputStream out) throws IOException {
        if (this.isDebugEnabled()) {
            System.err.println("> " + message.getStatusLine());
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, message.getCharset()));
        writer.write(message.toString());
        writer.flush();
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public static class Message {
        public List<String> headers = new ArrayList<String>();
        public String request;
        private String charset;

        public Message(String request) {
            this.request = request;
            this.charset = "ISO-8859-1";
        }

        public String getCharset() {
            return this.charset;
        }

        public String getHeader(String prefix) {
            if (this.headers != null) {
                for (String header : this.headers) {
                    if (!header.startsWith(prefix)) continue;
                    return header;
                }
            }
            return null;
        }

        public String getHeaderValue(String prefix) {
            String header = this.getHeader(prefix);
            if (header != null) {
                int i = header.indexOf(": ");
                return i != -1 ? header.substring(i + 2) : "";
            }
            return null;
        }

        public String getMethod() {
            int i = this.request.indexOf(" ");
            return i != -1 ? this.request.substring(0, i) : this.request;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public String getStatusLine() {
            int i = this.request.indexOf("\n");
            return i != -1 ? this.request.substring(0, i) : this.request;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.request);
            sb.append("\n");
            if (this.headers != null) {
                for (String header : this.headers) {
                    sb.append(header);
                    sb.append("\n");
                }
            }
            sb.append("\n");
            return sb.toString().replaceAll("\n", CRLF);
        }
    }
}

