/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.CategorizedPresentation;
import org.eclipse.mylyn.internal.tasks.ui.ScheduledPresentation;
import org.eclipse.mylyn.internal.tasks.ui.util.SortCriterion;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskComparator;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListPresentation;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskComparatorTest {
    private TaskComparator taskComparator;

    @Before
    public void setup() {
        this.taskComparator = new TaskComparator();
    }

    @Test
    public void compareRank() {
        this.assertCompare(this.taskWithRank("5"), this.taskWithRank("7"));
        this.assertCompare(this.taskWithRank("5"), this.taskWithRank("17"));
        this.assertCompare(this.taskWithRank("5"), this.taskWithRank("17.1"));
        this.assertCompare(this.taskWithRank("5.3"), this.taskWithRank("17.1"));
        this.assertCompare(this.taskWithRank("#$d"), this.taskWithRank("#$e"));
        this.assertCompare(this.taskWithRank("gjp"), this.taskWithRank("gkp"));
        this.assertCompare(this.taskWithRank("A"), this.taskWithRank("a"));
        this.assertCompare(this.taskWithRank("dsfhgSd"), this.taskWithRank("dsfhgsd"));
        this.assertCompare(this.taskWithRank("dsfhgS"), this.taskWithRank("dsfhgsd"));
        this.assertCompare(this.taskWithRank("dsfhgs"), this.taskWithRank("dsfhgsd"));
        Assert.assertEquals((long)0L, (long)this.taskComparator.compare(this.taskWithRank("5"), this.taskWithRank("5")));
        Assert.assertEquals((long)0L, (long)this.taskComparator.compare(this.taskWithRank("17.1"), this.taskWithRank("17.1")));
        Assert.assertEquals((long)0L, (long)this.taskComparator.compare(this.taskWithRank("dsfhgs"), this.taskWithRank("dsfhgs")));
        Assert.assertEquals((long)0L, (long)this.taskComparator.compare(this.taskWithRank("ds#fHgs"), this.taskWithRank("ds#fHgs")));
    }

    @Test
    public void readLegacyMemento() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"sorter");
        IMemento child1 = memento.createChild("sort0");
        IMemento child2 = memento.createChild("sort1");
        SortCriterion criterion1 = new SortCriterion(SortCriterion.SortKey.PRIORITY, 1);
        SortCriterion criterion2 = new SortCriterion(SortCriterion.SortKey.TASK_ID, -1);
        criterion1.saveState(child1);
        criterion2.saveState(child2);
        this.taskComparator.restoreState((IMemento)memento);
        this.assertCriterionEquals(criterion1, this.taskComparator.getSortCriterion(0));
        this.assertCriterionEquals(criterion2, this.taskComparator.getSortCriterion(1));
    }

    @Test
    public void readPerspectiveMemento() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"sorter");
        IMemento categorized1 = memento.createChild("sortorg.eclipse.mylyn.tasks.ui.categorized0");
        IMemento categorized2 = memento.createChild("sortorg.eclipse.mylyn.tasks.ui.categorized1");
        IMemento scheduled1 = memento.createChild("sortorg.eclipse.mylyn.tasks.ui.scheduled0");
        IMemento scheduled2 = memento.createChild("sortorg.eclipse.mylyn.tasks.ui.scheduled1");
        SortCriterion criterion1c = new SortCriterion(SortCriterion.SortKey.PRIORITY, 1);
        SortCriterion criterion2c = new SortCriterion(SortCriterion.SortKey.TASK_ID, -1);
        SortCriterion criterion1s = new SortCriterion(SortCriterion.SortKey.DUE_DATE, 1);
        SortCriterion criterion2s = new SortCriterion(SortCriterion.SortKey.SCHEDULED_DATE, -1);
        criterion1c.saveState(categorized1);
        criterion2c.saveState(categorized2);
        criterion1s.saveState(scheduled1);
        criterion2s.saveState(scheduled2);
        this.taskComparator.restoreState((IMemento)memento);
        this.assertCriterionEquals(criterion1c, this.taskComparator.getSortCriterion(0));
        this.assertCriterionEquals(criterion2c, this.taskComparator.getSortCriterion(1));
        this.taskComparator.presentationChanged((AbstractTaskListPresentation)new ScheduledPresentation());
        this.assertCriterionEquals(criterion1s, this.taskComparator.getSortCriterion(0));
        this.assertCriterionEquals(criterion2s, this.taskComparator.getSortCriterion(1));
        this.taskComparator.presentationChanged((AbstractTaskListPresentation)new CategorizedPresentation());
        this.assertCriterionEquals(criterion1c, this.taskComparator.getSortCriterion(0));
        this.assertCriterionEquals(criterion2c, this.taskComparator.getSortCriterion(1));
    }

    private void assertCriterionEquals(SortCriterion expected, SortCriterion actual) {
        Assert.assertEquals((long)expected.getDirection(), (long)actual.getDirection());
        Assert.assertEquals((Object)expected.getKey(), (Object)actual.getKey());
    }

    private void assertCompare(ITask task1, ITask task2) {
        Assert.assertTrue((this.taskComparator.compare(task1, task2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.taskComparator.compare(task2, task1) > 0 ? 1 : 0) != 0);
    }

    private ITask taskWithRank(String rank) {
        TaskTask task = new TaskTask("kind", "http://mock", "1");
        task.setPriority("");
        task.setAttribute("task.common.rank", rank);
        return task;
    }
}

