/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.viewer;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssParser;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssRule;
import org.eclipse.mylyn.internal.wikitext.core.util.css.ElementInfo;
import org.eclipse.mylyn.internal.wikitext.core.util.css.Stylesheet;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.HtmlTextPresentationParser;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.tests.HeadRequired;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@HeadRequired
public class HtmlTextPresentationParserTest {
    private HtmlTextPresentationParser parser;

    @Before
    public void setUp() {
        this.parser = new HtmlTextPresentationParser();
        this.parser.setPresentation(new TextPresentation());
        this.parser.setDefaultFont(new Font(null, new FontData[]{new FontData("fake", 12, 0)}));
    }

    public void testAdjacentElementsSeparatedByWhitespace() throws Exception {
        this.parser.parse("<html><body><p><strong>one</strong> <em>two</em></p></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text: '" + text + "'");
        Assert.assertTrue((boolean)text.contains("one two"));
    }

    @Test
    public void testSignificantWhitespaceLossBug236367() throws SAXException, IOException {
        String html = new MarkupParser((MarkupLanguage)new TextileLanguage()).parseToHtml("one *two* three *four* five *six* seven");
        TestUtil.println("HTML: " + html);
        this.parser.parse(html);
        String text = this.parser.getText();
        TestUtil.println("text: '" + text + "'");
        Assert.assertTrue((boolean)text.contains("one two three four five six seven"));
    }

    @Test
    public void testOrderedListBlockHandling() throws Exception {
        this.parser.parse("<html><body><ol><li> one </li><li>    two </li></ol></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text:\n" + text);
        Assert.assertTrue((boolean)text.contains("\t1. one\n\t2. two"));
    }

    @Test
    public void testOrderedListBlockHandling2() throws Exception {
        this.parser.parse("<html><body><ol><li> <b>one</b> </li><li>    two </li></ol></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text: '" + text + "'");
        Assert.assertTrue((boolean)text.contains("\t1. one\n\t2. two"));
    }

    @Test
    public void testUnorderedListBlockHandling() throws Exception {
        this.parser.setBulletChars(new char[]{'A', 'B', 'C'});
        this.parser.parse("<html><body><ul><li> one</li><li>    two<ul><li>two.one</li></ul></li></ul></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text:\n" + text);
        Assert.assertTrue((boolean)text.contains("\tA  one\n\tA  two\n\t\tB  two.one"));
    }

    @Test
    public void testParagraphBlockHandling() throws Exception {
        this.parser.parse("<html><body><p>first para\n\nwith some newlines</p>\n\n<p>second para</p></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text: '" + text + "'");
        Assert.assertTrue((boolean)text.contains("first para with some newlines\n\nsecond para"));
    }

    @Test
    public void testParagraphBlockHandlingWithBR() throws Exception {
        this.parser.parse("<html><body><p>first para<br/>\nwith one newline plus br</p>\n\n<p>second para</p></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text: '" + text + "'");
        Assert.assertTrue((boolean)text.contains("first para\nwith one newline plus br\n\nsecond para"));
    }

    @Test
    public void testParagraphBlockHandlingWithBR2() throws Exception {
        this.parser.parse("<html><body><p>first para<br/>with one newline plus br</p>\n\n<p>second para</p></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text: '" + text + "'");
        Assert.assertTrue((boolean)text.contains("first para\nwith one newline plus br\n\nsecond para"));
    }

    @Test
    public void testDefinitionList() throws Exception {
        this.parser.parse("<html><body><dl><dt>foo</dt><dd>bar baz</dd></dl></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text:\n" + text + "'");
        Assert.assertTrue((boolean)text.contains("foo\n\tbar baz"));
    }

    @Test
    public void testNonParaText() throws Exception {
        this.parser.parse("<html><body><p>one</p>two<p>three</p></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text:\n" + text);
        Assert.assertTrue((boolean)text.contains("one\n\ntwo\n\nthree"));
    }

    @Test
    public void testBlockQuoteParaWhitespace() throws Exception {
        this.parser.parse("<html><body><p>one</p><blockquote><p>two</p></blockquote><p>three</p></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text:\n" + text);
        Assert.assertTrue((boolean)text.contains("one\n\n\ttwo\n\nthree"));
    }

    @Test
    public void testBR() throws Exception {
        this.parser.parse("<html><head></head><body><p>One<br/>Two</p></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text:\n" + text);
        Assert.assertTrue((boolean)text.contains("One\nTwo"));
    }

    @Test
    public void testWhitespaceAfterTable() throws Exception {
        this.parser.parse("<html><head></head><body>before<table><tr><td>in1</td></tr><tr><td>in2</td></tr></table>after</body></html>");
        String text = this.parser.getText();
        TestUtil.println("text:\n" + text);
        Assert.assertTrue((boolean)text.contains("in1 \t\nin2 \t\n\nafter"));
    }

    @Test
    public void testWhitespaceAfterEmdash() throws Exception {
        String html = "<html><body><p>Foo<br/>Bar &#8212; baz</p></body></html>";
        this.parser.parse(html);
        String text = this.parser.getText();
        TestUtil.println("text:\n" + text);
        Assert.assertTrue((boolean)Pattern.compile("Bar\\s\\S\\sbaz", 8).matcher(text).find());
    }

    @Test
    public void defaultStyles() throws IOException {
        this.assertDefaultCssStyles("font-family: Arial, Helvetica, sans-serif", "p");
        this.assertDefaultCssStyles("font-family: Arial, Helvetica, sans-serif; font-size: 120%; font-weight: bold; color: #172f47", "h1");
        this.assertDefaultCssStyles("font-family: Arial, Helvetica, sans-serif; font-size: 110%; font-weight: bold; color: #172f47", "h2");
        this.assertDefaultCssStyles("font-family: Arial, Helvetica, sans-serif; text-decoration: underline; color: blue", "a");
    }

    private Stylesheet defaultStylesheet() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Reader reader = HtmlTextPresentationParser.getDefaultStylesheetContent();){
                return new CssParser().parse(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void assertDefaultCssStyles(String expectedStyles, final String elementName) {
        Stylesheet stylesheet = this.defaultStylesheet();
        final ArrayList styles = new ArrayList();
        Stylesheet.Receiver receiver = new Stylesheet.Receiver(){

            public void apply(CssRule rule) {
                styles.add(String.valueOf(rule.name) + ": " + rule.value);
            }
        };
        stylesheet.applyTo(new ElementInfo(){

            public boolean hasId(String id) {
                return false;
            }

            public boolean hasCssClass(String cssClass) {
                return false;
            }

            public ElementInfo getParent() {
                return null;
            }

            public String getLocalName() {
                return elementName;
            }
        }, receiver);
        Assert.assertEquals((String)("element " + elementName), (Object)expectedStyles, (Object)Joiner.on((String)"; ").join(styles));
    }
}

