/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tracwiki.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.token.WikiWordReplacementToken;

public class WikiWordReplacementTokenTest
extends TestCase {
    private static final String SUFFIX = ". And so on...";
    private static final String PREFIX = "A Wiki-Word: ";
    private Pattern pattern;

    protected void setUp() throws Exception {
        this.pattern = new TestWikiWordReplacementToken().createPattern();
    }

    protected void tearDown() throws Exception {
        this.pattern = null;
    }

    public void testRegex() throws Exception {
        this.assertIsWikiWord("WikiWord");
        this.assertIsWikiWord("WikiWordExtra");
        this.assertIsNotWikiWord("Word");
        this.assertIsNotWikiWord("XML");
        this.assertIsNotWikiWord("HTML");
        this.assertIsNotWikiWord("XML-based");
        this.assertIsNotWikiWord("time-aligned");
        this.assertIsNotWikiWord("X-Ray");
        this.assertIsNotWikiWord("XRay");
        this.assertIsNotWikiWord("eClass");
        this.assertIsNotWikiWord("AbbA");
        this.assertIsNotWikiWord("H2O");
        this.assertIsNotWikiWord("Not-Wiki-Word");
        this.assertIsNotWikiWord("WIkiWord");
        this.assertIsNotWikiWord("Wiki-Word");
        this.assertIsNotWikiWord("Wi-kiWord");
        this.assertIsNotWikiWord("Ww3Word");
        this.assertIsNotWikiWord("WikiWWWord");
        this.assertPartialWikiWord("WikiWordX");
        this.assertPartialWikiWord("WikiWordNOT");
        this.assertPartialWikiWord("WikiWo-rd");
        this.assertPartialWikiWord("1WikiWord");
        this.assertPartialWikiWord("WikiWord2");
        this.assertPartialWikiWord("O2WikiWord");
    }

    private void assertIsWikiWord(String wikiWord) {
        Matcher matcher = this.pattern.matcher(PREFIX + wikiWord + SUFFIX);
        WikiWordReplacementTokenTest.assertTrue((boolean)matcher.find());
        WikiWordReplacementTokenTest.assertEquals((int)PREFIX.length(), (int)matcher.start());
        WikiWordReplacementTokenTest.assertEquals((int)(PREFIX.length() + wikiWord.length()), (int)matcher.end());
    }

    private void assertIsNotWikiWord(String wikiWord) {
        Matcher matcher = this.pattern.matcher(PREFIX + wikiWord + SUFFIX);
        WikiWordReplacementTokenTest.assertFalse((boolean)matcher.find());
    }

    private void assertPartialWikiWord(String wikiWord) {
        Matcher matcher = this.pattern.matcher(PREFIX + wikiWord + SUFFIX);
        WikiWordReplacementTokenTest.assertTrue((boolean)matcher.find());
        WikiWordReplacementTokenTest.assertFalse((PREFIX.length() == matcher.start() && PREFIX.length() + wikiWord.length() == matcher.end() ? 1 : 0) != 0);
    }

    private class TestWikiWordReplacementToken
    extends WikiWordReplacementToken {
        private static final int NOT_USED = -1;

        private TestWikiWordReplacementToken() {
        }

        private Pattern createPattern() {
            return Pattern.compile(this.getPattern(-1));
        }
    }
}

