/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.MediaWikiIdGenerationStrategy;

public class MediaWikiIdGenerationStrategyTest
extends TestCase {
    MediaWikiIdGenerationStrategy generationStrategy;

    protected void setUp() throws Exception {
        super.setUp();
        this.generationStrategy = new MediaWikiIdGenerationStrategy();
    }

    public void testSimple() {
        MediaWikiIdGenerationStrategyTest.assertEquals((String)"Bugzilla_Connector", (String)this.generationStrategy.generateId("Bugzilla Connector"));
        MediaWikiIdGenerationStrategyTest.assertEquals((String)"JIRA_Connector", (String)this.generationStrategy.generateId("JIRA Connector"));
        MediaWikiIdGenerationStrategyTest.assertEquals((String)"Keyboard_mappings_on_Linux", (String)this.generationStrategy.generateId("Keyboard mappings on Linux"));
        MediaWikiIdGenerationStrategyTest.assertEquals((String)"Alt.2BClick_navigation", (String)this.generationStrategy.generateId("Alt+Click navigation"));
    }

    public void testWithDots() {
        MediaWikiIdGenerationStrategyTest.assertEquals((String)"com.foo.Bar", (String)this.generationStrategy.generateId("com.foo.Bar"));
    }

    public void testHeadingTextToId() {
        MediaWikiIdGenerationStrategyTest.assertEquals((String)"Anchor_Text.3F", (String)this.generationStrategy.generateId("Anchor Text?"));
        MediaWikiIdGenerationStrategyTest.assertEquals((String)"This.2FSection", (String)this.generationStrategy.generateId("This/Section"));
        MediaWikiIdGenerationStrategyTest.assertEquals((String)"C.23_Implementation", (String)this.generationStrategy.generateId("C# Implementation"));
    }
}

