/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core.validation;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.textile.core.validation.TextileReferenceValidationRule;
import org.eclipse.mylyn.wikitext.core.validation.MarkupValidator;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;
import org.eclipse.mylyn.wikitext.tests.TestUtil;

public class TextileReferenceValidationRuleTest
extends TestCase {
    private TextileReferenceValidationRule rule;
    private MarkupValidator validator;

    protected void setUp() throws Exception {
        super.setUp();
        this.rule = new TextileReferenceValidationRule();
        this.validator = new MarkupValidator();
        this.validator.getRules().add(this.rule);
    }

    public void testNoErrors() {
        List problems = this.rule.findProblems("h1. Title\n\n\"a link\":#Title", 0, "h1. Title\n\n\"a link\":#Title".length());
        TestUtil.println(problems);
        TextileReferenceValidationRuleTest.assertNotNull((Object)problems);
        TextileReferenceValidationRuleTest.assertTrue((boolean)problems.isEmpty());
    }

    public void testErrors() {
        List problems = this.rule.findProblems("h1. Title\n\nsome text \"a link\":#BADTitle more text", 0, "h1. Title\n\nsome text \"a link\":#BADTitle more text".length());
        TestUtil.println(problems);
        TextileReferenceValidationRuleTest.assertNotNull((Object)problems);
        TextileReferenceValidationRuleTest.assertEquals((int)1, (int)problems.size());
        TextileReferenceValidationRuleTest.assertEquals((int)21, (int)((ValidationProblem)problems.get(0)).getOffset());
        TextileReferenceValidationRuleTest.assertEquals((int)18, (int)((ValidationProblem)problems.get(0)).getLength());
    }

    public void testFootnoteReference() {
        String markup = "some text with a footnote reference[1]\n\nfn1. a footnote";
        List problems = this.rule.findProblems(markup, 0, markup.length());
        TestUtil.println(problems);
        TextileReferenceValidationRuleTest.assertNotNull((Object)problems);
        TextileReferenceValidationRuleTest.assertEquals((int)0, (int)problems.size());
    }

    public void testFootnoteReferenceWithErrors() {
        String markup = "some text with a footnote reference[1]\n\nfn2. a footnote";
        List problems = this.rule.findProblems(markup, 0, markup.length());
        TestUtil.println(problems);
        TextileReferenceValidationRuleTest.assertNotNull((Object)problems);
        TextileReferenceValidationRuleTest.assertEquals((int)1, (int)problems.size());
        TextileReferenceValidationRuleTest.assertEquals((int)35, (int)((ValidationProblem)problems.get(0)).getOffset());
        TextileReferenceValidationRuleTest.assertEquals((int)3, (int)((ValidationProblem)problems.get(0)).getLength());
    }
}

