/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.egit;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.reflect.MethodUtils;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.reviews.ui.compare.CompareUtil;
import org.eclipse.mylyn.reviews.core.model.IFileVersion;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;

public class GitFileRevisionUtils {
    private static String PLUGIN_ID = "org.eclipse.mylyn.reviews.core";

    public static IFileRevision getFileRevision(final Repository repository, IFileVersion reviewFileVersion) {
        FileRevision gitFileRevision = null;
        if (reviewFileVersion != null && reviewFileVersion.getPath() != null) {
            ObjectId objId;
            ObjectInserter inserter = repository.newObjectInserter();
            String id = inserter.idFor(3, CompareUtil.getContent((IFileVersion)reviewFileVersion)).getName();
            GitFileRevisionUtils.release(inserter);
            if (id != null && (objId = ObjectId.fromString((String)id)) != null) {
                final IPath path = Path.fromPortableString((String)reviewFileVersion.getPath());
                gitFileRevision = new FileRevision(){

                    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
                        return this;
                    }

                    public boolean isPropertyMissing() {
                        return false;
                    }

                    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
                        return GitFileRevisionUtils.getFileRevisionStorage(null, repository, path, objId);
                    }

                    public String getName() {
                        return path.lastSegment();
                    }
                };
            }
        }
        return gitFileRevision;
    }

    private static void release(ObjectInserter inserter) {
        try {
            MethodUtils.invokeMethod((Object)inserter, (String)"release", null);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            try {
                MethodUtils.invokeMethod((Object)inserter, (String)"close", null);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.ui", "Failed to release inserter " + inserter, (Throwable)e1));
            }
        }
    }

    private static IStorage getFileRevisionStorage(final IProgressMonitor monitor, final Repository repository, final IPath path, final ObjectId objId) {
        return new IStorage(){

            public Object getAdapter(Class adapter) {
                return null;
            }

            public boolean isReadOnly() {
                return true;
            }

            public String getName() {
                return path.lastSegment();
            }

            public IPath getFullPath() {
                return path.append(Path.fromPortableString((String)objId.getName()));
            }

            public InputStream getContents() throws CoreException {
                InputStream in = null;
                try {
                    in = GitFileRevisionUtils.getBlobContent(monitor, repository, objId);
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, PLUGIN_ID, e.getMessage()));
                }
                return in;
            }
        };
    }

    private static InputStream getBlobContent(IProgressMonitor monitor, Repository repository, ObjectId objId) throws CoreException {
        ObjectStream resStream = null;
        try {
            resStream = repository.open((AnyObjectId)objId, 3).openStream();
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, e.getMessage()));
        }
        return resStream;
    }
}

