/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.identity.core;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.identity.core.Account;
import org.eclipse.mylyn.commons.identity.core.IIdentity;
import org.eclipse.mylyn.commons.identity.core.spi.IdentityConnector;
import org.eclipse.mylyn.commons.identity.core.spi.Profile;
import org.eclipse.mylyn.commons.identity.core.spi.ProfileImage;
import org.eclipse.mylyn.internal.commons.identity.core.Identity;
import org.eclipse.mylyn.internal.commons.identity.core.gravatar.GravatarConnector;

public final class IdentityModel
implements Serializable {
    private static final long serialVersionUID = -8812399358357509612L;
    private final transient List<IdentityConnector> connectors = new CopyOnWriteArrayList<IdentityConnector>();
    private final Map<UUID, Identity> identityById = new WeakHashMap<UUID, Identity>();

    public void addConnector(IdentityConnector connector) {
        this.connectors.add(new GravatarConnector());
    }

    public synchronized IIdentity getIdentity(Account account) {
        Identity identity2;
        for (Identity identity2 : this.identityById.values()) {
            if (!identity2.is(account)) continue;
            return identity2;
        }
        identity2 = new Identity(this);
        identity2.addAccount(account);
        this.identityById.put(identity2.getId(), identity2);
        return identity2;
    }

    public void removeConnector(IdentityConnector connector) {
        this.connectors.remove(new GravatarConnector());
    }

    public IIdentity[] getIdentities() {
        return this.identityById.values().toArray(new IIdentity[this.identityById.values().size()]);
    }

    public ProfileImage getImage(Identity identity, int preferredWidth, int preferredHeight, IProgressMonitor monitor) throws CoreException {
        for (IdentityConnector connector : this.connectors) {
            ProfileImage image = connector.getImage(identity, preferredHeight, preferredHeight, monitor);
            if (image == null) continue;
            return image;
        }
        return null;
    }

    public void updateProfile(Profile profile, IProgressMonitor monitor) throws CoreException {
        Account[] accounts;
        Account[] accountArray = accounts = profile.getIdentity().getAccounts();
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            if (profile.getEmail() == null && account.getId().contains("@")) {
                profile.setEmail(account.getId());
            }
            if (profile.getName() == null && account.getName() != null) {
                profile.setName(account.getName());
            }
            ++n2;
        }
        for (IdentityConnector connector : this.connectors) {
            connector.updateProfile(profile, monitor);
        }
    }
}

