/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.versions.core;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.XmlMemento;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectSetConverter {
    public static ByteArrayOutputStream exportProjectSet(List<IProject> projects) throws CoreException {
        HashMap<String, TreeSet<IProject>> map = new HashMap<String, TreeSet<IProject>>();
        for (IProject project : projects) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
            if (provider == null) continue;
            String id = provider.getID();
            TreeSet<IProject> list = (TreeSet<IProject>)map.get(id);
            if (list == null) {
                list = new TreeSet<IProject>(new Comparator<IProject>(){

                    @Override
                    public int compare(IProject o1, IProject o2) {
                        return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
                    }
                });
                map.put(id, list);
            }
            list.add(project);
        }
        BufferedWriter writer = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)output, "UTF-8"));
            XmlMemento xmlMemento = ProjectSetConverter.getXMLMementoRoot();
            for (String id : map.keySet()) {
                String[] references;
                XmlMemento memento = xmlMemento.createChild("provider");
                memento.putString("id", id);
                Set list = (Set)map.get(id);
                IProject[] projectArray = list.toArray(new IProject[list.size()]);
                RepositoryProviderType providerType = RepositoryProviderType.getProviderType((String)id);
                ProjectSetCapability serializer = providerType.getProjectSetCapability();
                ProjectSetCapability.ensureBackwardsCompatible((RepositoryProviderType)providerType, (ProjectSetCapability)serializer);
                if (serializer == null) continue;
                String[] stringArray = references = serializer.asReference(projectArray, null, null);
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    String reference = stringArray[n2];
                    XmlMemento proj = memento.createChild("project");
                    proj.putString("reference", reference);
                    ++n2;
                }
            }
            xmlMemento.save((Writer)writer);
            ByteArrayOutputStream byteArrayOutputStream = output;
            return byteArrayOutputStream;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.versions.core", "Unexpected error exporting project sets.", (Throwable)e));
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static List<String> readProjectReferences(InputStream input, RepositoryProviderType providerType) throws CoreException {
        try {
            XmlMemento[] providers;
            ArrayList<String> referenceStrings = new ArrayList<String>();
            XmlMemento[] xmlMementoArray = providers = ProjectSetConverter.importProjectSet(input);
            int n = providers.length;
            int n2 = 0;
            while (n2 < n) {
                XmlMemento provider = xmlMementoArray[n2];
                if (provider.getString("id").equals(providerType.getID())) {
                    XmlMemento[] projects;
                    XmlMemento[] xmlMementoArray2 = projects = provider.getChildren("project");
                    int n3 = projects.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        XmlMemento project = xmlMementoArray2[n4];
                        referenceStrings.add(project.getString("reference"));
                        ++n4;
                    }
                }
                ++n2;
            }
            return referenceStrings;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.versions.core", "Unexpected error reading project sets.", (Throwable)e));
        }
    }

    private static XmlMemento getXMLMementoRoot() throws ParserConfigurationException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element = document.createElement("psf");
        element.setAttribute("version", "2.0");
        document.appendChild(element);
        return new XmlMemento(document, element);
    }

    private static XmlMemento[] importProjectSet(InputStream input) throws UnsupportedEncodingException, InvocationTargetException {
        XmlMemento xmlMemento = ProjectSetConverter.parseStream(input);
        return xmlMemento.getChildren("provider");
    }

    private static XmlMemento parseStream(InputStream input) throws InvocationTargetException, UnsupportedEncodingException {
        InputStreamReader reader = new InputStreamReader(input, "UTF-8");
        try {
            XmlMemento xmlMemento = XmlMemento.createReadRoot((Reader)reader);
            return xmlMemento;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }
}

